require '_h2ph_pre.ph';

unless(defined(&_MACHINE_CPU_H_)) {
    eval 'sub _MACHINE_CPU_H_ () {1;}' unless defined(&_MACHINE_CPU_H_);
    unless(defined(&LOCORE)) {
	require 'machine/frame.ph';
	require 'machine/segments.ph';
	require 'machine/psl.ph';
	unless(defined(&STANDALONE)) {
	    if(defined(&KERNEL)) {
		require 'machine/inline.ph';
	    }
	    require 'machine/pcpu.ph';
	}
	require 'sys/entropy.ph';
	eval 'sub COPY_SIGCODE () {1;}' unless defined(&COPY_SIGCODE);
	eval 'sub cpu_exec {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_exec);
	eval 'sub cpu_swapin {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_swapin);
	eval 'sub cpu_setstack {
	    local($p, $ap) = @_;
    	    eval q(($p)-> ($p_md->{md_regs[&SP]}) = $ap);
	}' unless defined(&cpu_setstack);
	eval 'sub cpu_set_init_frame {
	    local($p, $fp) = @_;
    	    eval q();
	}' unless defined(&cpu_set_init_frame);
	eval 'sub cpu_kernproc {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_kernproc);
	eval 'sub cpu_endkernproc {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_endkernproc);
	eval 'sub COLLECT_ENTROPY {
	    local($x) = @_;
    	    eval q(((* &collect_entropy)($x)));
	}' unless defined(&COLLECT_ENTROPY);
	eval 'sub CLKF_USERMODE {
	    local($framep) = @_;
    	    eval q(((($framep)-> ($cf_if->{if_eflags}) &  &PSL_VM) || ( &ISPL(($framep)-> ($cf_if->{if_cs})) ==  &SEL_UPL)));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_BASEPRI {
	    local($framep) = @_;
    	    eval q((($framep)-> ($cf_if->{if_ppl}) ==  &nonemask));
	}' unless defined(&CLKF_BASEPRI);
	eval 'sub CLKF_PC {
	    local($framep) = @_;
    	    eval q((($framep)-> ($cf_if->{if_eip})));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    local($framep) = @_;
    	    eval q(0);
	}' unless defined(&CLKF_INTR);
	eval 'sub CYCLE_COUNTER {
	    local($x) = @_;
    	    eval q( &do {  &if ( &cpu >=  &CPU_586)  &rdtsc($x);  &else ($x) = 0; }  &while (0));
	}' unless defined(&CYCLE_COUNTER);
	eval 'sub CLK_RATES () {8;}' unless defined(&CLK_RATES);
	eval 'sub USE_MICROTIME_IN_HARDCLOCK () {1;}' unless defined(&USE_MICROTIME_IN_HARDCLOCK);
	eval 'sub RESCHED_SWITCH () {1;}' unless defined(&RESCHED_SWITCH);
	eval 'sub RESCHED_NORMAL () {2;}' unless defined(&RESCHED_NORMAL);
	eval 'sub RESCHED_ROUND_ROBIN () {4;}' unless defined(&RESCHED_ROUND_ROBIN);
	eval 'sub need_resched {
	    local($type) = @_;
    	    eval q( &do {  &SET_PCPU( &want_resched, $type);  &aston(); }  &while (0));
	}' unless defined(&need_resched);
	eval 'sub need_proftick {
	    local($p) = @_;
    	    eval q( &do { ($p)-> &p_flag |=  &P_OWEUPC;  &aston(); }  &while (0));
	}' unless defined(&need_proftick);
	eval 'sub aston () {
	    eval q( &INC_PCPU( &astpending));
	}' unless defined(&aston);
	eval 'sub setsoftclock () {
	    eval q( &schednetisr( &NETISR_SCLK));
	}' unless defined(&setsoftclock);
	eval 'sub setsoftnet () {
	    eval q( &lockd_or( &ipending,  &IRQSOFT));
	}' unless defined(&setsoftnet);
    }
    eval 'sub CPUID_MASK_RESV () {0xf0000000;}' unless defined(&CPUID_MASK_RESV);
    eval 'sub CPUID_MASK_XFAMILY () {0x0ff00000;}' unless defined(&CPUID_MASK_XFAMILY);
    eval 'sub CPUID_MASK_XMODEL () {0x000f0000;}' unless defined(&CPUID_MASK_XMODEL);
    eval 'sub CPUID_MASK_TYPE () {0x00003000;}' unless defined(&CPUID_MASK_TYPE);
    eval 'sub CPUID_MASK_FAMILY () {0x00000f00;}' unless defined(&CPUID_MASK_FAMILY);
    eval 'sub CPUID_MASK_MODEL () {0x000000f0;}' unless defined(&CPUID_MASK_MODEL);
    eval 'sub CPUID_MASK_STEPPING () {0x0000000f;}' unless defined(&CPUID_MASK_STEPPING);
    eval 'sub CPUID_SHIFT_XFAMILY () {16;}' unless defined(&CPUID_SHIFT_XFAMILY);
    eval 'sub CPUID_SHIFT_XMODEL () {12;}' unless defined(&CPUID_SHIFT_XMODEL);
    eval 'sub CPUID_SHIFT_MODEL () {4;}' unless defined(&CPUID_SHIFT_MODEL);
    eval 'sub CPUID_SHIFT_FAMILY () {8;}' unless defined(&CPUID_SHIFT_FAMILY);
    eval 'sub CPUID_SHIFT_TYPE () {12;}' unless defined(&CPUID_SHIFT_TYPE);
    eval 'sub CPU_FAMILY_EXT () {0xf;}' unless defined(&CPU_FAMILY_EXT);
    eval 'sub CPU_MODEL_EXT () {0xf;}' unless defined(&CPU_MODEL_EXT);
    eval 'sub CPUID_TYPE_OEM () {0;}' unless defined(&CPUID_TYPE_OEM);
    eval 'sub CPUID_TYPE_OVERDRIVE () {1;}' unless defined(&CPUID_TYPE_OVERDRIVE);
    eval 'sub CPUID_TYPE_DUAL () {2;}' unless defined(&CPUID_TYPE_DUAL);
    eval 'sub CPUID_TYPE {
        local($id) = @_;
	    eval q(((($id) &  &CPUID_MASK_TYPE) >>  &CPUID_SHIFT_TYPE));
    }' unless defined(&CPUID_TYPE);
    eval 'sub CPUID_FAMILY {
        local($id) = @_;
	    eval q(({ \'int\'  &__family = (($id) &  &CPUID_MASK_FAMILY) >>  &CPUID_SHIFT_FAMILY;  &if ( &__family ==  &CPU_FAMILY_EXT)  &__family |= (($id) &  &CPUID_MASK_XFAMILY) >>  &CPUID_SHIFT_XFAMILY;  &__family; }));
    }' unless defined(&CPUID_FAMILY);
    eval 'sub CPUID_MODEL {
        local($id) = @_;
	    eval q(({ \'int\'  &__model = (($id) &  &CPUID_MASK_MODEL) >>  &CPUID_SHIFT_MODEL;  &if ( &__model ==  &CPU_MODEL_EXT)  &__model |= (($id) &  &CPUID_MASK_XMODEL) >>  &CPUID_SHIFT_XMODEL;  &__model; }));
    }' unless defined(&CPUID_MODEL);
    eval 'sub CPUID_STEPPING {
        local($id) = @_;
	    eval q((($id) &  &CPUID_MASK_STEPPING));
    }' unless defined(&CPUID_STEPPING);
    eval 'sub CPU_386SX () {1;}' unless defined(&CPU_386SX);
    eval 'sub CPU_386 () {2;}' unless defined(&CPU_386);
    eval 'sub CPU_486SX () {3;}' unless defined(&CPU_486SX);
    eval 'sub CPU_486 () {4;}' unless defined(&CPU_486);
    eval 'sub CPU_586 () {5;}' unless defined(&CPU_586);
    eval 'sub CPU_686 () {6;}' unless defined(&CPU_686);
    eval 'sub CPU_P4 () {0x0f;}' unless defined(&CPU_P4);
    eval 'sub CPUID_FEAT_FPU () {0x00000001;}' unless defined(&CPUID_FEAT_FPU);
    eval 'sub CPUID_FEAT_VME () {0x00000002;}' unless defined(&CPUID_FEAT_VME);
    eval 'sub CPUID_FEAT_DE () {0x00000004;}' unless defined(&CPUID_FEAT_DE);
    eval 'sub CPUID_FEAT_PSE () {0x00000008;}' unless defined(&CPUID_FEAT_PSE);
    eval 'sub CPUID_FEAT_TSC () {0x00000010;}' unless defined(&CPUID_FEAT_TSC);
    eval 'sub CPUID_FEAT_MSR () {0x00000020;}' unless defined(&CPUID_FEAT_MSR);
    eval 'sub CPUID_FEAT_PAE () {0x00000040;}' unless defined(&CPUID_FEAT_PAE);
    eval 'sub CPUID_FEAT_MCE () {0x00000080;}' unless defined(&CPUID_FEAT_MCE);
    eval 'sub CPUID_FEAT_CX8 () {0x00000100;}' unless defined(&CPUID_FEAT_CX8);
    eval 'sub CPUID_FEAT_APIC () {0x00000200;}' unless defined(&CPUID_FEAT_APIC);
    eval 'sub CPUID_FEAT_SEP () {0x00000800;}' unless defined(&CPUID_FEAT_SEP);
    eval 'sub CPUID_FEAT_MTRR () {0x00001000;}' unless defined(&CPUID_FEAT_MTRR);
    eval 'sub CPUID_FEAT_PGE () {0x00002000;}' unless defined(&CPUID_FEAT_PGE);
    eval 'sub CPUID_FEAT_MCA () {0x00004000;}' unless defined(&CPUID_FEAT_MCA);
    eval 'sub CPUID_FEAT_CMOV () {0x00008000;}' unless defined(&CPUID_FEAT_CMOV);
    eval 'sub CPUID_FEAT_PAT () {0x00010000;}' unless defined(&CPUID_FEAT_PAT);
    eval 'sub CPUID_FEAT_PSE36 () {0x00020000;}' unless defined(&CPUID_FEAT_PSE36);
    eval 'sub CPUID_FEAT_PSN () {0x00040000;}' unless defined(&CPUID_FEAT_PSN);
    eval 'sub CPUID_FEAT_CLFLUSH () {0x00080000;}' unless defined(&CPUID_FEAT_CLFLUSH);
    eval 'sub CPUID_FEAT_DTS () {0x00200000;}' unless defined(&CPUID_FEAT_DTS);
    eval 'sub CPUID_FEAT_ACPI () {0x00400000;}' unless defined(&CPUID_FEAT_ACPI);
    eval 'sub CPUID_FEAT_MMX () {0x00800000;}' unless defined(&CPUID_FEAT_MMX);
    eval 'sub CPUID_FEAT_FXSR () {0x01000000;}' unless defined(&CPUID_FEAT_FXSR);
    eval 'sub CPUID_FEAT_SSE () {0x02000000;}' unless defined(&CPUID_FEAT_SSE);
    eval 'sub CPUID_FEAT_SSE2 () {0x04000000;}' unless defined(&CPUID_FEAT_SSE2);
    eval 'sub CPUID_FEAT_SS () {0x08000000;}' unless defined(&CPUID_FEAT_SS);
    eval 'sub CPUID_FEAT_TM () {0x02000000;}' unless defined(&CPUID_FEAT_TM);
    eval 'sub CPUID_BRAND_MAX () {0x80000000;}' unless defined(&CPUID_BRAND_MAX);
    eval 'sub CPUID_BRAND_BITS () {0x80000001;}' unless defined(&CPUID_BRAND_BITS);
    eval 'sub CPUID_BRAND_STR1 () {0x80000002;}' unless defined(&CPUID_BRAND_STR1);
    eval 'sub CPUID_BRAND_STR2 () {0x80000003;}' unless defined(&CPUID_BRAND_STR2);
    eval 'sub CPUID_BRAND_STR3 () {0x80000004;}' unless defined(&CPUID_BRAND_STR3);
    eval 'sub CPUID_MASK_BRAND () {0x000000ff;}' unless defined(&CPUID_MASK_BRAND);
    if(defined(&BRAND_TABLE)) {
    }
    unless(defined(&LOCORE)) {
	if(defined(&KERNEL)) {
	}
	eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
	eval 'sub CPU_BIOS () {2;}' unless defined(&CPU_BIOS);
	eval 'sub CPU_CNTLALTDEL () {3;}' unless defined(&CPU_CNTLALTDEL);
	eval 'sub CPU_CNTLALTDELCORE () {4;}' unless defined(&CPU_CNTLALTDELCORE);
	eval 'sub CPU_PARITYERRORPANIC () {5;}' unless defined(&CPU_PARITYERRORPANIC);
	eval 'sub CPU_IPROF () {6;}' unless defined(&CPU_IPROF);
	eval 'sub CPU_MAXID () {7;}' unless defined(&CPU_MAXID);
	eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "bios",  &CTLTYPE_NODE }, { "cntlaltdel",  &CTLTYPE_INT }, { "cntlaltdelcore",  &CTLTYPE_INT }, { "parityerrorpanic",  &CTLTYPE_INT }, { "iprof",  &CTLTYPE_NODE }, };}' unless defined(&CTL_MACHDEP_NAMES);
	eval 'sub BIOS_DISKGEOM () {1;}' unless defined(&BIOS_DISKGEOM);
	if(defined(&notyet)) {
	    eval 'sub BIOS_INFO () {2;}' unless defined(&BIOS_INFO);
	}
	eval 'sub BIOS_MAXID () {2;}' unless defined(&BIOS_MAXID);
	eval 'sub CTL_BIOS_NAMES () {{ { 0, 0}, { "diskgeom",  &CTLTYPE_STRUCT }, };}' unless defined(&CTL_BIOS_NAMES);
    }
}
1;
