require '_h2ph_pre.ph';

unless(defined(&__INLINE_H)) {
    eval 'sub __INLINE_H () {1;}' unless defined(&__INLINE_H);
    if(defined(&__GNUC__)) {
	require 'i386/isa/icu.ph';
	eval 'sub SCHED_BARRIER () { &asm  &volatile ("# scheduling barrier");}' unless defined(&SCHED_BARRIER);
	eval 'sub splmem_fast () {
	    eval q(({  &extern \'u_int\'  &cpl;  &asm  &volatile (\\"cli\\");  &cpl; }));
	}' unless defined(&splmem_fast);
	eval 'sub splxmem_fast {
	    local($s) = @_;
    	    eval q({ \'int\'  &__attribute__(( &unused)) &_notused = ($s);  &asm  &volatile (\\"sti\\"); });
	}' unless defined(&splxmem_fast);
	require 'sys/ktr.ph';
	if((defined(&KTR_COMPILE) ? &KTR_COMPILE : 0) & (defined(&KTR_SPL) ? &KTR_SPL : 0)) {
	    eval 'sub SPLRT {
	        local($dsc, $v) = @_;
    		eval q( &CTR4( &KTR_SPL, $dsc ,  &__FILE__,  &__LINE__,  &cpl, $v););
	    }' unless defined(&SPLRT);
	} else {
	    eval 'sub SPLRT {
	        local($dsc, $v) = @_;
    		eval q();
	    }' unless defined(&SPLRT);
	}
	eval 'sub spldraise {
	    local($dsc, $v) = @_;
    	    eval q(({ \'int\'  &ocpl;  &SCHED_BARRIER;  &ocpl =  &cpl;  &SPLRT($dsc, $v);  &asm  &volatile (\\"lock; orl %1,cpl\\" : \\"=m\\" ( &cpl) : \\"ri\\" (($v)));  &ocpl; }));
	}' unless defined(&spldraise);
	eval 'sub splraise {
	    local($v) = @_;
    	    eval q(({  &register \'int\'  &tcpl = ($v);  &if ( &do_pic_chk &  &tcpl)  &tcpl =  $irq2mask[ &ffs( &tcpl)-1];  &spldraise( &tr_splraise,  &tcpl); }));
	}' unless defined(&splraise);
	eval 'sub spltty () {
	    eval q( &spldraise( &tr_spltty,  &ttymask));
	}' unless defined(&spltty);
	eval 'sub splnet () {
	    eval q( &spldraise( &tr_splnet,  &IRQSOFT));
	}' unless defined(&splnet);
	eval 'sub splclock () {
	    eval q( &spldraise( &tr_splclock,  &highmask));
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &spldraise( &tr_splstatclock,  &highmask));
	}' unless defined(&splstatclock);
	eval 'sub splhigh () {
	    eval q( &spldraise( &tr_splhigh,  &highmask));
	}' unless defined(&splhigh);
	eval 'sub splbio () {
	    eval q( &spldraise( &tr_splbio,  &biomask));
	}' unless defined(&splbio);
	eval 'sub splimp () {
	    eval q( &spldraise( &tr_splimp,  &impmask));
	}' unless defined(&splimp);
	eval 'sub splmem () {
	    eval q( &spldraise( &tr_splmem,  &memmask));
	}' unless defined(&splmem);
	if((defined(&KTR_COMPILE) ? &KTR_COMPILE : 0) & (defined(&KTR_SPL) ? &KTR_SPL : 0)) {
	    eval 'sub SPLSCT () { &CTR4( &KTR_GEN, "splsoftclock (splx) %s:%d %x -> %x",  &__FILE__,  &__LINE__,  &cpl,  &protomask);}' unless defined(&SPLSCT);
	    eval 'sub SPLSCTE () { &CTR2( &KTR_GEN, "splsoftclock done %s:%d",  &__FILE__,  &__LINE__);;}' unless defined(&SPLSCTE);
	} else {
	    eval 'sub SPLSCT () {1;}' unless defined(&SPLSCT);
	    eval 'sub SPLSCTE () {1;}' unless defined(&SPLSCTE);
	}
	eval 'sub splsoftclock () {
	    eval q(({ \'int\'  &ocpl =  &cpl;  &SPLSCT;  &SCHED_BARRIER;  &cpl =  &protomask;  &__splx();  &SPLSCTE;  &ocpl; }));
	}' unless defined(&splsoftclock);
	if((defined(&KTR_COMPILE) ? &KTR_COMPILE : 0) & (defined(&KTR_SPL) ? &KTR_SPL : 0)) {
	    eval 'sub SPL0T () { &CTR3( &KTR_SPL, "spl0 %s:%d, old cpl=%x",  &__FILE__,  &__LINE__,  &cpl);;}' unless defined(&SPL0T);
	    eval 'sub SPL0TE () { &CTR2( &KTR_SPL, "spl0 done %s:%d",  &__FILE__,  &__LINE__);;}' unless defined(&SPL0TE);
	} else {
	    eval 'sub SPL0T () {1;}' unless defined(&SPL0T);
	    eval 'sub SPL0TE () {1;}' unless defined(&SPL0TE);
	}
	eval 'sub spl0 () {
	    eval q(({  &SPL0T;  &SCHED_BARRIER;  &cpl =  &nonemask;  &__splx();  &SPL0TE; 0; }));
	}' unless defined(&spl0);
	if((defined(&KTR_COMPILE) ? &KTR_COMPILE : 0) & (defined(&KTR_SPL) ? &KTR_SPL : 0)) {
	    eval 'sub SPLXRT {
	        local($x) = @_;
    		eval q( &CTR4( &KTR_SPL,  &tr_splx,  &__FILE__,  &__LINE__,  &cpl, ($x)););
	    }' unless defined(&SPLXRT);
	    eval 'sub SPLXRTX () { &CTR3( &KTR_SPL,  &tr_splxdone,  &__FILE__,  &__LINE__,  &cpl);;}' unless defined(&SPLXRTX);
	} else {
	    eval 'sub SPLXRT {
	        local($x) = @_;
    		eval q();
	    }' unless defined(&SPLXRT);
	    eval 'sub SPLXRTX () {1;}' unless defined(&SPLXRTX);
	}
	eval 'sub splx {
	    local($x) = @_;
    	    eval q(({  &extern \'u_int\'  &cpl;  &SPLXRT;  &SCHED_BARRIER;  &cpl = $x;  &if ( &ipending & ~)  &__splx();  &SCHED_BARRIER;  &SPLXRTX; 0; }));
	}' unless defined(&splx);
	eval 'sub cli () {
	    eval q( &asm  &volatile (\\"cli\\"));
	}' unless defined(&cli);
	eval 'sub sti () {
	    eval q( &asm  &volatile (\\"sti\\"));
	}' unless defined(&sti);
	eval 'sub hlt () {
	    eval q( &asm  &volatile (\\"hlt\\"));
	}' unless defined(&hlt);
	eval 'sub inb {
	    local($port) = @_;
    	    eval q(({  &register \'int\'  &_inb_result;  &asm  &volatile (\\"xorl %%eax,%%eax; inb %%dx,%%al\\" : \\"=a\\" ( &_inb_result) : \\"d\\" ($port));  &_inb_result; }));
	}' unless defined(&inb);
	eval 'sub inw {
	    local($port) = @_;
    	    eval q(({  &register \'int\'  &_inb_result;  &asm  &volatile (\\"xorl %%eax,%%eax; inw %%dx,%%ax\\" : \\"=a\\" ( &_inb_result) : \\"d\\" ($port));  &_inb_result; }));
	}' unless defined(&inw);
	eval 'sub inl {
	    local($port) = @_;
    	    eval q(({  &register \'u_long _inb_result\';  &asm  &volatile (\\"inl %%dx,%%eax\\" : \\"=a\\" ( &_inb_result) : \\"d\\" ($port));  &_inb_result; }));
	}' unless defined(&inl);
	eval 'sub outb {
	    local($port, $data) = @_;
    	    eval q( &asm  &volatile (\\"outb %%al,%%dx\\" : : \\"a\\" ($data), \\"d\\" ($port)));
	}' unless defined(&outb);
	eval 'sub outw {
	    local($port, $data) = @_;
    	    eval q( &asm  &volatile (\\"outw %%ax,%%dx\\" : : \\"a\\" ($data), \\"d\\" ($port)));
	}' unless defined(&outw);
	eval 'sub outl {
	    local($port, $data) = @_;
    	    eval q( &asm  &volatile (\\"outl %%eax,%%dx\\" : : \\"a\\" ($data), \\"d\\" ($port)));
	}' unless defined(&outl);
	eval 'sub ffs {
	    local($mask) = @_;
    	    eval q(({ \'int\'  &result = ($mask);  &asm  &volatile (\\"bsfl %1,%0; leal 1(%0),%0; jnz 0f; xorl %0,%0; 0:\\" : \\"=r\\" ( &result) : \\"0\\" ( &result));  &result; }));
	}' unless defined(&ffs);
	eval 'sub INLINE_NTOH () {1;}' unless defined(&INLINE_NTOH);
	eval 'sub ntohs {
	    local($s) = @_;
    	    eval q((({  &register \'int\'  &rv;  &asm  &volatile (\\"xchgb %%al,%%ah\\" : \\"=a\\" ( &rv) : \\"0\\" ($s));  &rv; }) & 0xffff));
	}' unless defined(&ntohs);
	eval 'sub htons {
	    local($s) = @_;
    	    eval q( &ntohs($s));
	}' unless defined(&htons);
	eval 'sub ntohl {
	    local($l) = @_;
    	    eval q(({  &register \'u_long rv\';  &asm  &volatile (\\"xchgb %%al,%%ah; roll $16,%%eax; xchgb %%al,%%ah\\" : \\"=a\\" ( &rv) : \\"0\\" ($l) );  &rv; }));
	}' unless defined(&ntohl);
	eval 'sub htonl {
	    local($l) = @_;
    	    eval q( &ntohl($l));
	}' unless defined(&htonl);
	eval 'sub INLINE_MINMAX () {1;}' unless defined(&INLINE_MINMAX);
	eval 'sub imin {
	    local($a, $b) = @_;
    	    eval q(({ \'int\'  &_a = ($a),  &_b = ($b);  &_a <  &_b ?  &_a :  &_b; }));
	}' unless defined(&imin);
	eval 'sub imax {
	    local($a, $b) = @_;
    	    eval q(({ \'int\'  &_a = ($a),  &_b = ($b);  &_a >  &_b ?  &_a :  &_b; }));
	}' unless defined(&imax);
	eval 'sub min {
	    local($a, $b) = @_;
    	    eval q(({ \'unsigned int _a\' = ($a),  &_b = ($b);  &_a <  &_b ?  &_a :  &_b; }));
	}' unless defined(&min);
	eval 'sub max {
	    local($a, $b) = @_;
    	    eval q(({ \'unsigned int _a\' = ($a),  &_b = ($b);  &_a >  &_b ?  &_a :  &_b; }));
	}' unless defined(&max);
	eval 'sub lmin {
	    local($a, $b) = @_;
    	    eval q(({ \'long _a\' = ($a),  &_b = ($b);  &_a <  &_b ?  &_a :  &_b; }));
	}' unless defined(&lmin);
	eval 'sub lmax {
	    local($a, $b) = @_;
    	    eval q(({ \'long _a\' = ($a),  &_b = ($b);  &_a >  &_b ?  &_a :  &_b; }));
	}' unless defined(&lmax);
	eval 'sub ulmin {
	    local($a, $b) = @_;
    	    eval q(({ \'unsigned long _a\' = ($a),  &_b = ($b);  &_a <  &_b ?  &_a :  &_b; }));
	}' unless defined(&ulmin);
	eval 'sub ulmax {
	    local($a, $b) = @_;
    	    eval q(({ \'unsigned long _a\' = ($a),  &_b = ($b);  &_a >  &_b ?  &_a :  &_b; }));
	}' unless defined(&ulmax);
	eval 'sub lockd_and {
	    local($targ, $mask) = @_;
    	    eval q(({  &asm  &volatile (\\"lock; andl %1,%0\\" : \\"=m\\" ($targ): \\"ir\\" ($mask)); }));
	}' unless defined(&lockd_and);
	eval 'sub lockd_or {
	    local($targ, $bits) = @_;
    	    eval q(({  &asm  &volatile (\\"lock; orl %1,%0\\" : \\"=m\\" ($targ): \\"ir\\" ($bits)); }));
	}' unless defined(&lockd_or);
	eval 'sub lockd_xor {
	    local($targ, $bits) = @_;
    	    eval q(({  &asm  &volatile (\\"lock; xorl %1,%0\\" : \\"=m\\" ($targ): \\"ir\\" ($bits)); }));
	}' unless defined(&lockd_xor);
	eval 'sub lockd_inc {
	    local($targ) = @_;
    	    eval q(({  &asm  &volatile (\\"lock; incl %0\\" : \\"=m\\" ($targ)); }));
	}' unless defined(&lockd_inc);
	eval 'sub btc {
	    local($targ, $bitno) = @_;
    	    eval q(({ \'int\'  &rc;  &asm  &volatile (\\"xorl %%eax,%%eax; btc %1,%0; jnc 1f; incl %%eax;1:\\" : \\"=m\\" ($targ), \\"=a\\" ( &rc): \\"ir\\" ($bitno));  &rc; }));
	}' unless defined(&btc);
	eval 'sub bts {
	    local($targ, $bitno) = @_;
    	    eval q(({ \'int\'  &rc;  &asm  &volatile (\\"xorl %%eax,%%eax; bts %1,%0; jnc 1f; incl %%eax;1:\\" : \\"=m\\" ($targ), \\"=a\\" ( &rc): \\"ir\\" ($bitno));  &rc; }));
	}' unless defined(&bts);
	eval 'sub btr {
	    local($targ, $bitno) = @_;
    	    eval q(({ \'int\'  &rc;  &asm  &volatile (\\"xorl %%eax,%%eax; bts %1,%0; jnc 1f; incl %%eax;1:\\" : \\"=m\\" ($targ), \\"=a\\" ( &rc): \\"ir\\" ($bitno));  &rc; }));
	}' unless defined(&btr);
	eval 'sub rdtsc {
	    local($m) = @_;
    	    eval q( &asm  &volatile (\\"rdtsc; movl %%eax,%0; movl %%edx,4+%0\\" : \\"=m\\" ($m) : : \\"eax\\", \\"edx\\"));
	}' unless defined(&rdtsc);
    }
}
1;
