require '_h2ph_pre.ph';

unless(defined(&_MACHINE_MUTEX_H_)) {
    eval 'sub _MACHINE_MUTEX_H_ () {1;}' unless defined(&_MACHINE_MUTEX_H_);
    eval 'sub CACHE_LINE_SIZE () {32;}' unless defined(&CACHE_LINE_SIZE);
    eval 'sub NO_CPU () {0xff;}' unless defined(&NO_CPU);
    unless(defined(&LOCORE)) {
	if(defined(&SMP_DEBUG)) {
	}
	if(defined(&KERNEL)) {
	    eval 'sub KLOCK () {1;}' unless defined(&KLOCK);
	    eval 'sub M_SPIN () {1;}' unless defined(&M_SPIN);
	    eval 'sub M_TRY () {0;}' unless defined(&M_TRY);
	    eval 'sub mutex_enter {
	        local($m, $s) = @_;
    		eval q( &_mutex_enter($m, $s, 0,  &__WHERE__));
	    }' unless defined(&mutex_enter);
	    if(defined(&SMP_DEBUG)) {
	    }
	    if(defined(&SMP_DEBUG)) {
	    }
	    if(defined(&SMP_DEBUG)) {
	    }
	    if(defined(&SMP_DEBUG)) {
	    }
	    eval 'sub mutex_exit {
	        local($m) = @_;
    		eval q( &_mutex_exit($m, 0,  &__WHERE__));
	    }' unless defined(&mutex_exit);
	    if(defined(&SMP_DEBUG)) {
		eval 'sub _mutex_exit {
		    local($m, $special, $where) = @_;
    		    eval q( &do {  &if (($m)-> &m_count < 1|| ($m)-> &m_owner ==  &NO_CPU)  &panic(\\"mutex_exit: releasing free mutex %s\\", $where);  &if (($m)-> &m_owner !=  &PCPU( &cpuno))  &panic(\\"mutex_exit: releasing someone else\'s mutex %s\\", ($where));  &if (($m)-> &m_count == 1) {  &asm  &volatile( \\"pushfl;\\" \\"cli;\\" \\"movl	$0xff,4+%0;\\" \\"lock; decl	8+%0;\\" \\"movl	$0,%0;\\" \\"popfl;\\": \\"=m\\" (*($m)): : \\"cc\\");  &if (($special) ==  &KLOCK)  ($apic->{la_tpr}->{r}) =  &PCPU( &pc_user_tpr); }  &else ($m)-> &m_count--; }  &while (0));
		}' unless defined(&_mutex_exit);
	    } else {
		eval 'sub _mutex_exit {
		    local($m, $special, $where) = @_;
    		    eval q( &do {  &if (($m)-> &m_count == 1) {  &asm  &volatile( \\"pushfl;\\" \\"cli;\\" \\"movl	$0xff,4+%0;\\" \\"lock; decl	8+%0;\\" \\"movl	$0,%0;\\" \\"popfl;\\": \\"=m\\" (*($m)): : \\"cc\\");  &if (($special) ==  &KLOCK)  ($apic->{la_tpr}->{r}) =  &PCPU( &pc_user_tpr); }  &else ($m)-> &m_count--; }  &while (0));
		}' unless defined(&_mutex_exit);
	    }
	    eval 'sub KLOCK_ENTER {
	        local($s) = @_;
    		eval q( &_mutex_enter(& &_klock, $s,  &KLOCK,  &__WHERE__));
	    }' unless defined(&KLOCK_ENTER);
	    eval 'sub KLOCK_EXIT () { &_mutex_exit(& &_klock,  &KLOCK,  &__WHERE__);}' unless defined(&KLOCK_EXIT);
	    if(defined(&SMP_DEBUG)) {
	    }
	    eval 'sub M_NOTOWNER () {0x01;}' unless defined(&M_NOTOWNER);
	    eval 'sub M_NOVALID () {0x02;}' unless defined(&M_NOVALID);
	    eval 'sub M_OWNER () {0x04;}' unless defined(&M_OWNER);
	    eval 'sub M_NORECURSION () {0x08;}' unless defined(&M_NORECURSION);
	    if(defined(&SMP_DEBUG)) {
		eval 'sub mutex_assert {
		    local($m, $what) = @_;
    		    eval q( &do {  &if ((($what) &  &M_NOVALID) == 0)  &if (($m)-> &m_count < 0)  &panic(\\"mutex_assert: negative hold count %s:%d\\",  &__FILE__,  &__LINE__);  &if (($what) &  &M_NOTOWNER)  &if (($m)-> &m_owner ==  &PCPU( &cpuno))  &panic(\\"mutex_assert: unexpectedly owned %s:%d\\",  &__FILE__,  &__LINE__);  &if (($what) &  &M_OWNER)  &if (($m)-> &m_owner !=  &PCPU( &cpuno))  &panic(\\"mutex_assert: not owned %s:%d\\",  &__FILE__,  &__LINE__);  &if (($what) &  &M_NORECURSION)  &if (($m)-> &m_count != 1)  &panic(\\"mutex_assert: unexpected recursion %s:%d\\",  &__FILE__,  &__LINE__); }  &while (0));
		}' unless defined(&mutex_assert);
	    } else {
		eval 'sub mutex_assert {
		    local($m, $what) = @_;
    		    eval q();
		}' unless defined(&mutex_assert);
	    }
	}
    } else {
	if(defined(&SMP_DEBUG)) {
	    eval 'sub MUTEX_ENTER_SETDESC {
	        local($desc) = @_;
    		eval q(. &section \\".rodata\\"; 6: . &string $desc; . &section \\".text\\";  &movl $6 &b, &MUTEX_NAME(% &ebx););
	    }' unless defined(&MUTEX_ENTER_SETDESC);
	    eval 'sub SMUTEX_SETDESC {
	        local($m,$desc) = @_;
    		eval q(. &section \\".rodata\\"; 6: . &string $desc; . &section \\".text\\";  &movl $6 &b,$m+ &MUTEX_NAME;);
	    }' unless defined(&SMUTEX_SETDESC);
	} else {
	    eval 'sub MUTEX_ENTER_SETDESC {
	        local($desc) = @_;
    		eval q();
	    }' unless defined(&MUTEX_ENTER_SETDESC);
	    eval 'sub SMUTEX_SETDESC {
	        local($m,$desc) = @_;
    		eval q();
	    }' unless defined(&SMUTEX_SETDESC);
	}
	eval 'sub SMP_LOCK () { &lock;;}' unless defined(&SMP_LOCK);
	eval 'sub MUTEX_ENTER {
	    local($l, $fail, $desc, $take) = @_;
    	    eval q( &movl $$l,% &ebx;  &movl % &fs: &PCPU_CPUNO,% &eax;  &cmpl % &eax, &MUTEX_OWN(% &ebx);  &je 8 &f;  &movl $1,% &ecx;  &xchgl % &ecx, &MUTEX_GATE(% &ebx);  &testl % &ecx,% &ecx;  &jne $fail; $take; 8:  &incl  &MUTEX_COUNT(% &ebx);  &MUTEX_ENTER_SETDESC($desc);  &movl % &eax, &MUTEX_OWN(% &ebx););
	}' unless defined(&MUTEX_ENTER);
	eval 'sub MUTEX_EXIT {
	    local($l,$give) = @_;
    	    eval q( &movl $$l,% &ebx;  &cmpl $1, &MUTEX_COUNT(% &ebx);  &je 1 &f;  &decl  &MUTEX_COUNT(% &ebx);  &jmp 9 &f; 1:  &movl $ &NO_CPU, &MUTEX_OWN(% &ebx);  &lock;  &decl  &MUTEX_COUNT(% &ebx);  &movl $0, &MUTEX_GATE(% &ebx); $give; 9:);
	}' unless defined(&MUTEX_EXIT);
	eval 'sub SMUTEX_ENTER {
	    local($m, $d, $r) = @_;
    	    eval q( &movl $1,$r; 9:  &xchgl $m+ &MUTEX_GATE,$r;  &testl $r,$r;  &jnz 9 &b;  &SMUTEX_SETDESC($m, $d););
	}' unless defined(&SMUTEX_ENTER);
	eval 'sub SMUTEX_EXIT {
	    local($m, $d) = @_;
    	    eval q( &SMUTEX_SETDESC($m, $d);  &movl $0,$m+ &MUTEX_GATE;);
	}' unless defined(&SMUTEX_EXIT);
    }
}
1;
