require '_h2ph_pre.ph';

unless(defined(&_MACHINE_PARAM_H_)) {
    eval 'sub _MACHINE_PARAM_H_ () {1;}' unless defined(&_MACHINE_PARAM_H_);
    eval 'sub MACHINE () {"i386";}' unless defined(&MACHINE);
    eval 'sub NCPUS () {1;}' unless defined(&NCPUS);
    eval 'sub MAXCPUS () {16;}' unless defined(&MAXCPUS);
    eval 'sub MAX_IOAPIC () { &MAXCPUS;}' unless defined(&MAX_IOAPIC);
    eval 'sub IDTSIZE () {256;}' unless defined(&IDTSIZE);
    eval 'sub ALIGNBYTES () {3;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub NBPG () {4096;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub NPTEPG () {( &NBPG/($sizeof{\'struct pte\'}));}' unless defined(&NPTEPG);
    eval 'sub NBPDR () {(1024* &NBPG);}' unless defined(&NBPDR);
    eval 'sub PDROFSET () {( &NBPDR-1);}' unless defined(&PDROFSET);
    eval 'sub PDRSHIFT () {22;}' unless defined(&PDRSHIFT);
    eval 'sub DEV_BSIZE () {512;}' unless defined(&DEV_BSIZE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub CLSIZE () {1;}' unless defined(&CLSIZE);
    eval 'sub CLSIZELOG2 () {0;}' unless defined(&CLSIZELOG2);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub MSIZE () {128;}' unless defined(&MSIZE);
    unless(defined(&MCLSHIFT)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    }
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	if(defined(&GATEWAY)) {
	    eval 'sub NMBCLUSTERS () {512;}' unless defined(&NMBCLUSTERS);
	} else {
	    eval 'sub NMBCLUSTERS () {256;}' unless defined(&NMBCLUSTERS);
	}
    }
    eval 'sub ctos {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&ctos);
    eval 'sub stoc {
        local($x) = @_;
	    eval q(($x));
    }' unless defined(&stoc);
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x)<<( &PGSHIFT- &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x)>>( &PGSHIFT- &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub dtob {
        local($x) = @_;
	    eval q((($x)<< &DEV_BSHIFT));
    }' unless defined(&dtob);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x)<< &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x)+( &NBPG-1))>> &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($bytes) = @_;
	    eval q((($bytes) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($db) = @_;
	    eval q((($db) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    eval 'sub i386_round_pdr {
        local($x) = @_;
	    eval q((((($x)) +  &NBPDR - 1) & ~( &NBPDR-1)));
    }' unless defined(&i386_round_pdr);
    eval 'sub i386_trunc_pdr {
        local($x) = @_;
	    eval q((($x) & ~( &NBPDR-1)));
    }' unless defined(&i386_trunc_pdr);
    eval 'sub i386_round_page {
        local($x) = @_;
	    eval q((((($x)) +  &NBPG - 1) & ~( &NBPG-1)));
    }' unless defined(&i386_round_page);
    eval 'sub i386_trunc_page {
        local($x) = @_;
	    eval q((($x) & ~( &NBPG-1)));
    }' unless defined(&i386_trunc_page);
    eval 'sub i386_btod {
        local($x) = @_;
	    eval q((($x) >>  &PDRSHIFT));
    }' unless defined(&i386_btod);
    eval 'sub i386_dtob {
        local($x) = @_;
	    eval q((($x) <<  &PDRSHIFT));
    }' unless defined(&i386_dtob);
    eval 'sub i386_btop {
        local($x) = @_;
	    eval q((($x) >>  &PGSHIFT));
    }' unless defined(&i386_btop);
    eval 'sub i386_ptob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&i386_ptob);
    eval 'sub USER_IOPORTS () {(0xffff + 1);}' unless defined(&USER_IOPORTS);
    if(defined(&KERNEL)) {
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q( &delay($n));
	}' unless defined(&DELAY);
    } else {
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q({  &register \'int\'  &N = ($n);  &while (-- &N > 0); });
	}' unless defined(&DELAY);
    }
    unless(defined(&_SIMPLELOCK_H_)) {
	eval 'sub _SIMPLELOCK_H_ () {1;}' unless defined(&_SIMPLELOCK_H_);
	if(!defined( &DEBUG)  && (defined(&NCPUS) ? &NCPUS : 0) > 1) {
	}
    }
    require 'machine/vmlayout.ph';
    if(defined( &KERNEL)  && !defined( &STANDALONE)) {
	require 'machine/inline.ph';
    }
}
1;
