require '_h2ph_pre.ph';

unless(defined(&_MACHINE_PCPU_H_)) {
    eval 'sub _MACHINE_PCPU_H_ () {1;}' unless defined(&_MACHINE_PCPU_H_);
    if(defined(&KERNEL)) {
	require 'i386/i386/cpuvar.ph';
    }
    unless(defined(&LOCORE)) {
	require 'sys/ktr.ph';
	require 'sys/time.ph';
	require 'sys/vmmeter.ph';
	require 'sys/cpustats.ph';
	require 'machine/segments.ph';
	require 'machine/tss.ph';
	require 'machine/apic.ph';
	if(defined(&KTR)) {
	}
	if(defined(&KERNEL)) {
	    eval 'sub __pcpu_offsetof {
	        local($f) = @_;
    		eval q((( &NULL)->$f));
	    }' unless defined(&__pcpu_offsetof);
	    eval 'sub PCPU {
	        local($field) = @_;
    		eval q(({  &typedef  &typeof (->$field)  &__ftype;  &__ftype  &__result;  &if ( &sizeof == 1) { \'u_char\'  &__b;  &asm  &volatile (\\"movb %%fs:%1,%0\\" : \\"=a\\" : \\"m\\" (*));  &__result =  &__b; }  &else  &if ( &sizeof == 2) { \'u_short __w\';  &asm  &volatile (\\"movw %%fs:%1,%0\\" : \\"=a\\" : \\"m\\" (*));  &__result =  &__w; }  &else { \'u_long __l\';  &asm  &volatile (\\"movl %%fs:%1,%0\\" : \\"=a\\" : \\"m\\" (*));  &__result =  &__l; }  &__result; }));
	    }' unless defined(&PCPU);
	    eval 'sub SET_PCPU {
	        local($field, $value) = @_;
    		eval q(({  &typedef  &typeof (->$field)  &__ftype;  &if ( &sizeof == 1) { \'u_char\'  &__b = ;  &asm  &volatile (\\"movb %1,%%fs:%0\\" : \\"=m\\" (*) : \\"a\\" ); }  &else  &if ( &sizeof == 2) { \'u_short __w\' = ;  &asm  &volatile (\\"movw %1,%%fs:%0\\" : \\"=m\\" (*) : \\"a\\" ); }  &else { \'u_long __l\' = ;  &asm  &volatile (\\"movl %1,%%fs:%0\\" : \\"=m\\" (*) : \\"a\\" ); } 0; }));
	    }' unless defined(&SET_PCPU);
	    eval 'sub INC_PCPU {
	        local($field) = @_;
    		eval q(({  &typedef  &typeof (->$field)  &__ftype;  &if ( &sizeof == 1)  &asm  &volatile (\\"lock; incb %%fs:%0\\" : \\"=m\\" (*));  &else  &if ( &sizeof == 2)  &asm  &volatile (\\"lock; incw %%fs:%0\\" : \\"=m\\" (*));  &else  &asm  &volatile (\\"lock; incl %%fs:%0\\" : \\"=m\\" (*)); 0; }));
	    }' unless defined(&INC_PCPU);
	    eval 'sub disseminate_pcpu_hardclock () {
	        eval q( &if ( &numcpu > 1)  &IPI_PCLOCK_ALL());
	    }' unless defined(&disseminate_pcpu_hardclock);
	    eval 'sub PCPU_VA () {( &CPUPTDI <<  &PDRSHIFT);}' unless defined(&PCPU_VA);
	    eval 'sub IDT_VA {
	        local($x) = @_;
    		eval q(( &PCPU_VA + 0x3d0000 +  &ctob($x)));
	    }' unless defined(&IDT_VA);
	    eval 'sub IO_APIC_VA {
	        local($x) = @_;
    		eval q(( &PCPU_VA + 0x3e0000 +  &ctob($x)));
	    }' unless defined(&IO_APIC_VA);
	    eval 'sub APIC_VA () {( &PCPU_VA + 0x3f0000);}' unless defined(&APIC_VA);
	    eval 'sub KDEBUG_VA () {( &PCPU_VA + 0x3f1000);}' unless defined(&KDEBUG_VA);
	}
    }
    eval 'sub CPUFL_CONT () {0x1;}' unless defined(&CPUFL_CONT);
    eval 'sub CPUFL_HALT () {0x2;}' unless defined(&CPUFL_HALT);
    eval 'sub CPU_UNKNOWN () {0;}' unless defined(&CPU_UNKNOWN);
    eval 'sub CPU_UP () {1;}' unless defined(&CPU_UP);
    eval 'sub CPU_CLKSYNC () {2;}' unless defined(&CPU_CLKSYNC);
    eval 'sub CPU_GETCLK () {3;}' unless defined(&CPU_GETCLK);
    eval 'sub CPU_SETCLK () {4;}' unless defined(&CPU_SETCLK);
    eval 'sub CPU_INITAP () {5;}' unless defined(&CPU_INITAP);
    eval 'sub CPU_STOPPED () {6;}' unless defined(&CPU_STOPPED);
    eval 'sub CPU_WAITTRIG () {7;}' unless defined(&CPU_WAITTRIG);
    eval 'sub CPU_TRIGGERED () {8;}' unless defined(&CPU_TRIGGERED);
    eval 'sub CPU_REJECT () {10;}' unless defined(&CPU_REJECT);
    eval 'sub CPU_INITERR () {11;}' unless defined(&CPU_INITERR);
    eval 'sub CPU_PANIC_HALT () {13;}' unless defined(&CPU_PANIC_HALT);
}
1;
