require '_h2ph_pre.ph';

unless(defined(&_MACHINE_VMPARAM_H_)) {
    eval 'sub _MACHINE_VMPARAM_H_ () {1;}' unless defined(&_MACHINE_VMPARAM_H_);
    require 'machine/vmlayout.ph';
    eval 'sub MAXTSIZ () {(12*1024*1024);}' unless defined(&MAXTSIZ);
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(16*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(1024*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&MAXDSIZ_UPPER)) {
	eval 'sub MAXDSIZ_UPPER () {(2*1024*1024*1024);}' unless defined(&MAXDSIZ_UPPER);
    }
    unless(defined(&MAXDSIZ_LOWER)) {
	eval 'sub MAXDSIZ_LOWER () {(16*1024*1024);}' unless defined(&MAXDSIZ_LOWER);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(64*1024*1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&MAXSSIZ_UPPER)) {
	eval 'sub MAXSSIZ_UPPER () {(1024*1024*1024);}' unless defined(&MAXSSIZ_UPPER);
    }
    unless(defined(&MAXSSIZ_LOWER)) {
	eval 'sub MAXSSIZ_LOWER () {(2*1024*1024);}' unless defined(&MAXSSIZ_LOWER);
    }
    eval 'sub INITSSIZ () {(64*1024);}' unless defined(&INITSSIZ);
    eval 'sub STACKINCR () {(512*1024);}' unless defined(&STACKINCR);
    eval 'sub FIX_MAXDSIZ {
        local($m) = @_;
	    eval q(( <  &MAXDSIZ_LOWER ?  &MAXDSIZ_LOWER : >  &MAXDSIZ_UPPER ?  &MAXDSIZ_UPPER :  &round_page($m)));
    }' unless defined(&FIX_MAXDSIZ);
    eval 'sub FIX_MAXSSIZ {
        local($m) = @_;
	    eval q(( <  &MAXSSIZ_LOWER ?  &MAXSSIZ_LOWER : >  &MAXSSIZ_UPPER ?  &MAXSSIZ_UPPER :  &round_page($m)));
    }' unless defined(&FIX_MAXSSIZ);
    eval 'sub DMMIN () {32;}' unless defined(&DMMIN);
    eval 'sub DMMAX () {4096;}' unless defined(&DMMAX);
    if(defined(&unused)) {
	eval 'sub USRIOSIZE () {300;}' unless defined(&USRIOSIZE);
    }
    eval 'sub MAXSLP () {20;}' unless defined(&MAXSLP);
    eval 'sub SAFERSS () {8;}' unless defined(&SAFERSS);
    eval 'sub DISKRPM () {60;}' unless defined(&DISKRPM);
    eval 'sub KLMAX () {(4/ &CLSIZE);}' unless defined(&KLMAX);
    eval 'sub KLSEQL () {(2/ &CLSIZE);}' unless defined(&KLSEQL);
    eval 'sub KLIN () {(4/ &CLSIZE);}' unless defined(&KLIN);
    eval 'sub KLTXT () {(4/ &CLSIZE);}' unless defined(&KLTXT);
    eval 'sub KLOUT () {(4/ &CLSIZE);}' unless defined(&KLOUT);
    eval 'sub KLSDIST () {3;}' unless defined(&KLSDIST);
    eval 'sub LOTSFREE () {(512* 1024);}' unless defined(&LOTSFREE);
    eval 'sub LOTSFREEFRACT () {4;}' unless defined(&LOTSFREEFRACT);
    eval 'sub DESFREE () {(200* 1024);}' unless defined(&DESFREE);
    eval 'sub DESFREEFRACT () {8;}' unless defined(&DESFREEFRACT);
    eval 'sub HANDSPREAD () {(2* 1024* 1024);}' unless defined(&HANDSPREAD);
    eval 'sub RATETOSCHEDPAGING () {4;}' unless defined(&RATETOSCHEDPAGING);
    eval 'sub mapin {
        local($pte, $v, $pfnum, $prot) = @_;
	    eval q({(*($pte) = (($pfnum)<< &PGSHIFT) | ($prot)) ; });
    }' unless defined(&mapin);
    eval 'sub pcbb {
        local($p) = @_;
	    eval q((($p)-> &p_addr));
    }' unless defined(&pcbb);
    unless(defined(&I386_CR3PAT)) {
	eval 'sub I386_CR3PAT () {0x0;}' unless defined(&I386_CR3PAT);
    }
    if(defined(&notyet)) {
	eval 'sub _cr3 () {
	    eval q(({\'u_long rtn\';  &asm (\\" movl %%cr3,%%eax; movl %%eax,%0 \\" : \\"=g\\" ( &rtn) : : \\"ax\\");  &rtn; }));
	}' unless defined(&_cr3);
	eval 'sub load_cr3 {
	    local($s) = @_;
    	    eval q(({ \'u_long val\';  &val = ($s) |  &I386_CR3PAT;  &asm (\\"movl %0,%%eax; movl %%eax,%%cr3\\" : : \\"g\\" ( &val) : \\"ax\\"); }));
	}' unless defined(&load_cr3);
	eval 'sub tlbflush () {
	    eval q(({ \'u_long val\';  &val =  ($u->{u_pcb}->{pcb_ptd}) |  &I386_CR3PAT;  &asm (\\"movl %0,%%eax; movl %%eax,%%cr3\\" : : \\"g\\" ( &val) : \\"ax\\"); }));
	}' unless defined(&tlbflush);
    }
    if(defined(&KERNEL)) {
    }
}
1;
