require '_h2ph_pre.ph';

unless(defined(&_SYS_PARAM_H_)) {
    eval 'sub _SYS_PARAM_H_ () {1;}' unless defined(&_SYS_PARAM_H_);
    eval 'sub BSD () {199506;}' unless defined(&BSD);
    eval 'sub BSD4_3 () {1;}' unless defined(&BSD4_3);
    eval 'sub BSD4_4 () {1;}' unless defined(&BSD4_4);
    eval 'sub _BSDI_VERSION () {200105;}' unless defined(&_BSDI_VERSION);
    unless(defined(&NULL)) {
	eval 'sub NULL () {0;}' unless defined(&NULL);
    }
    unless(defined(&LOCORE)) {
	require 'sys/types.ph';
    }
    require 'sys/syslimits.ph';
    eval 'sub MAXCOMLEN () {16;}' unless defined(&MAXCOMLEN);
    eval 'sub MAXINTERP () {32;}' unless defined(&MAXINTERP);
    eval 'sub MAXLOGNAME () {16;}' unless defined(&MAXLOGNAME);
    eval 'sub MAXUPRC () { &CHILD_MAX;}' unless defined(&MAXUPRC);
    eval 'sub NCARGS () { &ARG_MAX;}' unless defined(&NCARGS);
    eval 'sub NGROUPS () { &NGROUPS_MAX;}' unless defined(&NGROUPS);
    eval 'sub NOFILE () { &OPEN_MAX;}' unless defined(&NOFILE);
    eval 'sub NOGROUP () {65535;}' unless defined(&NOGROUP);
    eval 'sub MAXHOSTNAMELEN () {256;}' unless defined(&MAXHOSTNAMELEN);
    if(defined(&KERNEL)) {
	require 'machine/compat.ph';
	require 'sys/cdefs.ph';
	require 'sys/errno.ph';
	require 'sys/time.ph';
	require 'sys/queue.ph';
	require 'sys/resource.ph';
	require 'sys/ucred.ph';
	require 'sys/uio.ph';
    }
    require 'sys/signal.ph';
    if(defined(&KERNEL)) {
    }
    require 'machine/param.ph';
    require 'machine/limits.ph';
    eval 'sub PSWP () {0;}' unless defined(&PSWP);
    eval 'sub PVM () {4;}' unless defined(&PVM);
    eval 'sub PINOD () {8;}' unless defined(&PINOD);
    eval 'sub PRIBIO () {12;}' unless defined(&PRIBIO);
    eval 'sub PVFS () {16;}' unless defined(&PVFS);
    eval 'sub PZERO () {18;}' unless defined(&PZERO);
    eval 'sub PSOCK () {20;}' unless defined(&PSOCK);
    eval 'sub PWAIT () {24;}' unless defined(&PWAIT);
    eval 'sub PLOCK () {28;}' unless defined(&PLOCK);
    eval 'sub PPAUSE () {32;}' unless defined(&PPAUSE);
    eval 'sub PKMAX () {35;}' unless defined(&PKMAX);
    eval 'sub PUMIN () {36;}' unless defined(&PUMIN);
    eval 'sub PRTMIN () {36;}' unless defined(&PRTMIN);
    eval 'sub PRTMAX () {43;}' unless defined(&PRTMAX);
    eval 'sub PUSER () {50;}' unless defined(&PUSER);
    eval 'sub MAXPRI () {127;}' unless defined(&MAXPRI);
    eval 'sub PKMASK () {0x1ff;}' unless defined(&PKMASK);
    eval 'sub PUMASK () {(~ &PKMASK);}' unless defined(&PUMASK);
    eval 'sub PRTMASK_INIT () {0x600;}' unless defined(&PRTMASK_INIT);
    eval 'sub PRIMASK () {0x0ff;}' unless defined(&PRIMASK);
    eval 'sub PCATCH () {0x100;}' unless defined(&PCATCH);
    eval 'sub NZERO () {0;}' unless defined(&NZERO);
    eval 'sub ADJPRIO {
        local($prio) = @_;
	    eval q(( &MAXPRI - $prio));
    }' unless defined(&ADJPRIO);
    eval 'sub NBPW () {$sizeof{\'int\'};}' unless defined(&NBPW);
    eval 'sub CMASK () {022;}' unless defined(&CMASK);
    eval 'sub NODEV () {(-1);}' unless defined(&NODEV);
    if(defined(&KERNEL)) {
	eval 'sub RR_INTERVAL () {( &hz / 10);}' unless defined(&RR_INTERVAL);
    }
    eval 'sub CLBYTES () {( &CLSIZE* &NBPG);}' unless defined(&CLBYTES);
    eval 'sub CLOFSET () {( &CLSIZE* &NBPG-1);}' unless defined(&CLOFSET);
    eval 'sub claligned {
        local($x) = @_;
	    eval q((((($x)) &CLOFSET)==0));
    }' unless defined(&claligned);
    eval 'sub CLOFF () { &CLOFSET;}' unless defined(&CLOFF);
    eval 'sub CLSHIFT () {( &PGSHIFT+ &CLSIZELOG2);}' unless defined(&CLSHIFT);
    if((defined(&CLSIZE) ? &CLSIZE : 0)==1) {
	eval 'sub clbase {
	    local($i) = @_;
    	    eval q(($i));
	}' unless defined(&clbase);
	eval 'sub clrnd {
	    local($i) = @_;
    	    eval q(($i));
	}' unless defined(&clrnd);
    } else {
	eval 'sub clbase {
	    local($i) = @_;
    	    eval q((($i) &~ ( &CLSIZE-1)));
	}' unless defined(&clbase);
	eval 'sub clrnd {
	    local($i) = @_;
    	    eval q(((($i) + ( &CLSIZE-1)) &~ ( &CLSIZE-1)));
	}' unless defined(&clrnd);
    }
    eval 'sub MAXBSIZE () { &MAXPHYS;}' unless defined(&MAXBSIZE);
    eval 'sub MAXFRAG () {8;}' unless defined(&MAXFRAG);
    eval 'sub MAXPATHLEN () { &PATH_MAX;}' unless defined(&MAXPATHLEN);
    eval 'sub MAXSYMLINKS () {20;}' unless defined(&MAXSYMLINKS);
    eval 'sub setbit {
        local($a,$i) = @_;
	    eval q(([ /  &NBBY] |= 1<< (($i) %  &NBBY)));
    }' unless defined(&setbit);
    eval 'sub clrbit {
        local($a,$i) = @_;
	    eval q(([ /  &NBBY] &= ~(1<< (($i) %  &NBBY))));
    }' unless defined(&clrbit);
    eval 'sub isset {
        local($a,$i) = @_;
	    eval q(([ /  &NBBY] & (1<< (($i) %  &NBBY))));
    }' unless defined(&isset);
    eval 'sub isclr {
        local($a,$i) = @_;
	    eval q((([/ &NBBY] & (1<< (($i)% &NBBY))) == 0));
    }' unless defined(&isclr);
    unless(defined(&howmany)) {
	eval 'sub howmany {
	    local($x, $y) = @_;
    	    eval q(((($x)+(($y)-1))/($y)));
	}' unless defined(&howmany);
    }
    eval 'sub roundup {
        local($x, $y) = @_;
	    eval q((((($x)+(($y)-1))/($y))*($y)));
    }' unless defined(&roundup);
    eval 'sub powerof2 {
        local($x) = @_;
	    eval q((((($x)-1)($x))==0));
    }' unless defined(&powerof2);
    unless(defined(&KERNEL)) {
	eval 'sub MIN {
	    local($a,$b) = @_;
    	    eval q(((($a)<($b))?($a):($b)));
	}' unless defined(&MIN);
	eval 'sub MAX {
	    local($a,$b) = @_;
    	    eval q(((($a)>($b))?($a):($b)));
	}' unless defined(&MAX);
    }
    eval 'sub MINBUCKET () {4;}' unless defined(&MINBUCKET);
    eval 'sub MAXALLOCSAVE () {(2*  &CLBYTES);}' unless defined(&MAXALLOCSAVE);
    eval 'sub MAXMAPENTRIES () {1024;}' unless defined(&MAXMAPENTRIES);
    eval 'sub FSHIFT () {11;}' unless defined(&FSHIFT);
    eval 'sub FSCALE () {(1<< &FSHIFT);}' unless defined(&FSCALE);
}
1;
