require '_h2ph_pre.ph';

unless(defined(&_SYS_PROC_H_)) {
    eval 'sub _SYS_PROC_H_ () {1;}' unless defined(&_SYS_PROC_H_);
    require 'machine/proc.ph';
    require 'sys/select.ph';
    require 'sys/queue.ph';
    eval 'sub p_ucred () { ($p_cred->{pc_ucred});}' unless defined(&p_ucred);
    eval 'sub p_rlimit () { ($p_limit->{pl_rlimit});}' unless defined(&p_rlimit);
    eval 'sub p_startzero () { &p_oppid;}' unless defined(&p_startzero);
    eval 'sub p_endzero () { ($p_hash->{le_next});}' unless defined(&p_endzero);
    eval 'sub p_startcopy () { &p_sigmask;}' unless defined(&p_startcopy);
    eval 'sub p_endcopy () { &p_thread;}' unless defined(&p_endcopy);
    eval 'sub p_session () { ($p_pgrp->{pg_session});}' unless defined(&p_session);
    eval 'sub p_pgid () { ($p_pgrp->{pg_id});}' unless defined(&p_pgid);
    eval 'sub SIDL () {1;}' unless defined(&SIDL);
    eval 'sub SRUN () {2;}' unless defined(&SRUN);
    eval 'sub SSLEEP () {3;}' unless defined(&SSLEEP);
    eval 'sub SSTOP () {4;}' unless defined(&SSTOP);
    eval 'sub SZOMB () {5;}' unless defined(&SZOMB);
    eval 'sub P_ADVLOCK () {0x00001;}' unless defined(&P_ADVLOCK);
    eval 'sub P_CONTROLT () {0x00002;}' unless defined(&P_CONTROLT);
    eval 'sub P_INMEM () {0x00004;}' unless defined(&P_INMEM);
    eval 'sub P_NOCLDSTOP () {0x00008;}' unless defined(&P_NOCLDSTOP);
    eval 'sub P_PPWAIT () {0x00010;}' unless defined(&P_PPWAIT);
    eval 'sub P_PROFIL () {0x00020;}' unless defined(&P_PROFIL);
    eval 'sub P_SELECT () {0x00040;}' unless defined(&P_SELECT);
    eval 'sub P_SINTR () {0x00080;}' unless defined(&P_SINTR);
    eval 'sub P_SUGID () {0x00100;}' unless defined(&P_SUGID);
    eval 'sub P_SYSTEM () {0x00200;}' unless defined(&P_SYSTEM);
    eval 'sub P_TIMEOUT () {0x00400;}' unless defined(&P_TIMEOUT);
    eval 'sub P_TRACED () {0x00800;}' unless defined(&P_TRACED);
    eval 'sub P_WAITED () {0x01000;}' unless defined(&P_WAITED);
    eval 'sub P_WEXIT () {0x02000;}' unless defined(&P_WEXIT);
    eval 'sub P_EXEC () {0x04000;}' unless defined(&P_EXEC);
    eval 'sub P_NOSWAP () {0x08000;}' unless defined(&P_NOSWAP);
    eval 'sub P_PHYSIO () {0x10000;}' unless defined(&P_PHYSIO);
    eval 'sub P_OWEUPC () {0x20000;}' unless defined(&P_OWEUPC);
    eval 'sub P_ASYNCDAEMON () {0x40000;}' unless defined(&P_ASYNCDAEMON);
    eval 'sub P_IDLEPROC () {0x80000;}' unless defined(&P_IDLEPROC);
    eval 'sub P_KERNPROC () {0x100000;}' unless defined(&P_KERNPROC);
    eval 'sub P_COWINPROGRESS () {0x200000;}' unless defined(&P_COWINPROGRESS);
    if(defined(&KERNEL)) {
	eval 'sub PID_MAX () {30000;}' unless defined(&PID_MAX);
	eval 'sub NO_PID () {30001;}' unless defined(&NO_PID);
	eval 'sub SESS_LEADER {
	    local($p) = @_;
    	    eval q((($p)-> ($p_session->{s_leader}) == ($p)));
	}' unless defined(&SESS_LEADER);
	eval 'sub SESSHOLD {
	    local($s) = @_;
    	    eval q((($s)-> &s_count++));
	}' unless defined(&SESSHOLD);
	eval 'sub SESSRELE {
	    local($s) = @_;
    	    eval q({  &if (--($s)-> &s_count == 0)  &FREE($s,  &M_SESSION); });
	}' unless defined(&SESSRELE);
	eval 'sub PIDHASH {
	    local($pid) = @_;
    	    eval q(( $pidhashtbl[($pid) &  &pidhash]));
	}' unless defined(&PIDHASH);
	eval 'sub PGRPHASH {
	    local($pgid) = @_;
    	    eval q(( $pgrphashtbl[($pgid) &  &pgrphash]));
	}' unless defined(&PGRPHASH);
    }
}
1;
