require '_h2ph_pre.ph';

unless(defined(&SOUNDCARD_H)) {
    eval 'sub SOUNDCARD_H () {1;}' unless defined(&SOUNDCARD_H);
    if(defined( &__cplusplus)) {
	eval 'sub EXTERNC () { &extern "C";}' unless defined(&EXTERNC);
    } else {
	eval 'sub EXTERNC () { &extern;}' unless defined(&EXTERNC);
    }
    eval 'sub SOUND_VERSION () {0x030904;}' unless defined(&SOUND_VERSION);
    eval 'sub OPEN_SOUND_SYSTEM () {1;}' unless defined(&OPEN_SOUND_SYSTEM);
    if(defined( &__hpux)  && !defined( &_HPUX_SOURCE)) {
	die("-D_HPUX_SOURCE must be used when compiling OSS applications");
    }
    if(defined(&linux)) {
	require 'linux/ioctl.ph';
    } else {
	if(defined(&__FreeBSD__)) {
	    require 'sys/ioccom.ph';
	} else {
	    require 'sys/ioctl.ph';
	}
    }
    eval 'sub SNDCARD_ADLIB () {1;}' unless defined(&SNDCARD_ADLIB);
    eval 'sub SNDCARD_SB () {2;}' unless defined(&SNDCARD_SB);
    eval 'sub SNDCARD_PAS () {3;}' unless defined(&SNDCARD_PAS);
    eval 'sub SNDCARD_GUS () {4;}' unless defined(&SNDCARD_GUS);
    eval 'sub SNDCARD_MPU401 () {5;}' unless defined(&SNDCARD_MPU401);
    eval 'sub SNDCARD_SB16 () {6;}' unless defined(&SNDCARD_SB16);
    eval 'sub SNDCARD_SB16MIDI () {7;}' unless defined(&SNDCARD_SB16MIDI);
    eval 'sub SNDCARD_UART6850 () {8;}' unless defined(&SNDCARD_UART6850);
    eval 'sub SNDCARD_GUS16 () {9;}' unless defined(&SNDCARD_GUS16);
    eval 'sub SNDCARD_MSS () {10;}' unless defined(&SNDCARD_MSS);
    eval 'sub SNDCARD_PSS () {11;}' unless defined(&SNDCARD_PSS);
    eval 'sub SNDCARD_SSCAPE () {12;}' unless defined(&SNDCARD_SSCAPE);
    eval 'sub SNDCARD_PSS_MPU () {13;}' unless defined(&SNDCARD_PSS_MPU);
    eval 'sub SNDCARD_PSS_MSS () {14;}' unless defined(&SNDCARD_PSS_MSS);
    eval 'sub SNDCARD_SSCAPE_MSS () {15;}' unless defined(&SNDCARD_SSCAPE_MSS);
    eval 'sub SNDCARD_TRXPRO () {16;}' unless defined(&SNDCARD_TRXPRO);
    eval 'sub SNDCARD_TRXPRO_SB () {17;}' unless defined(&SNDCARD_TRXPRO_SB);
    eval 'sub SNDCARD_TRXPRO_MPU () {18;}' unless defined(&SNDCARD_TRXPRO_MPU);
    eval 'sub SNDCARD_MAD16 () {19;}' unless defined(&SNDCARD_MAD16);
    eval 'sub SNDCARD_MAD16_MPU () {20;}' unless defined(&SNDCARD_MAD16_MPU);
    eval 'sub SNDCARD_CS4232 () {21;}' unless defined(&SNDCARD_CS4232);
    eval 'sub SNDCARD_CS4232_MPU () {22;}' unless defined(&SNDCARD_CS4232_MPU);
    eval 'sub SNDCARD_MAUI () {23;}' unless defined(&SNDCARD_MAUI);
    eval 'sub SNDCARD_PSEUDO_MSS () {24;}' unless defined(&SNDCARD_PSEUDO_MSS);
    eval 'sub SNDCARD_GUSPNP () {25;}' unless defined(&SNDCARD_GUSPNP);
    eval 'sub SNDCARD_UART401 () {26;}' unless defined(&SNDCARD_UART401);
    unless(defined(&__SIOWR)) {
	if(defined( &__hpux) || (defined( &_IOWR)  && (defined( &_AIX) || (!defined( &sun)  && !defined( &sparc)  && !defined( &__INCioctlh)  && !defined( &__Lynx__))))) {
	    eval 'sub SIOCPARM_MASK () { &IOCPARM_MASK;}' unless defined(&SIOCPARM_MASK);
	    eval 'sub SIOC_VOID () { &IOC_VOID;}' unless defined(&SIOC_VOID);
	    eval 'sub SIOC_OUT () { &IOC_OUT;}' unless defined(&SIOC_OUT);
	    eval 'sub SIOC_IN () { &IOC_IN;}' unless defined(&SIOC_IN);
	    eval 'sub SIOC_INOUT () { &IOC_INOUT;}' unless defined(&SIOC_INOUT);
	    eval 'sub __SIOC_SIZE () { &_IOC_SIZE;}' unless defined(&__SIOC_SIZE);
	    eval 'sub __SIOC_DIR () { &_IOC_DIR;}' unless defined(&__SIOC_DIR);
	    eval 'sub __SIOC_NONE () { &_IOC_NONE;}' unless defined(&__SIOC_NONE);
	    eval 'sub __SIOC_READ () { &_IOC_READ;}' unless defined(&__SIOC_READ);
	    eval 'sub __SIOC_WRITE () { &_IOC_WRITE;}' unless defined(&__SIOC_WRITE);
	    eval 'sub __SIO () { &_IO;}' unless defined(&__SIO);
	    eval 'sub __SIOR () { &_IOR;}' unless defined(&__SIOR);
	    eval 'sub __SIOW () { &_IOW;}' unless defined(&__SIOW);
	    eval 'sub __SIOWR () { &_IOWR;}' unless defined(&__SIOWR);
	} else {
	    eval 'sub SIOCPARM_MASK () {0x1fff;}' unless defined(&SIOCPARM_MASK);
	    eval 'sub SIOC_VOID () {0x00000000;}' unless defined(&SIOC_VOID);
	    eval 'sub SIOC_OUT () {0x20000000;}' unless defined(&SIOC_OUT);
	    eval 'sub SIOC_IN () {0x40000000;}' unless defined(&SIOC_IN);
	    eval 'sub SIOC_INOUT () {( &SIOC_IN| &SIOC_OUT);}' unless defined(&SIOC_INOUT);
	    eval 'sub __SIO {
	        local($x,$y) = @_;
    		eval q((( &SIOC_VOID|($x<<8)|$y)));
	    }' unless defined(&__SIO);
	    eval 'sub __SIOR {
	        local($x,$y,$t) = @_;
    		eval q((( &SIOC_OUT|(($sizeof{$t} &SIOCPARM_MASK)<<16)|($x<<8)|$y)));
	    }' unless defined(&__SIOR);
	    eval 'sub __SIOW {
	        local($x,$y,$t) = @_;
    		eval q((( &SIOC_IN|(($sizeof{$t} &SIOCPARM_MASK)<<16)|($x<<8)|$y)));
	    }' unless defined(&__SIOW);
	    eval 'sub __SIOWR {
	        local($x,$y,$t) = @_;
    		eval q((( &SIOC_INOUT|(($sizeof{$t} &SIOCPARM_MASK)<<16)|($x<<8)|$y)));
	    }' unless defined(&__SIOWR);
	    eval 'sub __SIOC_SIZE {
	        local($x) = @_;
    		eval q((($x>>16) &SIOCPARM_MASK));
	    }' unless defined(&__SIOC_SIZE);
	    eval 'sub __SIOC_DIR {
	        local($x) = @_;
    		eval q(($x & 0xf0000000));
	    }' unless defined(&__SIOC_DIR);
	    eval 'sub __SIOC_NONE () { &SIOC_VOID;}' unless defined(&__SIOC_NONE);
	    eval 'sub __SIOC_READ () { &SIOC_OUT;}' unless defined(&__SIOC_READ);
	    eval 'sub __SIOC_WRITE () { &SIOC_IN;}' unless defined(&__SIOC_WRITE);
	}
    }
    eval 'sub SNDCTL_SEQ_RESET () { &__SIO (ord(\'Q\'), 0);}' unless defined(&SNDCTL_SEQ_RESET);
    eval 'sub SNDCTL_SEQ_SYNC () { &__SIO (ord(\'Q\'), 1);}' unless defined(&SNDCTL_SEQ_SYNC);
    eval 'sub SNDCTL_SYNTH_INFO () { &__SIOWR(ord(\'Q\'), 2, \'struct synth_info\');}' unless defined(&SNDCTL_SYNTH_INFO);
    eval 'sub SNDCTL_SEQ_CTRLRATE () { &__SIOWR(ord(\'Q\'), 3, \'int\');}' unless defined(&SNDCTL_SEQ_CTRLRATE);
    eval 'sub SNDCTL_SEQ_GETOUTCOUNT () { &__SIOR (ord(\'Q\'), 4, \'int\');}' unless defined(&SNDCTL_SEQ_GETOUTCOUNT);
    eval 'sub SNDCTL_SEQ_GETINCOUNT () { &__SIOR (ord(\'Q\'), 5, \'int\');}' unless defined(&SNDCTL_SEQ_GETINCOUNT);
    eval 'sub SNDCTL_SEQ_PERCMODE () { &__SIOW (ord(\'Q\'), 6, \'int\');}' unless defined(&SNDCTL_SEQ_PERCMODE);
    eval 'sub SNDCTL_FM_LOAD_INSTR () { &__SIOW (ord(\'Q\'), 7, \'struct sbi_instrument\');}' unless defined(&SNDCTL_FM_LOAD_INSTR);
    eval 'sub SNDCTL_SEQ_TESTMIDI () { &__SIOW (ord(\'Q\'), 8, \'int\');}' unless defined(&SNDCTL_SEQ_TESTMIDI);
    eval 'sub SNDCTL_SEQ_RESETSAMPLES () { &__SIOW (ord(\'Q\'), 9, \'int\');}' unless defined(&SNDCTL_SEQ_RESETSAMPLES);
    eval 'sub SNDCTL_SEQ_NRSYNTHS () { &__SIOR (ord(\'Q\'),10, \'int\');}' unless defined(&SNDCTL_SEQ_NRSYNTHS);
    eval 'sub SNDCTL_SEQ_NRMIDIS () { &__SIOR (ord(\'Q\'),11, \'int\');}' unless defined(&SNDCTL_SEQ_NRMIDIS);
    eval 'sub SNDCTL_MIDI_INFO () { &__SIOWR(ord(\'Q\'),12, \'struct midi_info\');}' unless defined(&SNDCTL_MIDI_INFO);
    eval 'sub SNDCTL_SEQ_THRESHOLD () { &__SIOW (ord(\'Q\'),13, \'int\');}' unless defined(&SNDCTL_SEQ_THRESHOLD);
    eval 'sub SNDCTL_SYNTH_MEMAVL () { &__SIOWR(ord(\'Q\'),14, \'int\');}' unless defined(&SNDCTL_SYNTH_MEMAVL);
    eval 'sub SNDCTL_FM_4OP_ENABLE () { &__SIOW (ord(\'Q\'),15, \'int\');}' unless defined(&SNDCTL_FM_4OP_ENABLE);
    eval 'sub SNDCTL_SEQ_PANIC () { &__SIO (ord(\'Q\'),17);}' unless defined(&SNDCTL_SEQ_PANIC);
    eval 'sub SNDCTL_SEQ_OUTOFBAND () { &__SIOW (ord(\'Q\'),18, \'struct seq_event_rec\');}' unless defined(&SNDCTL_SEQ_OUTOFBAND);
    eval 'sub SNDCTL_SEQ_GETTIME () { &__SIOR (ord(\'Q\'),19, \'int\');}' unless defined(&SNDCTL_SEQ_GETTIME);
    eval 'sub SNDCTL_SYNTH_ID () { &__SIOWR(ord(\'Q\'),20, \'struct synth_info\');}' unless defined(&SNDCTL_SYNTH_ID);
    eval 'sub SNDCTL_SYNTH_CONTROL () { &__SIOWR(ord(\'Q\'),21, \'struct synth_control\');}' unless defined(&SNDCTL_SYNTH_CONTROL);
    eval 'sub SNDCTL_SYNTH_REMOVESAMPLE () { &__SIOWR(ord(\'Q\'),22, \'struct remove_sample\');}' unless defined(&SNDCTL_SYNTH_REMOVESAMPLE);
    eval 'sub SNDCTL_TMR_TIMEBASE () { &__SIOWR(ord(\'T\'), 1, \'int\');}' unless defined(&SNDCTL_TMR_TIMEBASE);
    eval 'sub SNDCTL_TMR_START () { &__SIO (ord(\'T\'), 2);}' unless defined(&SNDCTL_TMR_START);
    eval 'sub SNDCTL_TMR_STOP () { &__SIO (ord(\'T\'), 3);}' unless defined(&SNDCTL_TMR_STOP);
    eval 'sub SNDCTL_TMR_CONTINUE () { &__SIO (ord(\'T\'), 4);}' unless defined(&SNDCTL_TMR_CONTINUE);
    eval 'sub SNDCTL_TMR_TEMPO () { &__SIOWR(ord(\'T\'), 5, \'int\');}' unless defined(&SNDCTL_TMR_TEMPO);
    eval 'sub SNDCTL_TMR_SOURCE () { &__SIOWR(ord(\'T\'), 6, \'int\');}' unless defined(&SNDCTL_TMR_SOURCE);
    eval 'sub TMR_INTERNAL () {0x00000001;}' unless defined(&TMR_INTERNAL);
    eval 'sub TMR_EXTERNAL () {0x00000002;}' unless defined(&TMR_EXTERNAL);
    eval 'sub TMR_MODE_MIDI () {0x00000010;}' unless defined(&TMR_MODE_MIDI);
    eval 'sub TMR_MODE_FSK () {0x00000020;}' unless defined(&TMR_MODE_FSK);
    eval 'sub TMR_MODE_CLS () {0x00000040;}' unless defined(&TMR_MODE_CLS);
    eval 'sub TMR_MODE_SMPTE () {0x00000080;}' unless defined(&TMR_MODE_SMPTE);
    eval 'sub SNDCTL_TMR_METRONOME () { &__SIOW (ord(\'T\'), 7, \'int\');}' unless defined(&SNDCTL_TMR_METRONOME);
    eval 'sub SNDCTL_TMR_SELECT () { &__SIOW (ord(\'T\'), 8, \'int\');}' unless defined(&SNDCTL_TMR_SELECT);
    if(defined( &_AIX) || defined( &AIX) || defined( &sparc) || defined( &__hppa) || defined( &PPC) || defined( &__powerpc__)  && !defined( &i386)  && !defined( &__i386)  && !defined( &__i386__)) {
	eval 'sub _PATCHKEY {
	    local($id) = @_;
    	    eval q((0xfd00|$id));
	}' unless defined(&_PATCHKEY);
	eval 'sub AFMT_S16_NE () { &AFMT_S16_BE;}' unless defined(&AFMT_S16_NE);
	eval 'sub AFMT_U16_NE () { &AFMT_U16_BE;}' unless defined(&AFMT_U16_NE);
	eval 'sub AFMT_S32_NE () { &AFMT_S32_BE;}' unless defined(&AFMT_S32_NE);
    } else {
	eval 'sub _PATCHKEY {
	    local($id) = @_;
    	    eval q((($id<<8)|0xfd));
	}' unless defined(&_PATCHKEY);
	eval 'sub AFMT_S16_NE () { &AFMT_S16_LE;}' unless defined(&AFMT_S16_NE);
	eval 'sub AFMT_U16_NE () { &AFMT_U16_LE;}' unless defined(&AFMT_U16_NE);
	eval 'sub AFMT_S32_NE () { &AFMT_S32_LE;}' unless defined(&AFMT_S32_NE);
    }
    eval 'sub WAVE_PATCH () { &_PATCHKEY(0x04);}' unless defined(&WAVE_PATCH);
    eval 'sub GUS_PATCH () { &WAVE_PATCH;}' unless defined(&GUS_PATCH);
    eval 'sub WAVE_16_BITS () {0x01;}' unless defined(&WAVE_16_BITS);
    eval 'sub WAVE_UNSIGNED () {0x02;}' unless defined(&WAVE_UNSIGNED);
    eval 'sub WAVE_LOOPING () {0x04;}' unless defined(&WAVE_LOOPING);
    eval 'sub WAVE_BIDIR_LOOP () {0x08;}' unless defined(&WAVE_BIDIR_LOOP);
    eval 'sub WAVE_LOOP_BACK () {0x10;}' unless defined(&WAVE_LOOP_BACK);
    eval 'sub WAVE_SUSTAIN_ON () {0x20;}' unless defined(&WAVE_SUSTAIN_ON);
    eval 'sub WAVE_ENVELOPES () {0x40;}' unless defined(&WAVE_ENVELOPES);
    eval 'sub WAVE_FAST_RELEASE () {0x80;}' unless defined(&WAVE_FAST_RELEASE);
    eval 'sub WAVE_VIBRATO () {0x00010000;}' unless defined(&WAVE_VIBRATO);
    eval 'sub WAVE_TREMOLO () {0x00020000;}' unless defined(&WAVE_TREMOLO);
    eval 'sub WAVE_SCALE () {0x00040000;}' unless defined(&WAVE_SCALE);
    eval 'sub WAVE_FRACTIONS () {0x00080000;}' unless defined(&WAVE_FRACTIONS);
    eval 'sub WAVE_ROM () {0x40000000;}' unless defined(&WAVE_ROM);
    eval 'sub WAVE_MULAW () {0x20000000;}' unless defined(&WAVE_MULAW);
    eval 'sub SYSEX_PATCH () { &_PATCHKEY(0x05);}' unless defined(&SYSEX_PATCH);
    eval 'sub MAUI_PATCH () { &_PATCHKEY(0x06);}' unless defined(&MAUI_PATCH);
    eval 'sub SEQ_NOTEOFF () {0;}' unless defined(&SEQ_NOTEOFF);
    eval 'sub SEQ_FMNOTEOFF () { &SEQ_NOTEOFF;}' unless defined(&SEQ_FMNOTEOFF);
    eval 'sub SEQ_NOTEON () {1;}' unless defined(&SEQ_NOTEON);
    eval 'sub SEQ_FMNOTEON () { &SEQ_NOTEON;}' unless defined(&SEQ_FMNOTEON);
    eval 'sub SEQ_WAIT () { &TMR_WAIT_ABS;}' unless defined(&SEQ_WAIT);
    eval 'sub SEQ_PGMCHANGE () {3;}' unless defined(&SEQ_PGMCHANGE);
    eval 'sub SEQ_FMPGMCHANGE () { &SEQ_PGMCHANGE;}' unless defined(&SEQ_FMPGMCHANGE);
    eval 'sub SEQ_SYNCTIMER () { &TMR_START;}' unless defined(&SEQ_SYNCTIMER);
    eval 'sub SEQ_MIDIPUTC () {5;}' unless defined(&SEQ_MIDIPUTC);
    eval 'sub SEQ_DRUMON () {6;}' unless defined(&SEQ_DRUMON);
    eval 'sub SEQ_DRUMOFF () {7;}' unless defined(&SEQ_DRUMOFF);
    eval 'sub SEQ_ECHO () { &TMR_ECHO;}' unless defined(&SEQ_ECHO);
    eval 'sub SEQ_AFTERTOUCH () {9;}' unless defined(&SEQ_AFTERTOUCH);
    eval 'sub SEQ_CONTROLLER () {10;}' unless defined(&SEQ_CONTROLLER);
    eval 'sub CTL_BANK_SELECT () {0x00;}' unless defined(&CTL_BANK_SELECT);
    eval 'sub CTL_MODWHEEL () {0x01;}' unless defined(&CTL_MODWHEEL);
    eval 'sub CTL_BREATH () {0x02;}' unless defined(&CTL_BREATH);
    eval 'sub CTL_FOOT () {0x04;}' unless defined(&CTL_FOOT);
    eval 'sub CTL_PORTAMENTO_TIME () {0x05;}' unless defined(&CTL_PORTAMENTO_TIME);
    eval 'sub CTL_DATA_ENTRY () {0x06;}' unless defined(&CTL_DATA_ENTRY);
    eval 'sub CTL_MAIN_VOLUME () {0x07;}' unless defined(&CTL_MAIN_VOLUME);
    eval 'sub CTL_BALANCE () {0x08;}' unless defined(&CTL_BALANCE);
    eval 'sub CTL_PAN () {0x0a;}' unless defined(&CTL_PAN);
    eval 'sub CTL_EXPRESSION () {0x0b;}' unless defined(&CTL_EXPRESSION);
    eval 'sub CTL_GENERAL_PURPOSE1 () {0x10;}' unless defined(&CTL_GENERAL_PURPOSE1);
    eval 'sub CTL_GENERAL_PURPOSE2 () {0x11;}' unless defined(&CTL_GENERAL_PURPOSE2);
    eval 'sub CTL_GENERAL_PURPOSE3 () {0x12;}' unless defined(&CTL_GENERAL_PURPOSE3);
    eval 'sub CTL_GENERAL_PURPOSE4 () {0x13;}' unless defined(&CTL_GENERAL_PURPOSE4);
    eval 'sub CTL_DAMPER_PEDAL () {0x40;}' unless defined(&CTL_DAMPER_PEDAL);
    eval 'sub CTL_SUSTAIN () {0x40;}' unless defined(&CTL_SUSTAIN);
    eval 'sub CTL_HOLD () {0x40;}' unless defined(&CTL_HOLD);
    eval 'sub CTL_PORTAMENTO () {0x41;}' unless defined(&CTL_PORTAMENTO);
    eval 'sub CTL_SOSTENUTO () {0x42;}' unless defined(&CTL_SOSTENUTO);
    eval 'sub CTL_SOFT_PEDAL () {0x43;}' unless defined(&CTL_SOFT_PEDAL);
    eval 'sub CTL_HOLD2 () {0x45;}' unless defined(&CTL_HOLD2);
    eval 'sub CTL_GENERAL_PURPOSE5 () {0x50;}' unless defined(&CTL_GENERAL_PURPOSE5);
    eval 'sub CTL_GENERAL_PURPOSE6 () {0x51;}' unless defined(&CTL_GENERAL_PURPOSE6);
    eval 'sub CTL_GENERAL_PURPOSE7 () {0x52;}' unless defined(&CTL_GENERAL_PURPOSE7);
    eval 'sub CTL_GENERAL_PURPOSE8 () {0x53;}' unless defined(&CTL_GENERAL_PURPOSE8);
    eval 'sub CTL_EXT_EFF_DEPTH () {0x5b;}' unless defined(&CTL_EXT_EFF_DEPTH);
    eval 'sub CTL_TREMOLO_DEPTH () {0x5c;}' unless defined(&CTL_TREMOLO_DEPTH);
    eval 'sub CTL_CHORUS_DEPTH () {0x5d;}' unless defined(&CTL_CHORUS_DEPTH);
    eval 'sub CTL_DETUNE_DEPTH () {0x5e;}' unless defined(&CTL_DETUNE_DEPTH);
    eval 'sub CTL_CELESTE_DEPTH () {0x5e;}' unless defined(&CTL_CELESTE_DEPTH);
    eval 'sub CTL_PHASER_DEPTH () {0x5f;}' unless defined(&CTL_PHASER_DEPTH);
    eval 'sub CTL_DATA_INCREMENT () {0x60;}' unless defined(&CTL_DATA_INCREMENT);
    eval 'sub CTL_DATA_DECREMENT () {0x61;}' unless defined(&CTL_DATA_DECREMENT);
    eval 'sub CTL_NONREG_PARM_NUM_LSB () {0x62;}' unless defined(&CTL_NONREG_PARM_NUM_LSB);
    eval 'sub CTL_NONREG_PARM_NUM_MSB () {0x63;}' unless defined(&CTL_NONREG_PARM_NUM_MSB);
    eval 'sub CTL_REGIST_PARM_NUM_LSB () {0x64;}' unless defined(&CTL_REGIST_PARM_NUM_LSB);
    eval 'sub CTL_REGIST_PARM_NUM_MSB () {0x65;}' unless defined(&CTL_REGIST_PARM_NUM_MSB);
    eval 'sub CTRL_PITCH_BENDER () {255;}' unless defined(&CTRL_PITCH_BENDER);
    eval 'sub CTRL_PITCH_BENDER_RANGE () {254;}' unless defined(&CTRL_PITCH_BENDER_RANGE);
    eval 'sub CTRL_EXPRESSION () {253;}' unless defined(&CTRL_EXPRESSION);
    eval 'sub CTRL_MAIN_VOLUME () {252;}' unless defined(&CTRL_MAIN_VOLUME);
    eval 'sub SEQ_BALANCE () {11;}' unless defined(&SEQ_BALANCE);
    eval 'sub SEQ_VOLMODE () {12;}' unless defined(&SEQ_VOLMODE);
    eval 'sub VOL_METHOD_ADAGIO () {1;}' unless defined(&VOL_METHOD_ADAGIO);
    eval 'sub VOL_METHOD_LINEAR () {2;}' unless defined(&VOL_METHOD_LINEAR);
    eval 'sub SEQ_FULLSIZE () {0xfd;}' unless defined(&SEQ_FULLSIZE);
    eval 'sub SEQ_PRIVATE () {0xfe;}' unless defined(&SEQ_PRIVATE);
    eval 'sub SEQ_EXTENDED () {0xff;}' unless defined(&SEQ_EXTENDED);
    eval 'sub FM_PATCH () { &_PATCHKEY(0x01);}' unless defined(&FM_PATCH);
    eval 'sub OPL3_PATCH () { &_PATCHKEY(0x03);}' unless defined(&OPL3_PATCH);
    eval 'sub SYNTH_TYPE_FM () {0;}' unless defined(&SYNTH_TYPE_FM);
    eval 'sub SYNTH_TYPE_SAMPLE () {1;}' unless defined(&SYNTH_TYPE_SAMPLE);
    eval 'sub SYNTH_TYPE_MIDI () {2;}' unless defined(&SYNTH_TYPE_MIDI);
    eval 'sub FM_TYPE_ADLIB () {0x00;}' unless defined(&FM_TYPE_ADLIB);
    eval 'sub FM_TYPE_OPL3 () {0x01;}' unless defined(&FM_TYPE_OPL3);
    eval 'sub MIDI_TYPE_MPU401 () {0x401;}' unless defined(&MIDI_TYPE_MPU401);
    eval 'sub SAMPLE_TYPE_BASIC () {0x10;}' unless defined(&SAMPLE_TYPE_BASIC);
    eval 'sub SAMPLE_TYPE_GUS () { &SAMPLE_TYPE_BASIC;}' unless defined(&SAMPLE_TYPE_GUS);
    eval 'sub SYNTH_CAP_PERCMODE () {0x00000001;}' unless defined(&SYNTH_CAP_PERCMODE);
    eval 'sub SYNTH_CAP_OPL3 () {0x00000002;}' unless defined(&SYNTH_CAP_OPL3);
    eval 'sub SYNTH_CAP_INPUT () {0x00000004;}' unless defined(&SYNTH_CAP_INPUT);
    eval 'sub MIDI_CAP_MPU401 () {1;}' unless defined(&MIDI_CAP_MPU401);
    eval 'sub SNDCTL_MIDI_PRETIME () { &__SIOWR(ord(\'m\'), 0, \'int\');}' unless defined(&SNDCTL_MIDI_PRETIME);
    eval 'sub SNDCTL_MIDI_MPUMODE () { &__SIOWR(ord(\'m\'), 1, \'int\');}' unless defined(&SNDCTL_MIDI_MPUMODE);
    eval 'sub SNDCTL_MIDI_MPUCMD () { &__SIOWR(ord(\'m\'), 2,  &mpu_command_rec);}' unless defined(&SNDCTL_MIDI_MPUCMD);
    eval 'sub SNDCTL_DSP_RESET () { &__SIO (ord(\'P\'), 0);}' unless defined(&SNDCTL_DSP_RESET);
    eval 'sub SNDCTL_DSP_SYNC () { &__SIO (ord(\'P\'), 1);}' unless defined(&SNDCTL_DSP_SYNC);
    eval 'sub SNDCTL_DSP_SPEED () { &__SIOWR(ord(\'P\'), 2, \'int\');}' unless defined(&SNDCTL_DSP_SPEED);
    eval 'sub SNDCTL_DSP_STEREO () { &__SIOWR(ord(\'P\'), 3, \'int\');}' unless defined(&SNDCTL_DSP_STEREO);
    eval 'sub SNDCTL_DSP_GETBLKSIZE () { &__SIOWR(ord(\'P\'), 4, \'int\');}' unless defined(&SNDCTL_DSP_GETBLKSIZE);
    eval 'sub SNDCTL_DSP_SAMPLESIZE () { &SNDCTL_DSP_SETFMT;}' unless defined(&SNDCTL_DSP_SAMPLESIZE);
    eval 'sub SNDCTL_DSP_CHANNELS () { &__SIOWR(ord(\'P\'), 6, \'int\');}' unless defined(&SNDCTL_DSP_CHANNELS);
    eval 'sub SOUND_PCM_WRITE_CHANNELS () { &SNDCTL_DSP_CHANNELS;}' unless defined(&SOUND_PCM_WRITE_CHANNELS);
    eval 'sub SOUND_PCM_WRITE_FILTER () { &__SIOWR(ord(\'P\'), 7, \'int\');}' unless defined(&SOUND_PCM_WRITE_FILTER);
    eval 'sub SNDCTL_DSP_POST () { &__SIO (ord(\'P\'), 8);}' unless defined(&SNDCTL_DSP_POST);
    eval 'sub SNDCTL_DSP_SUBDIVIDE () { &__SIOWR(ord(\'P\'), 9, \'int\');}' unless defined(&SNDCTL_DSP_SUBDIVIDE);
    eval 'sub SNDCTL_DSP_SETFRAGMENT () { &__SIOWR(ord(\'P\'),10, \'int\');}' unless defined(&SNDCTL_DSP_SETFRAGMENT);
    eval 'sub SNDCTL_DSP_GETFMTS () { &__SIOR (ord(\'P\'),11, \'int\');}' unless defined(&SNDCTL_DSP_GETFMTS);
    eval 'sub SNDCTL_DSP_SETFMT () { &__SIOWR(ord(\'P\'),5, \'int\');}' unless defined(&SNDCTL_DSP_SETFMT);
    eval 'sub AFMT_QUERY () {0x00000000;}' unless defined(&AFMT_QUERY);
    eval 'sub AFMT_MU_LAW () {0x00000001;}' unless defined(&AFMT_MU_LAW);
    eval 'sub AFMT_A_LAW () {0x00000002;}' unless defined(&AFMT_A_LAW);
    eval 'sub AFMT_IMA_ADPCM () {0x00000004;}' unless defined(&AFMT_IMA_ADPCM);
    eval 'sub AFMT_U8 () {0x00000008;}' unless defined(&AFMT_U8);
    eval 'sub AFMT_S16_LE () {0x00000010;}' unless defined(&AFMT_S16_LE);
    eval 'sub AFMT_S16_BE () {0x00000020;}' unless defined(&AFMT_S16_BE);
    eval 'sub AFMT_S8 () {0x00000040;}' unless defined(&AFMT_S8);
    eval 'sub AFMT_U16_LE () {0x00000080;}' unless defined(&AFMT_U16_LE);
    eval 'sub AFMT_U16_BE () {0x00000100;}' unless defined(&AFMT_U16_BE);
    eval 'sub AFMT_MPEG () {0x00000200;}' unless defined(&AFMT_MPEG);
    eval 'sub AFMT_S32_LE () {0x00001000;}' unless defined(&AFMT_S32_LE);
    eval 'sub AFMT_S32_BE () {0x00002000;}' unless defined(&AFMT_S32_BE);
    eval 'sub SNDCTL_DSP_GETOSPACE () { &__SIOR (ord(\'P\'),12,  &audio_buf_info);}' unless defined(&SNDCTL_DSP_GETOSPACE);
    eval 'sub SNDCTL_DSP_GETISPACE () { &__SIOR (ord(\'P\'),13,  &audio_buf_info);}' unless defined(&SNDCTL_DSP_GETISPACE);
    eval 'sub SNDCTL_DSP_NONBLOCK () { &__SIO (ord(\'P\'),14);}' unless defined(&SNDCTL_DSP_NONBLOCK);
    eval 'sub SNDCTL_DSP_GETCAPS () { &__SIOR (ord(\'P\'),15, \'int\');}' unless defined(&SNDCTL_DSP_GETCAPS);
    eval 'sub DSP_CAP_REVISION () {0x000000ff;}' unless defined(&DSP_CAP_REVISION);
    eval 'sub DSP_CAP_DUPLEX () {0x00000100;}' unless defined(&DSP_CAP_DUPLEX);
    eval 'sub DSP_CAP_REALTIME () {0x00000200;}' unless defined(&DSP_CAP_REALTIME);
    eval 'sub DSP_CAP_BATCH () {0x00000400;}' unless defined(&DSP_CAP_BATCH);
    eval 'sub DSP_CAP_COPROC () {0x00000800;}' unless defined(&DSP_CAP_COPROC);
    eval 'sub DSP_CAP_TRIGGER () {0x00001000;}' unless defined(&DSP_CAP_TRIGGER);
    eval 'sub DSP_CAP_MMAP () {0x00002000;}' unless defined(&DSP_CAP_MMAP);
    eval 'sub SNDCTL_DSP_GETTRIGGER () { &__SIOR (ord(\'P\'),16, \'int\');}' unless defined(&SNDCTL_DSP_GETTRIGGER);
    eval 'sub SNDCTL_DSP_SETTRIGGER () { &__SIOW (ord(\'P\'),16, \'int\');}' unless defined(&SNDCTL_DSP_SETTRIGGER);
    eval 'sub PCM_ENABLE_INPUT () {0x00000001;}' unless defined(&PCM_ENABLE_INPUT);
    eval 'sub PCM_ENABLE_OUTPUT () {0x00000002;}' unless defined(&PCM_ENABLE_OUTPUT);
    eval 'sub SNDCTL_DSP_GETIPTR () { &__SIOR (ord(\'P\'),17,  &count_info);}' unless defined(&SNDCTL_DSP_GETIPTR);
    eval 'sub SNDCTL_DSP_GETOPTR () { &__SIOR (ord(\'P\'),18,  &count_info);}' unless defined(&SNDCTL_DSP_GETOPTR);
    eval 'sub SNDCTL_DSP_MAPINBUF () { &__SIOR (ord(\'P\'), 19,  &buffmem_desc);}' unless defined(&SNDCTL_DSP_MAPINBUF);
    eval 'sub SNDCTL_DSP_MAPOUTBUF () { &__SIOR (ord(\'P\'), 20,  &buffmem_desc);}' unless defined(&SNDCTL_DSP_MAPOUTBUF);
    eval 'sub SNDCTL_DSP_SETSYNCRO () { &__SIO (ord(\'P\'), 21);}' unless defined(&SNDCTL_DSP_SETSYNCRO);
    eval 'sub SNDCTL_DSP_SETDUPLEX () { &__SIO (ord(\'P\'), 22);}' unless defined(&SNDCTL_DSP_SETDUPLEX);
    eval 'sub SNDCTL_DSP_GETODELAY () { &__SIOR (ord(\'P\'), 23, \'int\');}' unless defined(&SNDCTL_DSP_GETODELAY);
    eval 'sub SNDCTL_DSP_GETOUTVOL () { &__SIOR (ord(\'P\'), 24, \'int\');}' unless defined(&SNDCTL_DSP_GETOUTVOL);
    eval 'sub SNDCTL_DSP_SETOUTVOL () { &__SIOWR(ord(\'P\'), 24, \'int\');}' unless defined(&SNDCTL_DSP_SETOUTVOL);
    eval 'sub SNDCTL_DSP_GETERROR () { &__SIOR (ord(\'P\'), 25,  &audio_errinfo);}' unless defined(&SNDCTL_DSP_GETERROR);
    eval 'sub SNDCTL_DSP_PROFILE () { &__SIOW (ord(\'P\'), 23, \'int\');}' unless defined(&SNDCTL_DSP_PROFILE);
    eval 'sub APF_NORMAL () {0;}' unless defined(&APF_NORMAL);
    eval 'sub APF_NETWORK () {1;}' unless defined(&APF_NETWORK);
    eval 'sub APF_CPUINTENS () {2;}' unless defined(&APF_CPUINTENS);
    eval 'sub SOUND_PCM_READ_RATE () { &__SIOR (ord(\'P\'), 2, \'int\');}' unless defined(&SOUND_PCM_READ_RATE);
    eval 'sub SOUND_PCM_READ_CHANNELS () { &__SIOR (ord(\'P\'), 6, \'int\');}' unless defined(&SOUND_PCM_READ_CHANNELS);
    eval 'sub SOUND_PCM_READ_BITS () { &__SIOR (ord(\'P\'), 5, \'int\');}' unless defined(&SOUND_PCM_READ_BITS);
    eval 'sub SOUND_PCM_READ_FILTER () { &__SIOR (ord(\'P\'), 7, \'int\');}' unless defined(&SOUND_PCM_READ_FILTER);
    eval 'sub SOUND_PCM_WRITE_BITS () { &SNDCTL_DSP_SETFMT;}' unless defined(&SOUND_PCM_WRITE_BITS);
    eval 'sub SOUND_PCM_WRITE_RATE () { &SNDCTL_DSP_SPEED;}' unless defined(&SOUND_PCM_WRITE_RATE);
    eval 'sub SOUND_PCM_POST () { &SNDCTL_DSP_POST;}' unless defined(&SOUND_PCM_POST);
    eval 'sub SOUND_PCM_RESET () { &SNDCTL_DSP_RESET;}' unless defined(&SOUND_PCM_RESET);
    eval 'sub SOUND_PCM_SYNC () { &SNDCTL_DSP_SYNC;}' unless defined(&SOUND_PCM_SYNC);
    eval 'sub SOUND_PCM_SUBDIVIDE () { &SNDCTL_DSP_SUBDIVIDE;}' unless defined(&SOUND_PCM_SUBDIVIDE);
    eval 'sub SOUND_PCM_SETFRAGMENT () { &SNDCTL_DSP_SETFRAGMENT;}' unless defined(&SOUND_PCM_SETFRAGMENT);
    eval 'sub SOUND_PCM_GETFMTS () { &SNDCTL_DSP_GETFMTS;}' unless defined(&SOUND_PCM_GETFMTS);
    eval 'sub SOUND_PCM_SETFMT () { &SNDCTL_DSP_SETFMT;}' unless defined(&SOUND_PCM_SETFMT);
    eval 'sub SOUND_PCM_GETOSPACE () { &SNDCTL_DSP_GETOSPACE;}' unless defined(&SOUND_PCM_GETOSPACE);
    eval 'sub SOUND_PCM_GETISPACE () { &SNDCTL_DSP_GETISPACE;}' unless defined(&SOUND_PCM_GETISPACE);
    eval 'sub SOUND_PCM_NONBLOCK () { &SNDCTL_DSP_NONBLOCK;}' unless defined(&SOUND_PCM_NONBLOCK);
    eval 'sub SOUND_PCM_GETCAPS () { &SNDCTL_DSP_GETCAPS;}' unless defined(&SOUND_PCM_GETCAPS);
    eval 'sub SOUND_PCM_GETTRIGGER () { &SNDCTL_DSP_GETTRIGGER;}' unless defined(&SOUND_PCM_GETTRIGGER);
    eval 'sub SOUND_PCM_SETTRIGGER () { &SNDCTL_DSP_SETTRIGGER;}' unless defined(&SOUND_PCM_SETTRIGGER);
    eval 'sub SOUND_PCM_SETSYNCRO () { &SNDCTL_DSP_SETSYNCRO;}' unless defined(&SOUND_PCM_SETSYNCRO);
    eval 'sub SOUND_PCM_GETIPTR () { &SNDCTL_DSP_GETIPTR;}' unless defined(&SOUND_PCM_GETIPTR);
    eval 'sub SOUND_PCM_GETOPTR () { &SNDCTL_DSP_GETOPTR;}' unless defined(&SOUND_PCM_GETOPTR);
    eval 'sub SOUND_PCM_MAPINBUF () { &SNDCTL_DSP_MAPINBUF;}' unless defined(&SOUND_PCM_MAPINBUF);
    eval 'sub SOUND_PCM_MAPOUTBUF () { &SNDCTL_DSP_MAPOUTBUF;}' unless defined(&SOUND_PCM_MAPOUTBUF);
    eval 'sub CPF_NONE () {0x0000;}' unless defined(&CPF_NONE);
    eval 'sub CPF_FIRST () {0x0001;}' unless defined(&CPF_FIRST);
    eval 'sub CPF_LAST () {0x0002;}' unless defined(&CPF_LAST);
    eval 'sub SNDCTL_COPR_RESET () { &__SIO (ord(\'C\'), 0);}' unless defined(&SNDCTL_COPR_RESET);
    eval 'sub SNDCTL_COPR_LOAD () { &__SIOWR(ord(\'C\'), 1,  &copr_buffer);}' unless defined(&SNDCTL_COPR_LOAD);
    eval 'sub SNDCTL_COPR_RDATA () { &__SIOWR(ord(\'C\'), 2,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_RDATA);
    eval 'sub SNDCTL_COPR_RCODE () { &__SIOWR(ord(\'C\'), 3,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_RCODE);
    eval 'sub SNDCTL_COPR_WDATA () { &__SIOW (ord(\'C\'), 4,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_WDATA);
    eval 'sub SNDCTL_COPR_WCODE () { &__SIOW (ord(\'C\'), 5,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_WCODE);
    eval 'sub SNDCTL_COPR_RUN () { &__SIOWR(ord(\'C\'), 6,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_RUN);
    eval 'sub SNDCTL_COPR_HALT () { &__SIOWR(ord(\'C\'), 7,  &copr_debug_buf);}' unless defined(&SNDCTL_COPR_HALT);
    eval 'sub SNDCTL_COPR_SENDMSG () { &__SIOWR(ord(\'C\'), 8,  &copr_msg);}' unless defined(&SNDCTL_COPR_SENDMSG);
    eval 'sub SNDCTL_COPR_RCVMSG () { &__SIOR (ord(\'C\'), 9,  &copr_msg);}' unless defined(&SNDCTL_COPR_RCVMSG);
    eval 'sub SOUND_MIXER_NRDEVICES () {28;}' unless defined(&SOUND_MIXER_NRDEVICES);
    eval 'sub SOUND_MIXER_VOLUME () {0;}' unless defined(&SOUND_MIXER_VOLUME);
    eval 'sub SOUND_MIXER_BASS () {1;}' unless defined(&SOUND_MIXER_BASS);
    eval 'sub SOUND_MIXER_TREBLE () {2;}' unless defined(&SOUND_MIXER_TREBLE);
    eval 'sub SOUND_MIXER_SYNTH () {3;}' unless defined(&SOUND_MIXER_SYNTH);
    eval 'sub SOUND_MIXER_PCM () {4;}' unless defined(&SOUND_MIXER_PCM);
    eval 'sub SOUND_MIXER_SPEAKER () {5;}' unless defined(&SOUND_MIXER_SPEAKER);
    eval 'sub SOUND_MIXER_LINE () {6;}' unless defined(&SOUND_MIXER_LINE);
    eval 'sub SOUND_MIXER_MIC () {7;}' unless defined(&SOUND_MIXER_MIC);
    eval 'sub SOUND_MIXER_CD () {8;}' unless defined(&SOUND_MIXER_CD);
    eval 'sub SOUND_MIXER_IMIX () {9;}' unless defined(&SOUND_MIXER_IMIX);
    eval 'sub SOUND_MIXER_ALTPCM () {10;}' unless defined(&SOUND_MIXER_ALTPCM);
    eval 'sub SOUND_MIXER_RECLEV () {11;}' unless defined(&SOUND_MIXER_RECLEV);
    eval 'sub SOUND_MIXER_IGAIN () {12;}' unless defined(&SOUND_MIXER_IGAIN);
    eval 'sub SOUND_MIXER_OGAIN () {13;}' unless defined(&SOUND_MIXER_OGAIN);
    eval 'sub SOUND_MIXER_LINE1 () {14;}' unless defined(&SOUND_MIXER_LINE1);
    eval 'sub SOUND_MIXER_LINE2 () {15;}' unless defined(&SOUND_MIXER_LINE2);
    eval 'sub SOUND_MIXER_LINE3 () {16;}' unless defined(&SOUND_MIXER_LINE3);
    eval 'sub SOUND_MIXER_DIGITAL1 () {17;}' unless defined(&SOUND_MIXER_DIGITAL1);
    eval 'sub SOUND_MIXER_DIGITAL2 () {18;}' unless defined(&SOUND_MIXER_DIGITAL2);
    eval 'sub SOUND_MIXER_DIGITAL3 () {19;}' unless defined(&SOUND_MIXER_DIGITAL3);
    eval 'sub SOUND_MIXER_PHONEIN () {20;}' unless defined(&SOUND_MIXER_PHONEIN);
    eval 'sub SOUND_MIXER_PHONEOUT () {21;}' unless defined(&SOUND_MIXER_PHONEOUT);
    eval 'sub SOUND_MIXER_VIDEO () {22;}' unless defined(&SOUND_MIXER_VIDEO);
    eval 'sub SOUND_MIXER_RADIO () {23;}' unless defined(&SOUND_MIXER_RADIO);
    eval 'sub SOUND_MIXER_MONITOR () {24;}' unless defined(&SOUND_MIXER_MONITOR);
    eval 'sub SOUND_MIXER_DEPTH () {25;}' unless defined(&SOUND_MIXER_DEPTH);
    eval 'sub SOUND_MIXER_CENTER () {26;}' unless defined(&SOUND_MIXER_CENTER);
    eval 'sub SOUND_MIXER_MIDI () {27;}' unless defined(&SOUND_MIXER_MIDI);
    eval 'sub SOUND_ONOFF_MIN () {28;}' unless defined(&SOUND_ONOFF_MIN);
    eval 'sub SOUND_ONOFF_MAX () {30;}' unless defined(&SOUND_ONOFF_MAX);
    eval 'sub SOUND_MIXER_NONE () {31;}' unless defined(&SOUND_MIXER_NONE);
    eval 'sub SOUND_MIXER_ENHANCE () { &SOUND_MIXER_NONE;}' unless defined(&SOUND_MIXER_ENHANCE);
    eval 'sub SOUND_MIXER_MUTE () { &SOUND_MIXER_NONE;}' unless defined(&SOUND_MIXER_MUTE);
    eval 'sub SOUND_MIXER_LOUD () { &SOUND_MIXER_NONE;}' unless defined(&SOUND_MIXER_LOUD);
    eval 'sub SOUND_DEVICE_LABELS () {{"Vol  ", "Bass ", "Trebl", "Synth", "Pcm  ", "Spkr ", "Line ", "Mic  ", "CD   ", "Mix  ", "Pcm2 ", "Rec  ", "IGain", "OGain", "Line1", "Line2", "Line3", "Digital1", "Digital2", "Digital3", "PhoneIn", "PhoneOut", "Video", "Radio", "Monitor", "Depth", "Center", "MIDI"};}' unless defined(&SOUND_DEVICE_LABELS);
    eval 'sub SOUND_DEVICE_NAMES () {{"vol", "bass", "treble", "synth", "pcm", "speaker", "line", "mic", "cd", "mix", "pcm2", "rec", "igain", "ogain", "line1", "line2", "line3", "dig1", "dig2", "dig3", "phin", "phout", "video", "radio", "monitor", "depth", "center", "midi"};}' unless defined(&SOUND_DEVICE_NAMES);
    eval 'sub SOUND_MIXER_RECSRC () {0xff;}' unless defined(&SOUND_MIXER_RECSRC);
    eval 'sub SOUND_MIXER_DEVMASK () {0xfe;}' unless defined(&SOUND_MIXER_DEVMASK);
    eval 'sub SOUND_MIXER_RECMASK () {0xfd;}' unless defined(&SOUND_MIXER_RECMASK);
    eval 'sub SOUND_MIXER_CAPS () {0xfc;}' unless defined(&SOUND_MIXER_CAPS);
    eval 'sub SOUND_CAP_EXCL_INPUT () {0x00000001;}' unless defined(&SOUND_CAP_EXCL_INPUT);
    eval 'sub SOUND_MIXER_STEREODEVS () {0xfb;}' unless defined(&SOUND_MIXER_STEREODEVS);
    eval 'sub SOUND_MASK_VOLUME () {(1<<  &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MASK_VOLUME);
    eval 'sub SOUND_MASK_BASS () {(1<<  &SOUND_MIXER_BASS);}' unless defined(&SOUND_MASK_BASS);
    eval 'sub SOUND_MASK_TREBLE () {(1<<  &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MASK_TREBLE);
    eval 'sub SOUND_MASK_SYNTH () {(1<<  &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MASK_SYNTH);
    eval 'sub SOUND_MASK_PCM () {(1<<  &SOUND_MIXER_PCM);}' unless defined(&SOUND_MASK_PCM);
    eval 'sub SOUND_MASK_SPEAKER () {(1<<  &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MASK_SPEAKER);
    eval 'sub SOUND_MASK_LINE () {(1<<  &SOUND_MIXER_LINE);}' unless defined(&SOUND_MASK_LINE);
    eval 'sub SOUND_MASK_MIC () {(1<<  &SOUND_MIXER_MIC);}' unless defined(&SOUND_MASK_MIC);
    eval 'sub SOUND_MASK_CD () {(1<<  &SOUND_MIXER_CD);}' unless defined(&SOUND_MASK_CD);
    eval 'sub SOUND_MASK_IMIX () {(1<<  &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MASK_IMIX);
    eval 'sub SOUND_MASK_ALTPCM () {(1<<  &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MASK_ALTPCM);
    eval 'sub SOUND_MASK_RECLEV () {(1<<  &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MASK_RECLEV);
    eval 'sub SOUND_MASK_IGAIN () {(1<<  &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MASK_IGAIN);
    eval 'sub SOUND_MASK_OGAIN () {(1<<  &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MASK_OGAIN);
    eval 'sub SOUND_MASK_LINE1 () {(1<<  &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MASK_LINE1);
    eval 'sub SOUND_MASK_LINE2 () {(1<<  &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MASK_LINE2);
    eval 'sub SOUND_MASK_LINE3 () {(1<<  &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MASK_LINE3);
    eval 'sub SOUND_MASK_DIGITAL1 () {(1<<  &SOUND_MIXER_DIGITAL1);}' unless defined(&SOUND_MASK_DIGITAL1);
    eval 'sub SOUND_MASK_DIGITAL2 () {(1<<  &SOUND_MIXER_DIGITAL2);}' unless defined(&SOUND_MASK_DIGITAL2);
    eval 'sub SOUND_MASK_DIGITAL3 () {(1<<  &SOUND_MIXER_DIGITAL3);}' unless defined(&SOUND_MASK_DIGITAL3);
    eval 'sub SOUND_MASK_PHONEIN () {(1<<  &SOUND_MIXER_PHONEIN);}' unless defined(&SOUND_MASK_PHONEIN);
    eval 'sub SOUND_MASK_PHONEOUT () {(1<<  &SOUND_MIXER_PHONEOUT);}' unless defined(&SOUND_MASK_PHONEOUT);
    eval 'sub SOUND_MASK_RADIO () {(1<<  &SOUND_MIXER_RADIO);}' unless defined(&SOUND_MASK_RADIO);
    eval 'sub SOUND_MASK_VIDEO () {(1<<  &SOUND_MIXER_VIDEO);}' unless defined(&SOUND_MASK_VIDEO);
    eval 'sub SOUND_MASK_MONITOR () {(1<<  &SOUND_MIXER_MONITOR);}' unless defined(&SOUND_MASK_MONITOR);
    eval 'sub SOUND_MASK_DEPTH () {(1<<  &SOUND_MIXER_DEPTH);}' unless defined(&SOUND_MASK_DEPTH);
    eval 'sub SOUND_MASK_CENTER () {(1<<  &SOUND_MIXER_CENTER);}' unless defined(&SOUND_MASK_CENTER);
    eval 'sub SOUND_MASK_MIDI () {(1<<  &SOUND_MIXER_MIDI);}' unless defined(&SOUND_MASK_MIDI);
    eval 'sub SOUND_MASK_MUTE () {(1<<  &SOUND_MIXER_MUTE);}' unless defined(&SOUND_MASK_MUTE);
    eval 'sub SOUND_MASK_ENHANCE () {(1<<  &SOUND_MIXER_ENHANCE);}' unless defined(&SOUND_MASK_ENHANCE);
    eval 'sub SOUND_MASK_LOUD () {(1<<  &SOUND_MIXER_LOUD);}' unless defined(&SOUND_MASK_LOUD);
    eval 'sub MIXER_READ {
        local($dev) = @_;
	    eval q( &__SIOR(ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_READ);
    eval 'sub SOUND_MIXER_READ_VOLUME () { &MIXER_READ( &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MIXER_READ_VOLUME);
    eval 'sub SOUND_MIXER_READ_BASS () { &MIXER_READ( &SOUND_MIXER_BASS);}' unless defined(&SOUND_MIXER_READ_BASS);
    eval 'sub SOUND_MIXER_READ_TREBLE () { &MIXER_READ( &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MIXER_READ_TREBLE);
    eval 'sub SOUND_MIXER_READ_SYNTH () { &MIXER_READ( &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MIXER_READ_SYNTH);
    eval 'sub SOUND_MIXER_READ_PCM () { &MIXER_READ( &SOUND_MIXER_PCM);}' unless defined(&SOUND_MIXER_READ_PCM);
    eval 'sub SOUND_MIXER_READ_SPEAKER () { &MIXER_READ( &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MIXER_READ_SPEAKER);
    eval 'sub SOUND_MIXER_READ_LINE () { &MIXER_READ( &SOUND_MIXER_LINE);}' unless defined(&SOUND_MIXER_READ_LINE);
    eval 'sub SOUND_MIXER_READ_MIC () { &MIXER_READ( &SOUND_MIXER_MIC);}' unless defined(&SOUND_MIXER_READ_MIC);
    eval 'sub SOUND_MIXER_READ_CD () { &MIXER_READ( &SOUND_MIXER_CD);}' unless defined(&SOUND_MIXER_READ_CD);
    eval 'sub SOUND_MIXER_READ_IMIX () { &MIXER_READ( &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MIXER_READ_IMIX);
    eval 'sub SOUND_MIXER_READ_ALTPCM () { &MIXER_READ( &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MIXER_READ_ALTPCM);
    eval 'sub SOUND_MIXER_READ_RECLEV () { &MIXER_READ( &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MIXER_READ_RECLEV);
    eval 'sub SOUND_MIXER_READ_IGAIN () { &MIXER_READ( &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MIXER_READ_IGAIN);
    eval 'sub SOUND_MIXER_READ_OGAIN () { &MIXER_READ( &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MIXER_READ_OGAIN);
    eval 'sub SOUND_MIXER_READ_LINE1 () { &MIXER_READ( &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MIXER_READ_LINE1);
    eval 'sub SOUND_MIXER_READ_LINE2 () { &MIXER_READ( &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MIXER_READ_LINE2);
    eval 'sub SOUND_MIXER_READ_LINE3 () { &MIXER_READ( &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MIXER_READ_LINE3);
    eval 'sub SOUND_MIXER_READ_MUTE () { &MIXER_READ( &SOUND_MIXER_MUTE);}' unless defined(&SOUND_MIXER_READ_MUTE);
    eval 'sub SOUND_MIXER_READ_ENHANCE () { &MIXER_READ( &SOUND_MIXER_ENHANCE);}' unless defined(&SOUND_MIXER_READ_ENHANCE);
    eval 'sub SOUND_MIXER_READ_LOUD () { &MIXER_READ( &SOUND_MIXER_LOUD);}' unless defined(&SOUND_MIXER_READ_LOUD);
    eval 'sub SOUND_MIXER_READ_RECSRC () { &MIXER_READ( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_READ_RECSRC);
    eval 'sub SOUND_MIXER_READ_DEVMASK () { &MIXER_READ( &SOUND_MIXER_DEVMASK);}' unless defined(&SOUND_MIXER_READ_DEVMASK);
    eval 'sub SOUND_MIXER_READ_RECMASK () { &MIXER_READ( &SOUND_MIXER_RECMASK);}' unless defined(&SOUND_MIXER_READ_RECMASK);
    eval 'sub SOUND_MIXER_READ_STEREODEVS () { &MIXER_READ( &SOUND_MIXER_STEREODEVS);}' unless defined(&SOUND_MIXER_READ_STEREODEVS);
    eval 'sub SOUND_MIXER_READ_CAPS () { &MIXER_READ( &SOUND_MIXER_CAPS);}' unless defined(&SOUND_MIXER_READ_CAPS);
    eval 'sub MIXER_WRITE {
        local($dev) = @_;
	    eval q( &__SIOWR(ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_WRITE);
    eval 'sub SOUND_MIXER_WRITE_VOLUME () { &MIXER_WRITE( &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MIXER_WRITE_VOLUME);
    eval 'sub SOUND_MIXER_WRITE_BASS () { &MIXER_WRITE( &SOUND_MIXER_BASS);}' unless defined(&SOUND_MIXER_WRITE_BASS);
    eval 'sub SOUND_MIXER_WRITE_TREBLE () { &MIXER_WRITE( &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MIXER_WRITE_TREBLE);
    eval 'sub SOUND_MIXER_WRITE_SYNTH () { &MIXER_WRITE( &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MIXER_WRITE_SYNTH);
    eval 'sub SOUND_MIXER_WRITE_PCM () { &MIXER_WRITE( &SOUND_MIXER_PCM);}' unless defined(&SOUND_MIXER_WRITE_PCM);
    eval 'sub SOUND_MIXER_WRITE_SPEAKER () { &MIXER_WRITE( &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MIXER_WRITE_SPEAKER);
    eval 'sub SOUND_MIXER_WRITE_LINE () { &MIXER_WRITE( &SOUND_MIXER_LINE);}' unless defined(&SOUND_MIXER_WRITE_LINE);
    eval 'sub SOUND_MIXER_WRITE_MIC () { &MIXER_WRITE( &SOUND_MIXER_MIC);}' unless defined(&SOUND_MIXER_WRITE_MIC);
    eval 'sub SOUND_MIXER_WRITE_CD () { &MIXER_WRITE( &SOUND_MIXER_CD);}' unless defined(&SOUND_MIXER_WRITE_CD);
    eval 'sub SOUND_MIXER_WRITE_IMIX () { &MIXER_WRITE( &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MIXER_WRITE_IMIX);
    eval 'sub SOUND_MIXER_WRITE_ALTPCM () { &MIXER_WRITE( &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MIXER_WRITE_ALTPCM);
    eval 'sub SOUND_MIXER_WRITE_RECLEV () { &MIXER_WRITE( &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MIXER_WRITE_RECLEV);
    eval 'sub SOUND_MIXER_WRITE_IGAIN () { &MIXER_WRITE( &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MIXER_WRITE_IGAIN);
    eval 'sub SOUND_MIXER_WRITE_OGAIN () { &MIXER_WRITE( &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MIXER_WRITE_OGAIN);
    eval 'sub SOUND_MIXER_WRITE_LINE1 () { &MIXER_WRITE( &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MIXER_WRITE_LINE1);
    eval 'sub SOUND_MIXER_WRITE_LINE2 () { &MIXER_WRITE( &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MIXER_WRITE_LINE2);
    eval 'sub SOUND_MIXER_WRITE_LINE3 () { &MIXER_WRITE( &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MIXER_WRITE_LINE3);
    eval 'sub SOUND_MIXER_WRITE_MUTE () { &MIXER_WRITE( &SOUND_MIXER_MUTE);}' unless defined(&SOUND_MIXER_WRITE_MUTE);
    eval 'sub SOUND_MIXER_WRITE_ENHANCE () { &MIXER_WRITE( &SOUND_MIXER_ENHANCE);}' unless defined(&SOUND_MIXER_WRITE_ENHANCE);
    eval 'sub SOUND_MIXER_WRITE_LOUD () { &MIXER_WRITE( &SOUND_MIXER_LOUD);}' unless defined(&SOUND_MIXER_WRITE_LOUD);
    eval 'sub SOUND_MIXER_WRITE_RECSRC () { &MIXER_WRITE( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_WRITE_RECSRC);
    eval 'sub SOUND_MIXER_INFO () { &__SIOR (ord(\'M\'), 101,  &mixer_info);}' unless defined(&SOUND_MIXER_INFO);
    eval 'sub SOUND_OLD_MIXER_INFO () { &__SIOR (ord(\'M\'), 101,  &_old_mixer_info);}' unless defined(&SOUND_OLD_MIXER_INFO);
    eval 'sub SOUND_MIXER_ACCESS () { &__SIOWR(ord(\'M\'), 102,  &mixer_record);}' unless defined(&SOUND_MIXER_ACCESS);
    eval 'sub SOUND_MIXER_PRIVATE1 () { &__SIOWR(ord(\'M\'), 111, \'int\');}' unless defined(&SOUND_MIXER_PRIVATE1);
    eval 'sub SOUND_MIXER_PRIVATE2 () { &__SIOWR(ord(\'M\'), 112, \'int\');}' unless defined(&SOUND_MIXER_PRIVATE2);
    eval 'sub SOUND_MIXER_PRIVATE3 () { &__SIOWR(ord(\'M\'), 113, \'int\');}' unless defined(&SOUND_MIXER_PRIVATE3);
    eval 'sub SOUND_MIXER_PRIVATE4 () { &__SIOWR(ord(\'M\'), 114, \'int\');}' unless defined(&SOUND_MIXER_PRIVATE4);
    eval 'sub SOUND_MIXER_PRIVATE5 () { &__SIOWR(ord(\'M\'), 115, \'int\');}' unless defined(&SOUND_MIXER_PRIVATE5);
    eval 'sub SOUND_MIXER_GETLEVELS () { &__SIOWR(ord(\'M\'), 116,  &mixer_vol_table);}' unless defined(&SOUND_MIXER_GETLEVELS);
    eval 'sub SOUND_MIXER_SETLEVELS () { &__SIOWR(ord(\'M\'), 117,  &mixer_vol_table);}' unless defined(&SOUND_MIXER_SETLEVELS);
    eval 'sub OSS_GETVERSION () { &__SIOR (ord(\'M\'), 118, \'int\');}' unless defined(&OSS_GETVERSION);
    eval 'sub SYSINFO_FILL_SIZE () {256;}' unless defined(&SYSINFO_FILL_SIZE);
    eval 'sub MIXT_DEVROOT () {0;}' unless defined(&MIXT_DEVROOT);
    eval 'sub MIXT_GROUP () {1;}' unless defined(&MIXT_GROUP);
    eval 'sub MIXT_ONOFF () {2;}' unless defined(&MIXT_ONOFF);
    eval 'sub MIXT_ENUM () {3;}' unless defined(&MIXT_ENUM);
    eval 'sub MIXT_MONOSLIDER () {4;}' unless defined(&MIXT_MONOSLIDER);
    eval 'sub MIXT_STEREOSLIDER () {5;}' unless defined(&MIXT_STEREOSLIDER);
    eval 'sub MIXT_MESSAGE () {6;}' unless defined(&MIXT_MESSAGE);
    eval 'sub MIXT_MONOVU () {7;}' unless defined(&MIXT_MONOVU);
    eval 'sub MIXT_STEREOVU () {8;}' unless defined(&MIXT_STEREOVU);
    eval 'sub MIXT_MONOPEAK () {9;}' unless defined(&MIXT_MONOPEAK);
    eval 'sub MIXT_STEREOPEAK () {10;}' unless defined(&MIXT_STEREOPEAK);
    eval 'sub MIXT_RADIOGROUP () {11;}' unless defined(&MIXT_RADIOGROUP);
    eval 'sub MIXT_MARKER () {12;}' unless defined(&MIXT_MARKER);
    eval 'sub MIXT_VALUE () {13;}' unless defined(&MIXT_VALUE);
    eval 'sub MIXT_HEXVALUE () {14;}' unless defined(&MIXT_HEXVALUE);
    eval 'sub MIXT_MONODB () {15;}' unless defined(&MIXT_MONODB);
    eval 'sub MIXT_STEREODB () {16;}' unless defined(&MIXT_STEREODB);
    eval 'sub MIXF_READABLE () {0x00000001;}' unless defined(&MIXF_READABLE);
    eval 'sub MIXF_WRITEABLE () {0x00000002;}' unless defined(&MIXF_WRITEABLE);
    eval 'sub OSS_SYSINFO () { &__SIOR (ord(\'X\'), 1,  &oss_sysinfo);}' unless defined(&OSS_SYSINFO);
    eval 'sub SNDCTL_MIX_NRMIX () { &__SIOR (ord(\'X\'), 2, \'int\');}' unless defined(&SNDCTL_MIX_NRMIX);
    eval 'sub SNDCTL_MIX_NREXT () { &__SIOWR(ord(\'X\'), 3, \'int\');}' unless defined(&SNDCTL_MIX_NREXT);
    eval 'sub SNDCTL_MIX_EXTINFO () { &__SIOWR(ord(\'X\'), 4,  &oss_mixext);}' unless defined(&SNDCTL_MIX_EXTINFO);
    eval 'sub SNDCTL_MIX_READ () { &__SIOWR(ord(\'X\'), 5,  &oss_mixer_value);}' unless defined(&SNDCTL_MIX_READ);
    eval 'sub SNDCTL_MIX_WRITE () { &__SIOWR(ord(\'X\'), 6,  &oss_mixer_value);}' unless defined(&SNDCTL_MIX_WRITE);
    eval 'sub EV_SEQ_LOCAL () {0x80;}' unless defined(&EV_SEQ_LOCAL);
    eval 'sub EV_TIMING () {0x81;}' unless defined(&EV_TIMING);
    eval 'sub EV_CHN_COMMON () {0x92;}' unless defined(&EV_CHN_COMMON);
    eval 'sub EV_CHN_VOICE () {0x93;}' unless defined(&EV_CHN_VOICE);
    eval 'sub EV_SYSEX () {0x94;}' unless defined(&EV_SYSEX);
    eval 'sub MIDI_NOTEOFF () {0x80;}' unless defined(&MIDI_NOTEOFF);
    eval 'sub MIDI_NOTEON () {0x90;}' unless defined(&MIDI_NOTEON);
    eval 'sub MIDI_KEY_PRESSURE () {0xa0;}' unless defined(&MIDI_KEY_PRESSURE);
    eval 'sub MIDI_CTL_CHANGE () {0xb0;}' unless defined(&MIDI_CTL_CHANGE);
    eval 'sub MIDI_PGM_CHANGE () {0xc0;}' unless defined(&MIDI_PGM_CHANGE);
    eval 'sub MIDI_CHN_PRESSURE () {0xd0;}' unless defined(&MIDI_CHN_PRESSURE);
    eval 'sub MIDI_PITCH_BEND () {0xe0;}' unless defined(&MIDI_PITCH_BEND);
    eval 'sub MIDI_SYSTEM_PREFIX () {0xf0;}' unless defined(&MIDI_SYSTEM_PREFIX);
    eval 'sub TMR_WAIT_REL () {1;}' unless defined(&TMR_WAIT_REL);
    eval 'sub TMR_WAIT_ABS () {2;}' unless defined(&TMR_WAIT_ABS);
    eval 'sub TMR_STOP () {3;}' unless defined(&TMR_STOP);
    eval 'sub TMR_START () {4;}' unless defined(&TMR_START);
    eval 'sub TMR_CONTINUE () {5;}' unless defined(&TMR_CONTINUE);
    eval 'sub TMR_TEMPO () {6;}' unless defined(&TMR_TEMPO);
    eval 'sub TMR_ECHO () {8;}' unless defined(&TMR_ECHO);
    eval 'sub TMR_CLOCK () {9;}' unless defined(&TMR_CLOCK);
    eval 'sub TMR_SPP () {10;}' unless defined(&TMR_SPP);
    eval 'sub TMR_TIMESIG () {11;}' unless defined(&TMR_TIMESIG);
    eval 'sub LOCL_STARTAUDIO () {1;}' unless defined(&LOCL_STARTAUDIO);
    eval 'sub LOCL_STARTAUDIO2 () {2;}' unless defined(&LOCL_STARTAUDIO2);
    eval 'sub LOCL_STARTAUDIO3 () {3;}' unless defined(&LOCL_STARTAUDIO3);
    eval 'sub LOCL_STARTAUDIO4 () {4;}' unless defined(&LOCL_STARTAUDIO4);
    if((!defined( &__KERNEL__)  && !defined( &KERNEL)  && !defined( &INKERNEL)  && !defined( &_KERNEL)) || defined( &USE_SEQ_MACROS) ) {
	eval 'sub SEQ_DECLAREBUF () {
	    eval q( &SEQ_USE_EXTBUF());
	}' unless defined(&SEQ_DECLAREBUF);
	eval 'sub SEQ_PM_DEFINES () {\'int\'  &__foo_bar___;}' unless defined(&SEQ_PM_DEFINES);
	if(defined(&OSSLIB)) {
	    eval 'sub SEQ_USE_EXTBUF () {
	        eval q( &EXTERNC \'unsigned char\' * &_seqbuf;  &EXTERNC \'int\'  &_seqbuflen; &EXTERNC \'int\'  &_seqbufptr);
	    }' unless defined(&SEQ_USE_EXTBUF);
	    eval 'sub SEQ_DEFINEBUF {
	        local($len) = @_;
    		eval q( &SEQ_USE_EXTBUF(); &static \'int\'  &_requested_seqbuflen=$len);
	    }' unless defined(&SEQ_DEFINEBUF);
	    eval 'sub _SEQ_ADVBUF {
	        local($len) = @_;
    		eval q( &OSS_seq_advbuf($len,  &seqfd,  &_seqbuf,  &_seqbuflen));
	    }' unless defined(&_SEQ_ADVBUF);
	    eval 'sub _SEQ_NEEDBUF {
	        local($len) = @_;
    		eval q( &OSS_seq_needbuf($len,  &seqfd,  &_seqbuf,  &_seqbuflen));
	    }' unless defined(&_SEQ_NEEDBUF);
	    eval 'sub SEQ_DUMPBUF () {
	        eval q( &OSS_seqbuf_dump( &seqfd,  &_seqbuf,  &_seqbuflen));
	    }' unless defined(&SEQ_DUMPBUF);
	    eval 'sub SEQ_LOAD_GMINSTR {
	        local($dev, $instr) = @_;
    		eval q( &OSS_patch_caching($dev, -1, $instr,  &seqfd,  &_seqbuf,  &_seqbuflen));
	    }' unless defined(&SEQ_LOAD_GMINSTR);
	    eval 'sub SEQ_LOAD_GMDRUM {
	        local($dev, $drum) = @_;
    		eval q( &OSS_drum_caching($dev, -1, $drum,  &seqfd,  &_seqbuf,  &_seqbuflen));
	    }' unless defined(&SEQ_LOAD_GMDRUM);
	} else {
	    eval 'sub SEQ_LOAD_GMINSTR {
	        local($dev, $instr) = @_;
    		eval q();
	    }' unless defined(&SEQ_LOAD_GMINSTR);
	    eval 'sub SEQ_LOAD_GMDRUM {
	        local($dev, $drum) = @_;
    		eval q();
	    }' unless defined(&SEQ_LOAD_GMDRUM);
	    eval 'sub SEQ_USE_EXTBUF () {
	        eval q( &EXTERNC \'unsigned char _seqbuf\'[];  &EXTERNC \'int\'  &_seqbuflen; &EXTERNC \'int\'  &_seqbufptr);
	    }' unless defined(&SEQ_USE_EXTBUF);
	    unless(defined(&USE_SIMPLE_MACROS)) {
		eval 'sub SEQ_DEFINEBUF {
		    local($len) = @_;
    		    eval q(\'unsigned char _seqbuf\'[$len]; \'int\'  &_seqbuflen = $len;\'int\'  &_seqbufptr = 0);
		}' unless defined(&SEQ_DEFINEBUF);
		eval 'sub _SEQ_NEEDBUF {
		    local($len) = @_;
    		    eval q( &if (( &_seqbufptr+($len)) >  &_seqbuflen)  &seqbuf_dump());
		}' unless defined(&_SEQ_NEEDBUF);
		eval 'sub _SEQ_ADVBUF {
		    local($len) = @_;
    		    eval q( &_seqbufptr += $len);
		}' unless defined(&_SEQ_ADVBUF);
		eval 'sub SEQ_DUMPBUF () { &seqbuf_dump;}' unless defined(&SEQ_DUMPBUF);
	    } else {
		eval 'sub _SEQ_NEEDBUF {
		    local($len) = @_;
    		    eval q();
		}' unless defined(&_SEQ_NEEDBUF);
	    }
	}
	eval 'sub SEQ_VOLUME_MODE {
	    local($dev, $mode) = @_;
    	    eval q({ &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &SEQ_EXTENDED;  $_seqbuf[ &_seqbufptr+1] =  &SEQ_VOLMODE;  $_seqbuf[ &_seqbufptr+2] = ($dev);  $_seqbuf[ &_seqbufptr+3] = ($mode);  $_seqbuf[ &_seqbufptr+4] = 0;  $_seqbuf[ &_seqbufptr+5] = 0;  $_seqbuf[ &_seqbufptr+6] = 0;  $_seqbuf[ &_seqbufptr+7] = 0;  &_SEQ_ADVBUF(8);});
	}' unless defined(&SEQ_VOLUME_MODE);
	eval 'sub _CHN_VOICE {
	    local($dev, $event, $chn, $note, $parm) = @_;
    	    eval q({ &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &EV_CHN_VOICE;  $_seqbuf[ &_seqbufptr+1] = ($dev);  $_seqbuf[ &_seqbufptr+2] = ($event);  $_seqbuf[ &_seqbufptr+3] = ($chn);  $_seqbuf[ &_seqbufptr+4] = ($note);  $_seqbuf[ &_seqbufptr+5] = ($parm);  $_seqbuf[ &_seqbufptr+6] = (0);  $_seqbuf[ &_seqbufptr+7] = 0;  &_SEQ_ADVBUF(8);});
	}' unless defined(&_CHN_VOICE);
	eval 'sub SEQ_START_NOTE {
	    local($dev, $chn, $note, $vol) = @_;
    	    eval q( &_CHN_VOICE($dev,  &MIDI_NOTEON, $chn, $note, $vol));
	}' unless defined(&SEQ_START_NOTE);
	eval 'sub SEQ_STOP_NOTE {
	    local($dev, $chn, $note, $vol) = @_;
    	    eval q( &_CHN_VOICE($dev,  &MIDI_NOTEOFF, $chn, $note, $vol));
	}' unless defined(&SEQ_STOP_NOTE);
	eval 'sub SEQ_KEY_PRESSURE {
	    local($dev, $chn, $note, $pressure) = @_;
    	    eval q( &_CHN_VOICE($dev,  &MIDI_KEY_PRESSURE, $chn, $note, $pressure));
	}' unless defined(&SEQ_KEY_PRESSURE);
	eval 'sub _CHN_COMMON {
	    local($dev, $event, $chn, $p1, $p2, $w14) = @_;
    	    eval q({ &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &EV_CHN_COMMON;  $_seqbuf[ &_seqbufptr+1] = ($dev);  $_seqbuf[ &_seqbufptr+2] = ($event);  $_seqbuf[ &_seqbufptr+3] = ($chn);  $_seqbuf[ &_seqbufptr+4] = ($p1);  $_seqbuf[ &_seqbufptr+5] = ($p2); *& $_seqbuf[ &_seqbufptr+6] = ($w14);  &_SEQ_ADVBUF(8);});
	}' unless defined(&_CHN_COMMON);
	eval 'sub SEQ_SYSEX {
	    local($dev, $buf, $len) = @_;
    	    eval q({\'int\'  &ii,  &ll=($len); \'unsigned char\' * &bufp=$buf;  &if ( &ll>6) &ll=6;  &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &EV_SYSEX;  $_seqbuf[ &_seqbufptr+1] = ($dev);  &for( &ii=0; &ii< &ll; &ii++)  $_seqbuf[ &_seqbufptr+ &ii+2] =  $bufp[ &ii];  &for( &ii= &ll; &ii<6; &ii++)  $_seqbuf[ &_seqbufptr+ &ii+2] = 0xff;  &_SEQ_ADVBUF(8);});
	}' unless defined(&SEQ_SYSEX);
	eval 'sub SEQ_CHN_PRESSURE {
	    local($dev, $chn, $pressure) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_CHN_PRESSURE, $chn, $pressure, 0, 0));
	}' unless defined(&SEQ_CHN_PRESSURE);
	eval 'sub SEQ_SET_PATCH () { &SEQ_PGM_CHANGE;}' unless defined(&SEQ_SET_PATCH);
	if(defined(&OSSLIB)) {
	    eval 'sub SEQ_PGM_CHANGE {
	        local($dev, $chn, $patch) = @_;
    		eval q({ &OSS_patch_caching($dev, $chn, $patch,  &seqfd,  &_seqbuf,  &_seqbuflen);  &_CHN_COMMON($dev,  &MIDI_PGM_CHANGE, $chn, $patch, 0, 0);});
	    }' unless defined(&SEQ_PGM_CHANGE);
	} else {
	    eval 'sub SEQ_PGM_CHANGE {
	        local($dev, $chn, $patch) = @_;
    		eval q( &_CHN_COMMON($dev,  &MIDI_PGM_CHANGE, $chn, $patch, 0, 0));
	    }' unless defined(&SEQ_PGM_CHANGE);
	}
	eval 'sub SEQ_CONTROL {
	    local($dev, $chn, $controller, $value) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_CTL_CHANGE, $chn, $controller, 0, $value));
	}' unless defined(&SEQ_CONTROL);
	eval 'sub SEQ_BENDER {
	    local($dev, $chn, $value) = @_;
    	    eval q( &_CHN_COMMON($dev,  &MIDI_PITCH_BEND, $chn, 0, 0, $value));
	}' unless defined(&SEQ_BENDER);
	eval 'sub SEQ_V2_X_CONTROL {
	    local($dev, $voice, $controller, $value) = @_;
    	    eval q({ &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr] =  &SEQ_EXTENDED;  $_seqbuf[ &_seqbufptr+1] =  &SEQ_CONTROLLER;  $_seqbuf[ &_seqbufptr+2] = ($dev);  $_seqbuf[ &_seqbufptr+3] = ($voice);  $_seqbuf[ &_seqbufptr+4] = ($controller);  $_seqbuf[ &_seqbufptr+5] = (($value)&0xff);  $_seqbuf[ &_seqbufptr+6] = (($value>>8)&0xff);  $_seqbuf[ &_seqbufptr+7] = 0;  &_SEQ_ADVBUF(8);});
	}' unless defined(&SEQ_V2_X_CONTROL);
	eval 'sub SEQ_PITCHBEND {
	    local($dev, $voice, $value) = @_;
    	    eval q( &SEQ_V2_X_CONTROL($dev, $voice,  &CTRL_PITCH_BENDER, $value));
	}' unless defined(&SEQ_PITCHBEND);
	eval 'sub SEQ_BENDER_RANGE {
	    local($dev, $voice, $value) = @_;
    	    eval q( &SEQ_V2_X_CONTROL($dev, $voice,  &CTRL_PITCH_BENDER_RANGE, $value));
	}' unless defined(&SEQ_BENDER_RANGE);
	eval 'sub SEQ_EXPRESSION {
	    local($dev, $voice, $value) = @_;
    	    eval q( &SEQ_CONTROL($dev, $voice,  &CTL_EXPRESSION, $value*128));
	}' unless defined(&SEQ_EXPRESSION);
	eval 'sub SEQ_MAIN_VOLUME {
	    local($dev, $voice, $value) = @_;
    	    eval q( &SEQ_CONTROL($dev, $voice,  &CTL_MAIN_VOLUME, ($value*16383)/100));
	}' unless defined(&SEQ_MAIN_VOLUME);
	eval 'sub SEQ_PANNING {
	    local($dev, $voice, $pos) = @_;
    	    eval q( &SEQ_CONTROL($dev, $voice,  &CTL_PAN, ($pos+128) / 2));
	}' unless defined(&SEQ_PANNING);
	if(0) {
	    eval 'sub SEQ_PANNING {
	        local($dev, $voice, $pos) = @_;
    		eval q({ &_SEQ_NEEDBUF;  $_seqbuf[ &_seqbufptr] =  &SEQ_EXTENDED;  $_seqbuf[ &_seqbufptr+1] =  &SEQ_BALANCE;  $_seqbuf[ &_seqbufptr+2] = ;  $_seqbuf[ &_seqbufptr+3] = ;  $_seqbuf[ &_seqbufptr+4] = ($pos);  $_seqbuf[ &_seqbufptr+5] = 0;  $_seqbuf[ &_seqbufptr+6] = 0;  $_seqbuf[ &_seqbufptr+7] = 1;  &_SEQ_ADVBUF(8);});
	    }' unless defined(&SEQ_PANNING);
	}
	eval 'sub _TIMER_EVENT {
	    local($ev, $parm) = @_;
    	    eval q({ &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr+0] =  &EV_TIMING;  $_seqbuf[ &_seqbufptr+1] = ($ev);  $_seqbuf[ &_seqbufptr+2] = 0;  $_seqbuf[ &_seqbufptr+3] = 0; *& $_seqbuf[ &_seqbufptr+4] = ($parm);  &_SEQ_ADVBUF(8);});
	}' unless defined(&_TIMER_EVENT);
	eval 'sub SEQ_START_TIMER () {
	    eval q( &_TIMER_EVENT( &TMR_START, 0));
	}' unless defined(&SEQ_START_TIMER);
	eval 'sub SEQ_STOP_TIMER () {
	    eval q( &_TIMER_EVENT( &TMR_STOP, 0));
	}' unless defined(&SEQ_STOP_TIMER);
	eval 'sub SEQ_CONTINUE_TIMER () {
	    eval q( &_TIMER_EVENT( &TMR_CONTINUE, 0));
	}' unless defined(&SEQ_CONTINUE_TIMER);
	eval 'sub SEQ_WAIT_TIME {
	    local($ticks) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_WAIT_ABS, $ticks));
	}' unless defined(&SEQ_WAIT_TIME);
	eval 'sub SEQ_DELTA_TIME {
	    local($ticks) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_WAIT_REL, $ticks));
	}' unless defined(&SEQ_DELTA_TIME);
	eval 'sub SEQ_ECHO_BACK {
	    local($key) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_ECHO, $key));
	}' unless defined(&SEQ_ECHO_BACK);
	eval 'sub SEQ_SET_TEMPO {
	    local($value) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_TEMPO, $value));
	}' unless defined(&SEQ_SET_TEMPO);
	eval 'sub SEQ_SONGPOS {
	    local($pos) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_SPP, $pos));
	}' unless defined(&SEQ_SONGPOS);
	eval 'sub SEQ_TIME_SIGNATURE {
	    local($sig) = @_;
    	    eval q( &_TIMER_EVENT( &TMR_TIMESIG, $sig));
	}' unless defined(&SEQ_TIME_SIGNATURE);
	eval 'sub _LOCAL_EVENT {
	    local($ev, $parm) = @_;
    	    eval q({ &_SEQ_NEEDBUF(8);  $_seqbuf[ &_seqbufptr+0] =  &EV_SEQ_LOCAL;  $_seqbuf[ &_seqbufptr+1] = ($ev);  $_seqbuf[ &_seqbufptr+2] = 0;  $_seqbuf[ &_seqbufptr+3] = 0; *& $_seqbuf[ &_seqbufptr+4] = ($parm);  &_SEQ_ADVBUF(8);});
	}' unless defined(&_LOCAL_EVENT);
	eval 'sub SEQ_PLAYAUDIO {
	    local($devmask) = @_;
    	    eval q( &_LOCAL_EVENT( &LOCL_STARTAUDIO, $devmask));
	}' unless defined(&SEQ_PLAYAUDIO);
	eval 'sub SEQ_PLAYAUDIO2 {
	    local($devmask) = @_;
    	    eval q( &_LOCAL_EVENT( &LOCL_STARTAUDIO2, $devmask));
	}' unless defined(&SEQ_PLAYAUDIO2);
	eval 'sub SEQ_PLAYAUDIO3 {
	    local($devmask) = @_;
    	    eval q( &_LOCAL_EVENT( &LOCL_STARTAUDIO3, $devmask));
	}' unless defined(&SEQ_PLAYAUDIO3);
	eval 'sub SEQ_PLAYAUDIO4 {
	    local($devmask) = @_;
    	    eval q( &_LOCAL_EVENT( &LOCL_STARTAUDIO4, $devmask));
	}' unless defined(&SEQ_PLAYAUDIO4);
	eval 'sub SEQ_MIDIOUT {
	    local($device, $byte) = @_;
    	    eval q({ &_SEQ_NEEDBUF(4);  $_seqbuf[ &_seqbufptr] =  &SEQ_MIDIPUTC;  $_seqbuf[ &_seqbufptr+1] = ($byte);  $_seqbuf[ &_seqbufptr+2] = ($device);  $_seqbuf[ &_seqbufptr+3] = 0;  &_SEQ_ADVBUF(4);});
	}' unless defined(&SEQ_MIDIOUT);
	if(defined(&OSSLIB)) {
	    eval 'sub SEQ_WRPATCH {
	        local($patchx, $len) = @_;
    		eval q( &OSS_write_patch( &seqfd, ($patchx), $len));
	    }' unless defined(&SEQ_WRPATCH);
	    eval 'sub SEQ_WRPATCH2 {
	        local($patchx, $len) = @_;
    		eval q( &OSS_write_patch2( &seqfd, ($patchx), $len));
	    }' unless defined(&SEQ_WRPATCH2);
	} else {
	    eval 'sub SEQ_WRPATCH {
	        local($patchx, $len) = @_;
    		eval q({ &if  &SEQ_DUMPBUF();  &if ( &write( &seqfd, ($patchx), $len)==-1)  &perror(\\"Write patch: /dev/sequencer\\");});
	    }' unless defined(&SEQ_WRPATCH);
	    eval 'sub SEQ_WRPATCH2 {
	        local($patchx, $len) = @_;
    		eval q(( &SEQ_DUMPBUF(),  &write( &seqfd, ($patchx), $len)));
	    }' unless defined(&SEQ_WRPATCH2);
	}
    }
}
1;
