/* font-dialog.h - A font selction dialog.
 *
 * The interface is based on that of the GtkFontSelection widget for Gtk+.
 *
 * Copyright (C) 1998 Chris Lahey.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __GNOME_FONTSEL_H__
#define __GNOME_FONTSEL_H__


#include <gdk/gdk.h>
#include <libgnomeui/gnome-dialog.h>
#include <gtk/gtktable.h>
#include <libgnomeprint/gnome-font.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GNOME_TYPE_FONT_SELECTION		     (gnome_font_selection_get_type ())
#define GNOME_FONT_SELECTION(obj)		     (GTK_CHECK_CAST ((obj), GNOME_TYPE_FONT_SELECTION, GnomeFontSelection))
#define GNOME_FONT_SELECTION_CLASS(klass)	     (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_FONT_SELECTION, GnomeFontSelectionClass))
#define GNOME_IS_FONT_SELECTION(obj)	     (GTK_CHECK_TYPE ((obj), GNOME_TYPE_FONT_SELECTION))
#define GNOME_IS_FONT_SELECTION_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_FONT_SELECTION))

#define GNOME_TYPE_FONT_SELECTION_DIALOG		    (gnome_font_selection_dialog_get_type ())
#define GNOME_FONT_SELECTION_DIALOG(obj)		    (GTK_CHECK_CAST ((obj), GNOME_TYPE_FONT_SELECTION_DIALOG, GnomeFontSelectionDialog))
#define GNOME_FONT_SELECTION_DIALOG_CLASS(klass)	    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_FONT_SELECTION_DIALOG, GnomeFontSelectionDialogClass))
#define GNOME_IS_FONT_SELECTION_DIALOG(obj)	    (GTK_CHECK_TYPE ((obj), GNOME_TYPE_FONT_SELECTION_DIALOG))
#define GNOME_IS_FONT_SELECTION_DIALOG_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_FONT_SELECTION_DIALOG))

typedef struct _GnomeFontSelection	     GnomeFontSelection;
typedef struct _GnomeFontSelectionClass	     GnomeFontSelectionClass;

typedef struct _GnomeFontSelectionDialog	     GnomeFontSelectionDialog;
typedef struct _GnomeFontSelectionDialogClass  GnomeFontSelectionDialogClass;


struct _GnomeFontSelection
{
  GtkTable table;
  
  GtkWidget *family_name;
  GtkWidget *font_size;
  GtkWidget *font_weight;
  GtkWidget *italic;
  GtkWidget *preview;
  GtkAccelGroup *accel_group;
};


struct _GnomeFontSelectionClass
{
  GtkTableClass parent_class;
};


struct _GnomeFontSelectionDialog
{
  GnomeDialog dialog;
  
  GtkWidget *fontsel;
};

struct _GnomeFontSelectionDialogClass
{
  GnomeDialogClass parent_class;
};



/*****************************************************************************
 * GtkFontSelection functions.
 *   see the comments in the GtkFontSelectionDialog functions.
 *****************************************************************************/

GtkType	   gnome_font_selection_get_type		(void);
GtkWidget* gnome_font_selection_new		(void);
GnomeDisplayFont*   gnome_font_selection_get_font		(GnomeFontSelection *fontsel);
void   gnome_font_selection_set_font		(GnomeFontSelection *fontsel,
						 GnomeFont *font);


/*****************************************************************************
 * GnomeFontSelectionDialog functions.
 *   most of these functions simply call the corresponding function in the
 *   GnomeFontSelection.
 *****************************************************************************/

GtkType gnome_font_selection_dialog_get_type	(void);
GtkWidget* gnome_font_selection_dialog_new	(const gchar	  *title);

/* This will return the current GnomeDisplayFont, or NULL if none is
   selected or there was a problem loading it.  The GnomeDisplayFont
   is stored in a hash table, so nothing needs to be done with it. */
GnomeDisplayFont* gnome_font_selection_dialog_get_font	    (GnomeFontSelectionDialog *fsd);
void   gnome_font_selection_dialog_set_font		(GnomeFontSelectionDialog *fsd,
							 GnomeFont *font);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_FONTSEL_H__ */
