# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI LicenseKeys.pm,v 1.2 1997/01/03 23:41:53 sanders Exp

package AdminWEB::LicenseKeys;
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
    license_hostid
    license_users
    license_key
    set_license_key
    license_results
);

use AdminWEB::Support;

sub license_hostid {
    my $hostid;

    # XXX: $output matching is a hack because sysctl
    # XXX: isn't returning a proper error status
    my ($status, $output) = run_backend('sysctl', '-n', 'kern.hostid');
    if ($status == 0 && $output->[0] =~ /^\d+$/) {
	$hostid = $output->[0] + 0;	# ensure numeric representation
    }
    $hostid;				# undef on error
}

sub license_users {
    my $users;

    my ($status, $output) = run_backend('sysctl', '-n', 'kern.license_users');
    if ($status == 0 && $output->[0] =~ /^\d+$/) {
	$users = $output->[0] + 0;	# ensure numeric representation
        $users = "Unlimited" if $users == 0;
    }
    $users;				# undef on error
}

sub license_key {
    my $key;

    my ($status, $output) = run_backend('sysctl', '-n', 'kern.license');
    if ($status == 0 && $output->[0] !~ /^sysctl:/) {
	$key = $output->[0];
	chomp $key;
    }
    if ($key =~ /^\Q++++ ++++ ++++/) {
	open(KEY, '< /etc/license');
	my $install_key = <KEY>;
	close(KEY);
        chomp $install_key;
        $key = ($install_key || 'NONE');
    }
    $key;				# undef on error
}

sub set_license_key {
    my $key = shift;

    ### write it out to /etc/license
    open(KEY, '> /etc/license') || return (1, "Failed to write /etc/license\n");
    print KEY "$key\n";
    close(KEY);

    my @cmd = ('sysctl', '-w', "kern.license=$key");

    ### run the command
    my ($status, $output) = run_backend(@cmd);
    unshift(@$output, "Command: @cmd\n");
    if ($status != 0 || $output->[0] =~ /^sysctl:/) {
	return (1, $output);		# error
    }
    else {
	push(@$output, license_results());
	return (0, $output);		# ok
    }
}

sub license_results {
    "Licensed For: " . (license_users()||"ERROR") . " users";
}

1;
