# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI Paths.pm,v 1.2 1996/10/16 04:55:02 sanders Exp
#

=head1 NAME

AdminWEB::Paths -- System Administration Interface Paths Module

=head1 SYNOPSIS

use AdminWEB::Paths;

=head1 DESCRIPTION

Exports a number of path related symbols:

    $_NAME_HELP
    $_NAME_PROPERTIES
    $_NAME_VIEW
    $_PATH_BASH
    $_PATH_BSHELL
    $_PATH_CHPASS
    $_PATH_CSHELL
    $_PATH_DATE
    $_PATH_GROUP
    $_PATH_KSHELL
    $_PATH_LOGIN_CONF
    $_PATH_NAVIGATOR_PROP
    $_PATH_NOLOGIN
    $_PATH_REBOOT
    $_PATH_SHELLS
    $_PATH_SKEL
    $_PATH_SHUTDOWN
    $_PATH_TCSH
    $_PATH_ZSHELL
    $_URL_MANPAGES

=cut

package AdminWEB::Paths;
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
    $_NAME_HELP
    $_NAME_PROPERTIES
    $_NAME_VIEW
    $_PATH_BASH
    $_PATH_BSHELL
    $_PATH_CHPASS
    $_PATH_CSHELL
    $_PATH_DATE
    $_PATH_GROUP
    $_PATH_KSHELL
    $_PATH_LOGIN_CONF
    $_PATH_NAVIGATOR_PROP
    $_PATH_NOLOGIN
    $_PATH_REBOOT
    $_PATH_SHELLS
    $_PATH_SKEL
    $_PATH_SHUTDOWN
    $_PATH_TCSH
    $_PATH_ZSHELL
    $_URL_MANPAGES
);

$_PATH_NAVIGATOR_PROP = '/var/www/adminweb/interfaces/Properties';
$_NAME_PROPERTIES = 'Properties';		# std name of Properties DB
$_NAME_VIEW       = '/View';			# std name of View
$_NAME_HELP       = '/Help';			# std name of Help

# things we should get from /usr/include/paths.h -> paths.ph
$_PATH_BSHELL     = '/bin/sh';
$_PATH_CSHELL     = '/bin/csh';
$_PATH_NOLOGIN    = '/etc/nologin';
$_PATH_SHELLS     = '/etc/shells';

# things we'll define here
$_PATH_KSHELL     = '/bin/ksh';
$_PATH_BASH       = '/bin/bash';
$_PATH_TCSH       = '/bin/tcsh';
$_PATH_ZSHELL     = '/bin/zsh';
$_PATH_CHPASS     = '/usr/bin/chpass';
$_PATH_GROUP      = '/etc/group';
$_PATH_LOGIN_CONF = '/etc/login.conf';
$_PATH_SKEL       = '/usr/share/skel';
$_PATH_DATE       = '/bin/date';

$_PATH_REBOOT     = '/sbin/reboot';
$_PATH_SHUTDOWN   = '/sbin/shutdown';

$_URL_MANPAGES    = '/bsdi-man';	# URL prefix for bsdi-man gateway
