# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI StandardBackend.pm,v 1.2 1996/08/29 01:38:48 sanders Exp
#
# AdminWEB: StandardBackend Module
#
# USAGE:
#     require AdminWEB::StandardBackend;
#     AdminWEB::StandardBackend::Run('Directory Listing Status',
#         '/bin/ls [before_args...]'[, 'extra_args', ...]);
#
# extra_args are placed *after* the CGI parameters.
# before_args are split from the command and placed before the CGI parameters.

# TODO: we can use the Properties database to make Status look nicer.

package AdminWEB::StandardBackend;

use AdminWEB::Support;
require AdminWEB::Status;
require AdminWEB::CGI;

### backend_report($stat, $cgi, $status, \@output)
###
### report the results
sub backend_report {
    my ($stat, $cgi, $status, $output) = @_;

    if ($status == 0) {
	### OK
	$stat->Report("Action Completed Successfully", $output);
    }
    elsif ($status == 1) {
	### error
	$stat->Report("Action Failed", $output);
    }
    elsif ($status == 2) {
	### warning
	$stat->Report("Confirmation Required to Complete",
	    $output, confirmation($cgi));
    }
    else {
	### report unknown status
	$stat->Report("Unknown status -- assuming failure", $output);
    }
}

### build_backend_cmd($cgi, $cmd[, args...])
###
### Build a standard backend command line from the CGI query data.
### Form parameter names cannot contain an `='.
sub build_backend_cmd {
    my $cgi = shift;
    my $cmd = shift;
    my ($item, @cmd);

    push (@cmd, split(/\s+/, $cmd));
    foreach $item ($cgi->param) {
	push (@cmd, $item . '=' . join(' ', $cgi->param($item)));
    }
    push (@cmd, @_) if @_;
    @cmd;
}

### Run($title, $cmd[, args...])
###
### Run a "standard backend" command.
sub Run {
    my $title = shift;
    my $cmd = shift;
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    ### Create the Status Object
    my $stat = Create AdminWEB::Status($title);
    ### Run the command
    my ($status, $output) = run_backend(build_backend_cmd($cgi, $cmd, @_));
    backend_report($stat, $cgi, $status, $output);
    print cgi_header('text/html'), $stat->HTML;
}

1;
