# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI Status.pm,v 1.5 1998/06/16 00:06:15 tks Exp
#
# System Administration Interface Status Display Module
#
# Handles reporting status to the user including an
# optional confirmation button.

package AdminWEB::Status;
require HTML::Markup::HTML2;

### Static Method: Create($title)
###
### Creates and initializes the object.
sub Create {
    my $self = bless { }, shift;
    my ($title) = @_;

    my $html = $self->{'HTMLObject'} = Create HTML::Markup::HTML2;
    my $head = $html->HEAD($self, 'HTMLObject.HEAD');
	$_ = $title;
	if (/ơ/){
	 $html->HEAD->TITLE->Text("BSDI MAXIM Interface ");
	}
	else{
	 $html->HEAD->TITLE->Text("BSDI MAXIM Interface: " . $title);
	}

    my $body = $html->BODY($self, 'HTMLObject.BODY');
    $body->H1->Text($title);
    $body->attribute('bgcolor', "a5dbc6");
    $body->attribute('text', "000000");
    $body->attribute('link', "006600");
    $body->attribute('vlink', "996633");

    $self->{'errors'} = [ ];
    $self->{'warnings'} = [ ];

    $self;
}

sub auto_close {
    my $self = shift;
    $self->{"HTMLObject.BODY"}->onLoad("window.close()");
    $self;
}

sub errors {
    my $self = shift;
    scalar(@{$self->{'errors'}}) > 0;
}

sub warnings {
    my $self = shift;
    scalar(@{$self->{'warnings'}}) > 0;
}

sub error {
    my $self = shift;
    push (@{$self->{'errors'}}, @_);
}

sub warning {
    my $self = shift;
    push (@{$self->{'warnings'}}, @_);
}

### METHOD: ReportErrors($header[, $literal_boolean])
sub ReportErrors {
    my $self = shift;
    my ($header, $literal) = @_;

    $self->Report($header, $self->{'errors'}, $literal);
    $self;
}

### METHOD: ReportWarnings($header, $confirmation_url[, $literal_boolean])
sub ReportWarnings {
    my $self = shift;
    my ($header, $confirmation_url, $literal) = @_;

    $self->Report($header, $self->{'warnings'}, $literal, $confirmation_url);
    $self;
}

### METHOD: Report($header, \@message[, $literal_boolean[, $confirmation_url]])
###
### Generates a little report table.
sub Report {
    my $self = shift;
    my ($header, $message, $literal, $confirmation_url) = @_;
    my $body = $self->{'HTMLObject.BODY'};

    ### header/label
    my $table = $body->P->TABLE->border(2)->cellpadding(6);
    my $th = $table->TR->TH;
    $th->attribute('bgcolor', "91d5e6");
    $th->H1->Text($header);

    ### message
    my $td = $table->TR->TD;
    if ($literal) {
	map { $td->Literal($_); } @$message;
    }
    else {
	map { $td->Text($_); $td->BR; } @$message;
    }

    if ($confirmation_url) {
	my $tr = $body->P->TABLE->border(2)->cellspacing(4)->cellpadding(6)->TR;
	$_=$header;
	if (/ٹ/){
	    $tr->TH->A->href($confirmation_url)->Text("ꥯȤ¹Ԥ");
	} else {
	    $tr->TH->A->href($confirmation_url)->Text("PROCEED WITH REQUEST");
	}
    }

    $self;
}

### METHOD: HTML()
###
### Returns an HTML string built from the state of the object.
sub HTML {
    my $self = shift;
    return ($self->{'HTMLObject'})->realize;
}

1;
