#
# Routines to help manage the DNS stuff
#
# Copyright (c) 1996 Berkeley Software Design, Inc.

# NOTES:
#  check_ip -> canonicalize_ip (and code needs to $stat->error() itself)
#  check_dname changed args also (no $stat)

package	FileFormat::DNS::Utils;
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
    CanonicalizeDomain
    reload_dns
    kill_dns
    ip_2_inaddrarpa
    net_2_inaddrarpa
    byorigin
    bydomain
    get_myinfo
    canonicalize_ip
    check_dname
    cleanup_name
    mkdirp
);

use FileFormat::DNS::Paths;

sub CanonicalizeDomain {
    my $domain = shift;
    $domain =~ s/^\s+//; $domain =~ s/\s+$//;	# cleanup whitespace
    return undef unless defined $domain && $domain ne ''; 
    $domain =~ s/^\.+//; $domain =~ s/\.\.+/./;	# cleanup dots
    $domain =~ s/\.*$/./;			# force canonical
    lc($domain);
}

# XXX: use ``ndc restart''???
sub reload_dns {
    my $pid;

    if (open(NAMEDRUN, "<$_PATH_NAMED_PID")) {
	chomp ($pid = <NAMEDRUN>);
	close NAMEDRUN;
	return 0 if kill('HUP', $pid) == 1;
    }
    system $_PATH_NAMED;
    return 0;
}

# XXX: use `ndc'?
sub kill_dns {
    my $pid;

    if (open (NAMEDRUN, "<$_PATH_NAMED_PID")) {
	chomp ($pid = <NAMEDRUN>);
	close NAMEDRUN;
	return 0 if kill('TERM', $pid) == 1;
    }
}

sub ip_2_inaddrarpa {
    my $ip = shift;
    $ip =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/;

    return ("$4.$3.$2.$1.in-addr.arpa.", "$1.in-addr.arpa.", "$4.$3.$2")
	if $1 < 128;			# Class A network
    return ("$4.$3.$2.$1.in-addr.arpa.", "$2.$1.in-addr.arpa.", "$4.$3")
	if $1 > 127 && $1 < 192;	# Class B network
    return ("$4.$3.$2.$1.in-addr.arpa.", "$3.$2.$1.in-addr.arpa.", "$4");
    					# Class C network
}

sub net_2_inaddrarpa {
    my $net = shift;
    my @bytes = split(/\./,$net);

    return "$bytes[0].in-addr.arpa."
	if $bytes[0] < 128;
    return "$bytes[1].$bytes[0].in-addr.arpa."
	if $bytes[0] > 127 && $bytes[0] < 192;
    return "$bytes[2].$bytes[1].$bytes[0].in-addr.arpa.";
}

sub byorigin {
    my $p = caller;	# $a and $b are globals in the *callers* package
			# everyone say, `thank you sort'
    join('.', reverse split(/\./, ${$p . '::a'}))
	cmp join('.', reverse split(/\./, ${$p . '::b'}));
}

# bydomain sorts .arpa's to the bottom of the list
sub bydomain {
    my $p = caller;	# $a and $b are globals in the *callers* package
			# everyone say, `thank you sort'
    # force arpa's to the bottom
    my $a1 = (${$p . '::a'} =~ /arpa\.*$/);
    my $b1 = (${$p . '::b'} =~ /arpa\.*$/);
    return 1 if ($a1 && ! $b1);		# if a is arpa and b is not
    return -1 if (! $a1 && $b1);	# if b is arpa and a is not
    join('.', reverse split(/\./, ${$p . '::a'}))
	cmp join('.', reverse split(/\./, ${$p . '::b'}));
}

use FileFormat::DNS::Paths;
use FileFormat::DNS::Resolver;
use Sys::Hostname;
use AdminWEB::Netstart;

sub get_myinfo {
    my ($sys_hostname, $sys_domain);
    my ($myfqdname, $mydomain, $myipaddr);

    # Get what we believe to be the "primary" ip address for this machine.
    # This is really only used to create the default reverse domain so
    # the fact that we can never really know the correct answer isn't such
    # a big deal.
    $netstart = new AdminWEB::Netstart;
    $AdminWEB::Netstart::inet{$netstart->primary} =~ m/^\s*([\d.]+)\s+/;
    $myipaddr = $1;

    if (defined($sys_hostname = lc(Sys::Hostname::hostname()))) {
	$sys_hostname =~ s/\.+$//;	# remove any trailing dots
	$sys_domain = $1 if $sys_hostname =~ m/\.(.+)$/;
    }

    # resolver domain has priority
    my $r = new FileFormat::DNS::Resolver($_PATH_RESOLVER, 'nolock');
    if (defined $r && ! $r->created) {
	$mydomain = $r->domain;		# already canonicalized
	$r->close;
    }

    if (defined $sys_domain) {
	$mydomain = CanonicalizeDomain($sys_domain)
	    if ! defined $mydomain;
	$myfqdname = CanonicalizeDomain($sys_hostname)
    }
    else {
	# just the hostname part (if we even have that)
	$myfqdname = $sys_hostname;
    }

    # if $mydomain isn't set then $fqdnname isn't fully qualified (we tried)
    return($myfqdname, $mydomain, $myipaddr);
}

# undef on failure, canonicalized IP on success
use Socket qw(inet_aton inet_ntoa);
sub canonicalize_ip {
    my $ip = cleanup_name(shift());
    return undef unless $ip =~ /^[\d\.]+$/;
    # canonicalize it using the system routines that understand all
    # the different formats -- much too complicated to reproduce here.
    $ip = eval { inet_ntoa(inet_aton($ip)) };
    return undef if $@;				# some kind of error
    $ip;
}

sub split_ip {
    my $ip = canonicalize_ip($_[0]);
    $ip =~ /^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/;
}

sub check_dname {
    $_[0] =~ /^\./;
}

sub cleanup_name {
    my $name = lc($_[0]);
    $name =~ s/^\s+//;
    $name =~ s/\s+$//;
    $name;
}

# handles absolute and relative paths
# returns undef on failure
sub mkdirp {
    my ($dir, $mode, @p) = @_;
    return if -d $dir;				# short-cut
    local($") = '/';				# stringify joiner
    foreach (split('/', $dir)) {
	push(@p, $_);
	next if -d "@p/";			# tricks initial null @p into /
	mkdir("@p", $mode) || return undef;
    }
    return 1;
}

1;
