# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI NamedTreeHTMLView.pm,v 1.2 1997/04/17 21:12:46 sanders Exp
#

package Navigator::NamedTreeHTMLView;

use HTML::Markup::HTML2;
use DataType::NamedTree;

BEGIN { @ISA = qw(DataType::NamedTree); }

sub before_processing;
sub after_processing;

# This Class implements a "view" of the DataType::NamedTree type for
# the BSDI AdminWEB Navigator.  We do not define any data members
# that need to be initialized we also don't have to implement Class
# specific verstions of the Create/Initialize/Clone/Copy methods.
#
# We do use $object->{'description'} and $object->{'HTML_TR'} to
# hold our private data.
#
# And since we are Navigator specific there is no Class documentation
# as with the reusable classes (just comments in the code).
#
# Complex HTML Tables (with lots of SPANs) are a major pain to get right
# so be careful if you modify this code.  It's complexity (mostly
# moved into the NamedTree class) mirrors the underlying problem (you
# have to know how many leaf objects are under you and where you are
# in the tree to get the <TR>'s and spans just right).

# $html_table = $obj->MakeTable;
sub MakeTable { ## PUBLIC
    local $self = shift;

    ### Process $self into a nice table
    local $table = Create HTML::Markup::HTML2('TABLE')
	->width('100%')->border(1)->cellspacing(2)->cellpadding(2);

    local $last_item = (sort $self->childrens_names)[-1];

    process_data($self, 0, \&before_processing, \&after_processing);

    return $table
}

sub before_processing { ## PRIVATE
    # is this a leaf node?
    if ($entry->namedchild($child)->isleaf) {
	# does this parent have an HTML Table Row already allocated?
	my $td;

	if ($entry->{'HTML_TR'}) {
	    $td = $entry->{'HTML_TR'}->TD;
	    $entry->{'HTML_TR'} = undef;
	}
	else {
	    $td = $table->TR->TD;
	}
	$td->colspan($self->maxdepth - $depth);
	$td->bgcolor("ade6d0");

	$td->Literal($entry->namedchild($child)->{'description'},
		'<BR>');
    }
    else {
	# add entry for a "container"

	if ($entry->{'HTML_TR'}) {
	    $entry->namedchild($child)->{'HTML_TR'} =
		$entry->{'HTML_TR'};
	    $entry->{'HTML_TR'} = undef;
	}
	else {
	    $entry->namedchild($child)->{'HTML_TR'} = $table->TR
	}

	my $th = $entry->namedchild($child)->{'HTML_TR'}->TH;
	$th->rowspan($entry->namedchild($child)->leaves);
	$th->Literal($entry->namedchild($child)->{'description'}, '<BR>');
    }
}
sub after_processing { ## PRIVATE
    # Add blank row between top-level items, except after last item
    $table->Literal('<TR><TD COLSPAN="' . $self->maxdepth .
		'"><BR></TD></TR>')
	unless $depth || ($child eq $last_item);
}

# process_data($self, $depth, $before_CODEREF, $after_CODEREF);
# -- recurses over the $self structure calling the before and after
# -- routines to process the data.
### LOCAL SCOPE: $table, $last_item, $entry, $depth, $child
sub process_data { ## PRIVATE
    local ($entry, $depth, $before, $after) = @_;
    local $child;
    foreach $child ( sort $entry->childrens_names ) {
	&$before;
	process_data($entry->namedchild($child), $depth+1, $before, $after)
	    if $entry->notleaf;
	&$after;
    }
}

1;
