#!/usr/bin/perl5
# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.9 1996/12/19 04:49:17 sanders Exp

# XXX: need to track user ID changes so we know to remove the old account

# TODO: need way to add user to "mailing lists" (aka aliases)
#       Link login.conf classes to eventual login.conf interface.
#       Links to create a group interface where needed (e.g., Help).
#       Help should have links to the various Account interfaces.

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::Accounts::Change;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class
use Date::GetDate;		# date parsing library

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

### check($name, $field, $thing)
###
### check for $thing (a regexp) in $field
sub check {
    my ($name, $field, $thing) = @_;
    $stat->error("$name => ``$field'' ̵ʥ饯ޤǤޤ " .
	"ʸϻȤʤǲ  ${thing} ס\n") if $field =~ /$thing/;
    $field;
}

### Validates the data as best we can without making more assumptions.
sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ \n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    # must be visible in check()
    local $stat = Create AdminWEB::Status("ơ ѹ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    ### Build the chpass command line; password entry data is:
    ###     login:epasswd:uid:gid:class:change:expire:gecos:home_dir:shell

    my @pwd;

    my ($home_directory, $user_id, $group_id);

    my $login = scalar($cgi->param('account_name'));
    $stat->error("󥢥ȤǤ") if $login eq '';
    push (@pwd, check("Account Name", $login, ':'));

    my @userinfo = getpwnam($login);
    $stat->error("󥢥 `$login' ¸ߤޤ") unless @userinfo;

    ### Delay pushing stuff until after class
    # XXX: changing uid's is a pain -- need to fix this
    $uid = $userinfo[2];

    ### uid must be numeric
    # my $uid = scalar($cgi->param('uid'));
    # if ($uid ne '') {
	if ($uid !~ /^[0-9]+$/) {
	    $stat->error("桼ɣ => ``$uid'' ֹǤʤФʤޤ\n")
		unless $uid =~ /^[0-9]+$/;
	}
    # }
    # else {
    #     $uid = eval q{ next_available_uid($properties); } if $uid !~ /^[0-9]+$/;
    # }
    $user_id = $uid;

    my $group = scalar($cgi->param('pgroup'));
    my @group = getgrnam($group);
    if (! @group) {
	### This should rarely happen because we generated the list
	### of groups for the form ourselves, but anything can happen.
	$stat->error("롼 $group ¸ߤޤ\n");
    }
    $group_id = $group[2];

    ### verify additional groups here, building @gids for the code below
    my @gids;
    foreach $group ($cgi->param('groups')) {
	@group = getgrnam($group);
	if (@group) {
	    push (@gids, $group[2]);
	}
	else {
	    $stat->error("롼 $group ¸ߤޤ\n");
	    # TODO: link to create group interface
	    $stat->error("   Ϥ˺Ʋ\n");
	}
    }

    my $classes = get_login_conf();
    my $class = check("Login Class", scalar($cgi->param('class')), ':');
    if (! grep(${class} eq $_, @$classes)) {
	$stat->warning("󥯥饹 ``${class}'' ̵Ǥ\n");
    }

    if (scalar($cgi->param('pw'))) {
        if (scalar($cgi->param('pw')) eq '*') {
	    push (@pwd, '*');
	}
	else {
	    my @pwds = $cgi->param('pw');
	    if ($pwds[0] ne $pwds[1]) {
		$stat->error("ѥɤפޤ̤ꡢϤƲ");
	    }
	    else {
		### Users should always change their issued passwords.
		### Encrypting here is only a small measure of security.
		eval {
		    push (@pwd, encrypt_passwd($class, scalar($cgi->param('pw'))));
		};
		$stat->error($@) if $@;
	    }
	}
    }
    else {
	push (@pwd, $userinfo[1]);		# leave it alone
    }
    push (@pwd, $uid);
    push (@pwd, $group_id);
    push (@pwd, $class);

    push (@pwd, '0');		# no support for `change' field right now

    if (scalar($cgi->param('expires_date'))) {
	my $time = eval q{ getdate(scalar($cgi->param('expires_date'))) };
	$stat->error($@) if $@;
	$stat->error("̵  ȥ󥰤Ǥ\n") if $time == -1;
	push (@pwd, $time);
    }
    else {
	my $exp = scalar($cgi->param('expires'));
	$stat->error("̵ ͭͤǤ: $exp\n")
	    unless defined $expiry{$exp};
	push (@pwd, $expiry{$exp});
    }

    ### check GECOS data for commas and colons
    push (@pwd, join(',',
	check("Full Name", $cgi->param('realname') || '', '[,:]'),
	check("Location", $cgi->param('location') || '', '[,:]'),
	check("Work Phone", $cgi->param('wphone') || '', '[,:]'),
	check("Home Phone", $cgi->param('hphone') || '', '[,:]')));

    # XXX: changing home directory is a pain -- need to clairify what
    # XXX: exactly we are commited to doing.
    ### home directory: trailing slash means append account name;
    ### otherwise it's the real homedir
    my $home = scalar($cgi->param('home'));
    $home_directory = $home = @userinfo[7];
    check("Home Directory", $home, ':');
    #if ($home =~ m,/$,) {
	#$home_directory = $home . $login;
    #}
    #else {
	#$home_directory = $home;
    #}
    push (@pwd, $home_directory);

    push (@pwd, check("Login Shell", scalar($cgi->param('shell')), ':'));

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
        $stat->ReportErrors("եǡΥ顼");
        print $stat->HTML;
        return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
        $stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
            confirmation($cgi));
        print $stat->HTML;
        return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
        $stat->Report("եΥǡǧޤ");
        print $stat->HTML;
        return;
    }

    # print any debugging information you need
    print "<P>\n<B>DEBUG: @pwd</B>\n$cgi" if $DEBUG;

    if ($navigator->value('Demo')) {
        $stat->Report("DEMO", ["No action was taken at this time."]);
        print $stat->HTML;
        exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my $output = [];

    if (! $DEBUG) {
	### run the command
	my ($status, $output) = put_account(\@pwd);
	if ($status != 0) {
	    $stat->Report("ޥɼ¹ԻΥ顼Ǥ", $output);
	    print $stat->HTML;
	    return;
	}
    }
    push(@$output, "$login Υȥǡ򹹿ޤ");

    # add user to additional groups in /etc/group
    if ($DEBUG) {
	if (@gids) {
	    print "<P>\nAdding user to Additional Groups: ",
		join(', ', $cgi->param('groups')), "\n";
	}
	else {
	    print "<P>No additional groups for this user\n";
	}
    }
    else {
	eval q{
	    setuser_group($login, @gids);
	    push(@$output, "$login: 롼פɲϿޤ");
	} if @gids;
	if ($@) {
	    $stat->Report("ɲå롼פؤΥ桼ɲå顼Ǥ", [ $@ ]);
	    # XXX: backout();
	    print $stat->HTML;
	    return;
	}
    }

    $stat->Report("ޥｪλ", $output);
    print $stat->HTML;
}
