sub Initialize {
    ### expire time in seconds
    my $now = time;
    %expiry = (
	'Never'         => 0,
	'One Week'      => $now + 60*60*24 * 7,
	'One Month'     => $now + 60*60*24 * 30,
	'Three Months'  => $now + 60*60*24 * 30 * 3,
	'Six Months'    => $now + 60*60*24 * 30 * 6,
	'One Year'      => $now + 60*60*24 * 365,
    );
}

sub InitializeView {
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	### groups to ignore
	my $group_filter = $properties->value('Default_Group_Filter');
	$group_filter =~ s/\s+/|/g;
	$groups = get_groups('^(' . $group_filter . ')\b');

	### classes to ignore
	my $class_filter = $properties->value('Default_Login_Class_Filter');
	$class_filter =~ s/\s+/|/g;
	$classes = get_login_conf('^(' .  $class_filter . ')\b');

	$shells = get_shells();
	unshift(@$shells, 'No Login');

	### mapping of shell's to their man pages
	%shell_man = (
	    $_PATH_BSHELL   => "${_URL_MANPAGES}?sh(1)",
	    $_PATH_CSHELL   => "${_URL_MANPAGES}?csh(1)",
	    $_PATH_KSHELL   => "${_URL_MANPAGES}?ksh(1)",
	    $_PATH_BASH     => "${_URL_MANPAGES}?bash(1)",
	    $_PATH_TCSH     => "${_URL_MANPAGES}?tcsh(1)",
	    $_PATH_ZSHELL   => "${_URL_MANPAGES}?zsh(1)",
	    $_PATH_NOLOGIN  => "${_URL_MANPAGES}?nologin(8)",
	    'No Login'      => "${_URL_MANPAGES}?nologin(8)",
	);

	Initialize();

	init_cgi_from_login($cgi, $cgi->param('account_name'));
    }
}

# init_cgi_from_login($cgi, $login);
sub init_cgi_from_login {
    my $cgi = shift;
    my $login = shift;

    # getpwent returns:
    my ($name, $passwd, $uid, $gid, $change, $class,
	$gecos, $dir, $shell, $expire);

    ($name, $passwd, $uid, $gid, $change, $class,
		$gecos, $dir, $shell, $expire) = getpwnam($login);

    $cgi->param('account_name', $name);
    $cgi->param('pw1', $passwd);
    $cgi->param('uid', $uid);

    $cgi->param('pgroup', (getgrgid($gid))[0]);

    # find groups that $name is in
    local @groups;
    eval q{
	my ($group, $gid, $gpasswd, $members) = parsegroup($_PATH_GROUP);
	my $grp;
	foreach $grp (keys %$members) {
	    if ($members->{$grp} =~ /\b$name\b/o) {
		push(@groups, $grp);
	    }
	}
	# writegroup($_PATH_GROUP, $group, $gid, $gpasswd, $members);
    };
    if ($@) {
        require AdminWEB::Status;
	$stat = Create AdminWEB::Status;
	$stat->error("failed processing group list for $login: $@");
	$stat->ReportErrors("Error");
	print $stat->HTML;
	exit(0);
    }
    print "Groups: @groups<BR>\n";
    $cgi->param('groups', @groups);

    $cgi->param('class', $class eq '' ? 'default' : $class);

    my @gecos = split(/,/, $gecos, 4);
    $cgi->param('realname', $gecos[0]);
    $cgi->param('location', $gecos[1]);
    $cgi->param('wphone', $gecos[2]);
    $cgi->param('hphone', $gecos[3]);

    $cgi->param('home', $dir);

    $cgi->param('shell', $shell eq '/sbin/nologin' ? 'No Login' : $shell);

    if ($expire == 0 || $expire !~ /^\d+$/) {
	$cgi->param('expires', 'Never');
    }
    else {
	# $expire has been made safe now (it's only digits)
	# convert $expire into human readable format
	chomp($date = `$_PATH_DATE -r $expire 2>/dev/null`);
	# XXX: could handle errors better with run_backend
	$cgi->param('expires_date', $date);
    }
}

1;
