#!/usr/bin/perl5
# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.27 1999/12/03 22:47:50 polk Exp

# TODO: need way to add user to "mailing lists" (aka aliases)
#       Link login.conf classes to eventual login.conf interface.
#       Links to create a group interface where needed (e.g., Help).
#       Help should have links to the various Account interfaces.

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::Accounts::Create;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class
use Time::ParseDate;		# date parsing library

BEGIN {
    %classtype = (
	'Administrative' => 'staff',
	'Restricted'     => 'restricted',
    );
}

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

### check($name, $field, $thing)
###
### check for $thing (a regexp) in $field
sub check {
    my ($name, $field, $thing) = @_;
    $stat->error("$name => ``$field'' ̵ʥ饯ޤǤޤ" .
	"ʸϻȤʤǲ  ${thing} ס\n") if $field =~ /$thing/;
    $field;
}

### Validates the data as best we can without making more assumptions.
sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    # must be visible in check()
    local $stat = Create AdminWEB::Status("ơ Ⱥ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    ### Build the password entry data:
    ###     login:epasswd:uid:gid:class:change:expire:gecos:home_dir:shell
    my @pwd;

    my ($home_directory, $user_id, $group_id);

    my $login = scalar($cgi->param('account_name'));
    $stat->warning(" $login ¸ߤޤ(񤭤ƤǤ).\n")
	if getpwnam($login);
    $stat->error("󥢥ȤǤ") if $login eq '';
    push (@pwd, check("Account Name", $login, '^-|[:.]'));

    # Things get strange here because we need the users class
    # so we can call encrypt_passwd.  So we avoid pushing things
    # onto @pwd until we have all the info.

    ### uid must be numeric
    my $uid = scalar($cgi->param('uid'));
    if ($uid ne '') {
	if ($uid !~ /^[0-9]+$/) {
	    $stat->error("桼ɣ => ``$uid'' ϿǤʤФʤޤ\n")
		unless $uid =~ /^[0-9]+$/;
	}
	else {
	    $stat->warning("ֹ $uid ϤǤ¸ߤޤ\n")
		if getpwuid($uid);
	}
    }
    else {
	$uid = eval q{ next_available_uid($properties); } if $uid !~ /^[0-9]+$/;
    }
    $user_id = $uid;

    my $group = scalar($cgi->param('pgroup'));
    my @group = getgrnam($group);
    if (! @group) {
	### This should rarely happen because we generated the list
	### of groups for the form ourselves, but anything can happen.
	$stat->error("롼 $group ¸ߤޤ\n");
    }
    $group_id = $group[2];

    ### verify additional groups here, building @gids for the code below
    my @gids;
    # amend groups if Administrative account
    if ($cgi->param('account_type') eq 'Administrative') {
	$cgi->param('groups', $cgi->param('groups'), 'wheel', 'staff', 'maxim');
    }
    # now process the list
    foreach $group ($cgi->param('groups')) {
	@group = getgrnam($group);
	if (@group) {
	    push (@gids, $group[2]);
	}
	else {
	    $stat->error("롼 $group ¸ߤޤ\n");
	    # TODO: link to create group interface
	    $stat->error("   ǽ˺ʤФʤޤ\n");
	}
    }

    my $classes = get_login_conf();
    my $class = check("Login Class", scalar($cgi->param('class')), ':');
    if (defined $cgi->param('account_type')
	    && exists $classtype{$cgi->param('account_type')}
	    && grep ($classtype{$cgi->param('account_type')} eq $_, @$classes)
	    && $cgi->param('View') ne 'Expert.view') {
	$class = $classtype{$cgi->param('account_type')};
    }

    if (! grep(${class} eq $_, @$classes)) {
	$stat->warning("󥯥饹 ``${class}'' ̵Ǥ\n");
    }

    ### Ok, we have the class, now process password and push the other
    ### stuff onto @pwd.
    if (scalar($cgi->param('pw')) && scalar($cgi->param('pw')) ne '*') {
	my @pwds = $cgi->param('pw');
	if ($pwds[0] ne $pwds[1]) {
	    $stat->error("ѥɤפޤ̤ꡢϤƲ");
	}
	else {
	    ### Users should always change their issued passwords.
	    ### Encrypting here is only a small measure of security.
	    eval {
		push (@pwd, encrypt_passwd($class, scalar($cgi->param('pw'))));
	    };
	    $stat->error($@) if $@;
	}
    }
    else {
	push (@pwd, '*');
    }
    push(@pwd, $uid);
    push (@pwd, $group_id);
    push (@pwd, $class);

    push (@pwd, '0');		# no support for `change' field right now

    if (scalar($cgi->param('expires_date'))) {
	my $time = eval q{ parsedate(scalar($cgi->param('expires_date'))) };
	$stat->error($@) if $@;
	$stat->error("  ȥ󥰤̵Ǥ\n") if $time == -1;
	push (@pwd, $time);
    }
    else {
	my $exp = scalar($cgi->param('expires'));
	$stat->error("̵ ͭͤǤ:$exp\n")
	    unless defined $expiry{$exp};
	push (@pwd, $expiry{$exp});
    }

    ### check GECOS data for commas and colons
    push (@pwd, join(',',
	check("Full Name", $cgi->param('realname') || '', '[,:]'),
	check("Location", $cgi->param('location') || '', '[,:]'),
	check("Work Phone", $cgi->param('wphone') || '', '[,:]'),
	check("Home Phone", $cgi->param('hphone') || '', '[,:]')));

    ### home directory: trailing slash means append account name;
    ### otherwise it's the real homedir
    my $home = scalar($cgi->param('home'));
    check("Home Directory", $home, ':');
    if ($home =~ m,/$,) {
	$home_directory = $home . $login;
    }
    else {
	$home_directory = $home;
    }
    push (@pwd, $home_directory);

    push (@pwd, check("Login Shell", scalar($cgi->param('shell')), ':'));

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
        $stat->ReportErrors("եǡΥ顼");
        print $stat->HTML;
        return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
        $stat->ReportWarnings("ٹ ¹Ԥγǧ",
            confirmation($cgi));
        print $stat->HTML;
        return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
        $stat->Report("եǡǧޤ");
        print $stat->HTML;
        return;
    }

    # print any debugging information you need
    print "<P>\n<B>DEBUG:</B>\n$cgi" if $DEBUG;

    if ($navigator->value('Demo')) {
        $stat->Report("DEMO", ["No action was taken at this time."]);
        print $stat->HTML;
        exit(0);
    }

    # XXX: need to save /etc/master.passwd and /etc/group and
    # XXX: backout all changes if anything fails.  This also
    # XXX: means we'll need to do some locking.

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my $output = [];

    if (! $DEBUG) {
	### add the user account
	my ($status, $output) = put_account(\@pwd);
	if ($status != 0) {
	    $stat->Report("ޥɼ¹ԤΥ顼Ǥ", $output);
	    print $stat->HTML;
	    return;
	}
    }
    push(@$output, "ΥȤޤ: $login (桼ɣ: $user_id)");

    # add user to additional groups in /etc/group
    if ($DEBUG) {
	if (@gids) {
	    print "<P>\nAdding user to Additional Groups: ",
		join(', ', $cgi->param('groups')), "\n";
	}
	else {
	    print "<P>No additional groups for this user\n";
	}
    }
    else {
	eval q{
	    setuser_group($login, @gids);
	    push(@$output, "$login: 롼פɲϿޤ");
	} if @gids;
	if ($@) {
	    $stat->Report("ɲå롼פؤΥ桼ɲå顼Ǥ", [ $@ ]);
	    # XXX: backout();
	    print $stat->HTML;
	    return;
	}
    }

    if ($DEBUG) {
	print "<P>\nCreating user home directory from SKEL\n"
	    unless -d $home_directory;
    }
    else {
	eval q{ install_skel($properties->value('Default_Skel_Directory'),
	    $home_directory, $user_id, $group_id, $class,
	    $properties->value('Default_Home_Directory_Mode'));
	    push(@$output, "$login: ۡǥ쥯ȥ꤬ޤ");
	} unless -d $home_directory;
	if ($@) {
	    $stat->Report("ۡǥ쥯ȥΥ顼Ǥ", [ $@ ]);
	    # XXX: but do not remove account at this point
	    # XXX: backout();
	    print $stat->HTML;
	    return;
	}
    }

    return if $DEBUG;

    $stat->Report("ޥｪλ", $output);
    print $stat->HTML;
}
