sub Initialize {
    ### expire time in seconds
    my $now = time;
    %expiry = (
	'Never'         => 0,
	'One Week'      => $now + 60*60*24 * 7,
	'One Month'     => $now + 60*60*24 * 30,
	'Three Months'  => $now + 60*60*24 * 30 * 3,
	'Six Months'    => $now + 60*60*24 * 30 * 6,
	'One Year'      => $now + 60*60*24 * 365,
    );
}

sub InitializeView {
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	### groups to ignore
	my $group_filter = $properties->value('Default_Group_Filter');
	$group_filter =~ s/\s+/|/g;
	$groups = get_groups('^(' . $group_filter . ')\b');

	### classes to ignore
	my $class_filter = $properties->value('Default_Login_Class_Filter');
	$class_filter =~ s/\s+/|/g;
	$classes = get_login_conf('^(' .  $class_filter . ')\b');

	$shells = get_shells();
	unshift(@$shells, 'No Login');

	### eval to catch any errors from next_available_uid();
	$nuid = eval q{ next_available_uid($p); };

	### mapping of shell's to their man pages
	%shell_man = (
	    $_PATH_BSHELL   => "${_URL_MANPAGES}?sh(1)",
	    $_PATH_CSHELL   => "${_URL_MANPAGES}?csh(1)",
	    $_PATH_KSHELL   => "${_URL_MANPAGES}?ksh(1)",
	    $_PATH_BASH     => "${_URL_MANPAGES}?bash(1)",
	    $_PATH_TCSH     => "${_URL_MANPAGES}?tcsh(1)",
	    $_PATH_ZSHELL   => "${_URL_MANPAGES}?zsh(1)",
	    $_PATH_NOLOGIN  => "${_URL_MANPAGES}?nologin(8)",
	    'No Login'      => "${_URL_MANPAGES}?nologin(8)",
	);

	Initialize();
    }
}

1;
