#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.9 1996/10/11 20:55:20 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::Accounts::Remove;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ Ⱥ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    require '../utils.pl';
    Initialize();

    my @homedirs;

    # getpwent returns:
    my ($name, $passwd, $uid, $gid, $change, $class,
	$gecos, $dir, $shell, $expire);
    my $output = [ ];

    # uniquify the list
    my %logins;
    for $login ($cgi->param('account_name'), $cgi->param('logins')) {
	$logins{$login} = 1;
    }

    $stat->error("Ȥ򤵤Ƥޤ") unless scalar(keys %logins) > 0;

    my $login;
    for $login (keys %logins) {
	($name, $passwd, $uid, $gid, $change, $class,
		    $gecos, $dir, $shell, $expire) = getpwnam($login);

	if (! defined $login) {
	    # error if $login doesn't exist
	    $stat->error(" $login ¸ߤޤ\n");
	}
	else {
	    push(@homedirs, $dir);
	    $class = 'default' if $class eq '';
	    my $full = $gecos; $full =~ s/,.*//;
	    push(@$output, fmtaccount($name, $full, $class, $dir));
	}
    }

    # sort @$output and add the <TABLE> wrapper and headers
    @$output = sort @$output;
    unshift(@$output,
	'<TABLE BORDER=0><TR>'
	. '<TH ALIGN="left">Login</TH>'
	. '<TH ALIGN="left">Name</TH>'
	. '<TH ALIGN="left">Class</TH>'
	. '<TH ALIGN="left">Home Directory<BR></TH></TR>');
    push(@$output, '</TABLE>');
    push(@$output, '<P>Ⱥǽǧ');
    $stat->warning(@$output);

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡ顼Ǥ");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ ¹Ԥγǧ",
	    confirmation($cgi), 'literal');
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>\n$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
        $stat->Report("DEMO", ["No action was taken at this time."]);
        print $stat->HTML;
        exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my ($group, $gpasswd, $members); # $gid is already my'ed
    ($group, $gid, $gpasswd, $members) = parsegroup($_PATH_GROUP);
    my $changed_grp = 0;

    my (@results);
    for $login (keys %logins) {
	my ($status, $output) = run_backend $_PATH_CHPASS, '-d', $login;
	$stat->error("$loginκ顼\n") unless $status == 0;
	push(@results, @$output);

	# XXX handle removing/archiving home directory
	# XXX user crons, at commands, and /var/mail/$login

	# remove user from /etc/groups
	for $_ (keys %group) {
	    if ($members{$_} =~ /\b${login}\b/) {
		$members{$_} =~ s/\b${login}\b//;
		$members{$_} =~ s/,,/,/;
		$members{$_} =~ s/,$//;
		$changed_grp++;
	    }
	}
    }

    writegroup($_PATH_GROUP, $group, $gid, $gpasswd, $members) if $changed_grp;

    push(@results,
	"",
	"ʲΤΤ¸뤫Ʋ",
	"桼ۡǥ쥯ȥꡢ/var/cron/tabs/USER ե롢/var/mail/USER ",
	"/var/spool/at Υå¾",
	"㡧 ",
	"    rm -r @homedirs ",
    );

    $stat->Report("桼Ϻޤ", \@results);
    print $stat->HTML;
}
