#!/usr/bin/perl5 -w
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1996/11/15 17:49:51 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package AdminWEB::DNS::Configure_Resolver;
use FileFormat::DNS::Paths;
use FileFormat::DNS::Utils;
use FileFormat::DNS::Resolver;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
use vars qw($cgi_header_generated);
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ꥾Хѥ᡼");

    ### PROCESS CGI DATA

    # require './initialize.pl';
    # Initialize();

    my $domain_name = scalar($cgi->param('domain_name'));
    my $domain = CanonicalizeDomain($domain_name);
    $stat->error("̵ʥɥᥤ̾: $domain_name\n")
	unless defined $domain;

    my @NS;
    foreach $_ (1..3) {
	my $ip = scalar($cgi->param('nameserver_' . $_));
	if (defined $ip && $ip ne '') {
	    $canon_ip = canonicalize_ip($ip);
	    $stat->error("̵ʣɣХɥ쥹եޥå: " . $ip . "\n")
		if ! defined $canon_ip;
	    push(@NS, $canon_ip);
	}
	
    }
    # Default
    push(@NS,"0.0.0.0") unless @NS;

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ ¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    ### Set Resolver Parameters
    eval {
	my $r = new FileFormat::DNS::Resolver($_PATH_RESOLVER);
	$r->domain($domain);
	$r->nameserver(@NS);
	$r->close;
    };

    if ( $@ ) {
        $stat->error($@);
        $stat->ReportErrors("꥾Хե $_PATH_RESOLVER ؤε顼");
        print $stat->HTML;
        return;
    }

    my @message;

    push(@message,"ФϽޤ");
    push(@message,"ɥᥤ̾  $domain");
    push(@message,"䥵  @NS");

    $stat->Report("ޥｪλ", \@message);
    print $stat->HTML;
}
