# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI initialize.pl,v 1.2 1996/10/16 05:08:26 sanders Exp

# View.cgi initialization
sub Initialize {
}

### View specific initializations, called by `Initialize:' in Viewfile
sub InitializeView {
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	Initialize();

	($myfqdname,$fwd_domain,$myipaddr) = get_myinfo();
	$rev_domain = net_2_inaddrarpa($myipaddr) if $myipaddr ne '';
	$config_file = $_PATH_NAMED_BOOT;
	# $named is global (used in view)
	$named = new FileFormat::DNS::NamedBoot($config_file);
        $dbdir_name = $named->directory || $_PATH_DNS_DBDIR;

	if (defined $named->primary($fwd_domain)) {
	    use FileFormat::DNS::DomainDB;
	    use Sys::Hostname;
	    $db = $named->primary_open($fwd_domain);
	    my @NS;
	    push(@NS, $cgi->param('ns1')) if defined $cgi->param('ns1');
	    push(@NS, $cgi->param('ns2')) if defined $cgi->param('ns2');
	    push(@NS, $cgi->param('ns3')) if defined $cgi->param('ns3');
	    unless (@NS) {
		@NS = grep { $_ !~ /^\Q$myfqdname\E$/i }
		    $db->owner($fwd_domain)->NS;
	    }
	    push(@NS, CanonicalizeDomain(hostname()));
	    $cgi->param('ns1', pop @NS);
	    $cgi->param('ns2', pop @NS);
	    $cgi->param('ns3', pop @NS);
	}

	# forwarder can be a space seperated list of forwarders
	$forwarder = ($named->forwarders)[0];
    }
}

1;
