#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.4 1996/10/11 20:55:28 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Domain_Secondary;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

use FileFormat::DNS::Paths;
use FileFormat::DNS::Utils;
use FileFormat::DNS::NamedBoot;

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ɥᥤ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    my ($domain, $ipaddr);

    if ($cgi->param('Action') eq 'Edit') {
	$domain = CanonicalizeDomain($cgi->param('secondary'));
	print "Location: ",
	    "/View/JP/SysAdmin/DNS/Domain_Secondary/Edit/Standard.view?",
	    $cgi->query_string, "\r\n\r\n";
	exit(0);
    }
    elsif ($cgi->param('Action') eq 'Delete') {
	$domain = CanonicalizeDomain($cgi->param('secondary'));
    }
    elsif ($cgi->param('Action') eq 'Create') {
	$domain = CanonicalizeDomain($cgi->param('new_secondary'));
	$ipaddr = canonicalize_ip($cgi->param('new_secondary_ip'));
	$stat->error("̵ʣɣХɥ쥹 " . $cgi->param('new_secondary_ip'))
	    unless defined $ipaddr;

	# XXX:
	if (0) {
	    $stat->warning("$ipaddr ɣХɥ쥹ѹƲ" .
			   "this will hang if you aren't on the Internet" .
			   "so you would need to enter the IP Address");
	}
    }
    else {
	$stat->error(" (" . $cgi->param('Action')
	    . ") isn't one of Create/Edit/Delete");
	$stat->ReportErrors('顼̵ʥǤ');
	print cgi_header('text/html'), $stat->HTML;
	exit(0);
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ ¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    ($myfqdname, $mydomain, $myipaddr) = get_myinfo();
    if ($mydomain eq '') {
	$stat->error('ɥᥤƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Resolver/Standard.view">ɥᥤ</A> ԤäƲ');
	$stat->ReportErrors('顼ɥᥤƤޤ','literal');
	print $stat->HTML;
	return;
    }

    my @messages;
    my $named = new FileFormat::DNS::NamedBoot($_PATH_NAMED_BOOT);

    if ($cgi->param('Action') eq 'Create') {
	do_create($named, $domain, $ipaddr);
	push (@messages,"$domain ꤬ޤ");
    }
    elsif ($cgi->param('Action') eq 'Edit') {
	# Cannot get here -- it's redirected above
    }
    elsif ($cgi->param('Action') eq 'Delete') {
	$named->secondary($domain, undef);
	push (@messages,"$domain ޤ");
    }

    # demo mode writes into dummy files
    if ($navigator->value('Demo')) {
	$stat->Report('DEMO', ['Named Daemon not Reloaded']);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@messages,'ǡ󤬥ɤޤ');

    $stat->Report('ޥｪλ', \@messages);
    print $stat->HTML;
}

sub do_create {
    my ($named, $domain, $ipaddr) = @_;

    # Check if the domain already exists somewhere
    if (defined $named->primary($domain)) {
	$stat->error("ΥۥȤϤǤ˥ץ饤ޥꥵФǤ" .
	    "Domain $domain");
	$stat->ReportErrors('顼ɥᥤ¸ߤޤ');
	print $stat->HTML;
	exit(0);
    }
    if (defined $named->secondary($domain)) {
	$stat->error("ΥۥȤϤǤ˥ꥵФǤ" .
	    "Domain $domain");
	$stat->ReportErrors('Error: Domain Exists');
	print $stat->HTML;
	exit(0);
    }

    # file is relative to "directory" in named.boot
    my $file = "secondaries/" . $domain;
    $file =~ s/\.*$//;
    $named->secondary($domain, [ $file, $ipaddr ]);
}
