#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:47 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary::Create;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES:  ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ץ饤ޥģΣӥɥᥤκ");

    ### PROCESS CGI DATA

    #require './initialize.pl';
    #Initialize();

    print cgi_header('text/html');

    # Collect the data from the form
    my $domain = cleanup_name(scalar($cgi->param('newdomain')));
    $domain =~ s/\.*$/\./;
    my $defmailer = cleanup_name(scalar($cgi->param('domain_mailhost')));
    my @secondary;
    push(@secondary,cleanup_name(scalar($cgi->param('domain_secondary1'))))
	if $cgi->param('domain_secondary1');
    push(@secondary,cleanup_name(scalar($cgi->param('domain_secondary2'))))
	if $cgi->param('domain_secondary2');



    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('ɥᥤƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Resolver/Standard.view">ɥᥤ̾</A>ԤäƲ');
        $stat->ReportErrors("顼ɥᥤƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Already Configured
        $stat->error('ФƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Server/Standard.view">ģΣӥн</A>ԤäƲ');
        $stat->ReportErrors("顼ФƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    if ( read_config($conf_file) != 0 ) {
        $stat->error("ե $conf_file ɤळȤǤޤ");
        $stat->ReportErrors("顼:ФԽƤޤ");
        print $stat->HTML;
        return;
    }

    # check if the domain already exists as a Primary or Secondary
    if ( defined $PRIMARY{$domain} ) {
        $stat->error("ΥۥȤϤǤ˥ɥᥤ $domain Υץ饤ޥꥵФǤ");
    }
    if ( defined $SECONDARY{$domain} ) {
        $stat->error("ΥۥȤϤǤ˥ɥᥤ $domain ΥꥵФǤ");
    }
    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    #
    # Now create the domain
    #
    init_domain($domain,$defmailer,$myfqdname,@secondary);

    # if my own domain add this host

    if ( $domain eq $mydomain && $myipaddr ne "" ) {
        $myhost = $myfqdname;
        if ( $myhost eq $mydomain ) {
            $myhost = "";
	}
        else {
            $myhost =~ s/^([^\.]*)\..*/$1/;
	}

        # Add my A record
        my $dbfile = $PRIMARY{$domain};
        $dbfile = "$dbdir/$dbfile" if $dbdir ne "";
        set_arec("$dbfile,$domain,$myhost",$ttl,$myipaddr);

        # Add my reverse record (only if I am the primary
        set_reverse($myipaddr,"$dbfile,$domain,$myhost");

        # Make it so I can receive mail
        set_mx("$dbfile,$domain,$myhost",$ttl,5,$myfqdname);
    }

    # Now write everything out

    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
            $stat->error("ģ¥ե $dbfileɤ߹ߤ˼Ԥޤ");
            $stat->error(@AdminWEB::DNS::errors);
            $stat->ReportErrors("ޥɼԡɥᥤ $domain ɲäޤǤ");
            print $stat->HTML;
            return;
	}
    }
    if ( write_config($conf_file) != 0 ) {
        $stat->error("ե $conf_file ؤν񤭹ߤԤޤ");
        $stat->error(@AdminWEB::DNS::errors);
        $stat->ReportErrors("ޥɼԡɥᥤ $domain ɲäޤǤ");
        print $stat->HTML;
        return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named ǡϥɤޤ"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"Named ǡ󤬥ɤޤ");

    push (@message,"Υץ饤ޥɥᥤޤ $domain");
    $stat->Report("ޥｪλ", \@message);
    print $stat->HTML;
    return;
}

