#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:50 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary::Delete;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ץ饤ޥģΣӥɥᥤκ");

    ### PROCESS CGI DATA

    # require './initialize.pl';
    # Initialize();

    # Get the form data
    my $domain = cleanup_name(scalar($cgi->param('domain_name')));
    $domain =~ s/\.*$/\./;

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Ǥϲ¹ԤޤǤ"]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('ɥᥤƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Resolver/Standard.view">ɥᥤ̾</A>ԤäƲ');
        $stat->ReportErrors("顼ɥᥤƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Already Configured
        $stat->error('ФƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Server/Standard.view">ģΣӥн</A>ԤäƲ');
        $stat->ReportErrors("顼ФƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    # Now get the data
    if ( read_config($conf_file) != 0 ) {
        $stat->error("ե $conf_file ɤ߹ߤǤޤ");
	$stat->error(@AdminWEB::DNS::errors);
        $stat->ReportErrors("ޥɼ");
	print $stat->HTML;
	return;
    }

    # Make sure we are a Primary
    if ( ! defined $PRIMARY{$domain} ) {
	$stat->error("ΥۥȤ ɥᥤ $domain Υץ饤ޥǤϤޤ");
	$stats->ReportErrors("ץ饤ޥǤϤޤ");
        print $stat->HTML;
        return;
    }

    if ( delete_domain($domain) != 0 ) {
        push(@message,"ɥᥤԴǤ");
    }
    # Now write out any reverse domains that may have been changed
    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
            $stat->error("ģ¥ե $dbfile ؤν񤭹ߤǤޤ");
	    $stat->error(@AdminWEB::DNS::errors);
            $stat->ReportErrors("ޥɼ");
	    print $stat->HTML;
	    return;
	}
    }

    if ( write_config($conf_file) != 0 ) {
        $stat->error("ե $conf_file ؤν񤭹ߤǤޤ");
	$stat->error(@AdminWEB::DNS::errors);
        $stat->ReportErrors("ޥɼ");
	print $stat->HTML;
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named ǡϥɤޤ"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"Named ǡ󤬥ɤޤ");

    push (@message,"ɥᥤϺޤ$domain");
    $stat->Report("ޥｪλ", \@message);
    print $stat->HTML;
    return;
}
