# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI initialize.pl,v 1.1 1996/09/20 20:46:59 sanders Exp

# View.cgi initialization
sub Initialize {
}

### View specific initializations, called by `Initialize:' in Viewfile
sub InitializeView {
    my $ttl;
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	Initialize();		# shares with view.cgi Initialize()

        my ($myfqdname,$mydomain,$myip) = get_myinfo();
	read_config($conf_file);
        my $domain = cleanup_name($cgi->param('domain_name'));
        $domain =~ s/\.*$/\./;

        if ( defined $PRIMARY{$domain} ) {
            $dbfile = $PRIMARY{$domain};
            $dbfile = "$dbdir/$dbfile" if $dbdir ne "";

            read_dbfile($dbfile,$domain);
            if ( defined $A_REC{"$dbfile,$domain,"} ) {
                my @arec_list = split(':',$A_REC{"$dbfile,$domain,"});
		($ttl,$domain_ip) = split(',',$arec_list[0]);
            }
            if ( defined $NS{"$dbfile,$domain,"} ) {
                my @ns = split(':',$NS{"$dbfile,$domain,"});
                my $ns;
                my $nshost;
                foreach $ns (@ns) {
                    ($ttl,$nshost) = split(',',$ns);
                    # Since I am the primary, don't put me on the list
                    push(@ns_list,$nshost) if $nshost ne $myfqdname;
                }
                sort byorigin @ns_list;
                $ns_list = \@ns_list;
            }
            if ( defined $MX_RECORDS{"$dbfile,$domain,"}) {
                my @mx = split(':',$MX_RECORDS{"$dbfile,$domain,"});
                my $mx;
                my $mxpref;
                my $mxhost;
                sort mxpreference (@mx);
                foreach $mx (@mx) {
                    ($ttl,$mxpref,$mxhost) = split(',',$mx);
                    push(@mx_list,"$mxpref\t$mxhost");
                }
                $mx_list = \@mx_list;
            }
        }
    }
}

1;
