#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:53 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary_Alias::Manage;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: $B8"8B$,$"$j$^$;$s!#(B\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: DNS Create/Delete Alias");

    ### PROCESS CGI DATA

    #require './initialize.pl';
    #Initialize();

    # Collect the data from the form
    my $domain = cleanup_name(scalar($cgi->param('domain_name')));
    if ( $domain eq "" ) {
        $stat->error("$B%I%a%$%s$,A*Br$5$l$F$$$^$;$s!#(B");
    }
    $domain =~ s/\.*$/\./;

    my $alias_host = cleanup_name(scalar($cgi->param('alias_host')));
    if ( $alias_host ne "" ) {
        if ( ( $alias_host =~ s/\./\./) == 0 ) {
            $alias_host = "$alias_host.$domain";
        }
        else {
            $alias_host =~ s/\.*$/\./;
        }
    }

    my $new_alias = cleanup_name(scalar($cgi->param('new_alias')));

    my $rm_alias = cleanup_name(scalar($cgi->param('rm_alias')));
    if ( $rm_alias ne "" ) {
        my ($talias,$thost) = split(' ',$rm_alias);
        push(@rm_alias,$talias);
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("$B%U%)!<%`%G!<%?$N%(%i!<(B");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("$B7Y9p!'<B9T$N3NG'(B",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("$B%U%)!<%`%G!<%?$OG'<1$5$l$^$7$?!#(B");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;
    my @addmessage;
    my @rmmessage;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('$B%m!<%+%k%I%a%$%s$,Dj5A$5$l$F$$$^$;$s!#(B<A HREF="/View/JP/SysAdmin/DNS/Configure_Resolver/Standard.view">$B%m!<%+%k%I%a%$%s@_Dj(B</A>$B$r9T$C$F$/$@$5$$!#(B');
        $stat->ReportErrors("$B%(%i!<!'%I%a%$%s$,Dj5A$5$l$F$$$^$;$s!#(B",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Already Configured
        $stat->error('$B%5!<%P$,=i4|2=$5$l$F$$$^$;$s!#(B<A HREF="/View/JP/SysAdmin/DNS/Configure_Server/Standard.view">DNS$B%5!<%P=i4|2=(B</A>$B$r9T$C$F$/$@$5$$!#!(B');
        $stat->ReportErrors("$B%(%i!<!'%5!<%P$,=i4|2=$5$l$F$$$^$;$s!#(B",'literal');
        print $stat->HTML;
        return;
    }

    if ( read_config($conf_file)  != 0) {
        $stat->error("$B#D#N#S@_Dj%U%!%$%k(B $conf_file $B$rFI$`$3$H$,$G$-$^$;$s!#(B");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("$B%7%9%F%`%(%i!<(B");
        print $stat->HTML;
        return;
        }

   if ( ! defined $PRIMARY{$domain} ) {
        $stat->error("$B$3$N%[%9%H$O<!$N%I%a%$%s$N%W%i%$%^%j%5!<%P$G$O$"$j$^$;$s!'(B$domain");
        $stat->error("$B%[%9%H!'(B$host  $B%(%$%j%"%9!'(B$alias");
        $stat->ReportErrors("$B%7%9%F%`%(%i!<(B");
        print $stat->HTML;
        return;
        }

    $dbfile = $PRIMARY{$domain};
    $dbfile = "$dbdir/$dbfile" if $dbdir ne "";

    if ( read_dbfile($dbfile,$domain)  != 0) {
        $stat->error("$B%I%a%$%s(B $domain $B$N#D#B%U%!%$%k(B $dbfile $B$NFI$_9~$_%(%i!<(B");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("$B%7%9%F%`%(%i!<(B");
        print $stat->HTML;
        return;
        }

    # Remove any selected ALIAS records
    foreach $rm (@rm_alias) {
        if ( defined $ALIASES{"$dbfile,$domain,$rm"} ) {
            unset_cname("$dbfile,$domain,$rm");
            push(@message,"$B%(%$%j%"%9(B $rm $B$N>C5n(B");
        }
        else {
            push(@message,"$B%(%$%j%"%9(B $rm $B$OB8:_$7$^$;$s!#:o=|$5$l$^$;$s$G$7$?!#(B");
        }
    }

    if ( $new_alias ne "" ) {
        if ( defined $A_RECS{"$dbfile,$domain,$new_alias"} ) {
            push(@message,"$rm $B%[%9%H$H$7$FB8:_$7$^$9!#JQ99$O$5$l$F$$$^$;$s!#(B");
        }
        elsif ( defined $ALIASES{"$dbfile,$domain,$new_alias"} ) {
            push(@message,"$rm $B%(%$%j%"%9$H$7$FB8:_$7$^$9!#JQ99$O$5$l$F$$$^$;$s!#(B");
        }
        else {
            set_cname("$dbfile,$domain,$new_alias",$ttl,$alias_host);
            push(@message, "$B%[%9%H(B $alias_host $B$X$N(B $B%(%$%j%"%9(B $new_alias $BDI2C(B");
        }
    }

    if ( $#message < 0 ) {
        $stat->error("$B@_DjJQ99$O$"$j$^$;$s!#(B");
        $stat->ReportErrors("$B%(%$%j%"%9%$%s%U%)%a!<%7%g%s$OJQ99$5$l$F$$$^$;$s!#(B");
        print $stat->HTML;
        return;
    }

    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
            $stat->error("$B%I%a%$%s(B $domain $B$N(BDB$B%U%!%$%k(B $dbfile $B$X$N=q$-9~$_%(%i!<(B");
            $stat->error(@AdminWEB::DNS::error);
            $stat->ReportErrors("$B%7%9%F%`%(%i!<(B");
            print $stat->HTML;
            return;
        }
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named Daemon not Reloaded"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"$B#n#a#m#e#d%G!<%b%s$,%j%m!<%I$5$l$^$7$?!#(B");

    push(@message,"$B%I%a%$%s(B $domain $host $B$rJT=8$7$^$7$?!#(B");
    $stat->Report("$B%3%^%s%I@5>o=*N;(B", \@message);
    print $stat->HTML;
    return;
}
