#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:54 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary_Host::Create;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ץ饤ޥɥᥤؤΥۥȤɲ");

    ### PROCESS CGI DATA

    #require './initialize.pl';
    #Initialize();

    my $domain = cleanup_name(scalar($cgi->param('newhost_domain')));
    if ( $domain ne "" ) {
        $domain =~ s/\.*$/./;
    }
    else {
        $stat->error("ɥᥤ򤵤Ƥޤ");
    }

    my $host = cleanup_name(scalar($cgi->param('newhost_name')));
    $stat->error("ۥȤϤƤޤ") if $host eq "";

    my $ipaddr = cleanup_name(scalar($cgi->param('newhost_ipaddr')));
    if ( $ipaddr eq "" ) {
        $stat->error("ɣХɥ쥹ϤƤޤ") if $ipaddr eq "";
    }
    elsif ( $ipaddr !~ /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/ ) {
        $stat->error("̵ʣɣХɥ쥹Ǥ");
    }

    my $mail = cleanup_name(scalar($cgi->param('newhost_mail')));

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }


    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('ɥᥤƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Resolver/Standard.view">ɥᥤ</A>ԤäƲ');
        $stat->ReportErrors("顼ɥᥤƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Not Configured
        $stat->error('ФƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Server/Standard.view">ģΣӥн</A>ԤäƲ');
        $stat->ReportErrors("顼ФƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    # Now get the data
    if ( read_config($conf_file) != 0 ) {
        $stat->error("$conf_file ե뤬ɤ߹ޤ");
	$stat->error(@AdminWEB::DNS::errors);
        $stat->ReportError("ޥɼ");
	print $stat->HTML;
	return;
    }

    # Make sure we are a Primary
    if ( ! defined $PRIMARY{$domain} ) {
	$stat->error("ΥۥȤ $domain Υץ饤ޥǤϤޤ");
	$stats->ReportError("ץ饤ޥǤϤޤ");
        print $stat->HTML;
        return;
    }

    # Do the work of adding the host
    $dbfile = $PRIMARY{$domain};
    $dbfile = "$dbdir/$dbfile" if $dbdir ne "";
    if ( read_dbfile($dbfile,$domain) != 0 ) {
        $stat->error("ģ¥ե $dbfile ɤ߹ޤ");
	$stat->error(@AdminWEB::DNS::errors);
        $stat->ReportErrors("ޥɼ");
	print $stat->HTML;
	return;
    }

    if ( defined $ALIASES{"$dbfile,$domain,$host"} ) {
        $stat->error('$host ϥꥢȤƤǤƤޤ<A HREF="/View/JP/SysAdmin/DNS/Primary_Alias/Delete/Standard.view">ꥢκ </A> ԤäƲ');
        $stat->error("$domain  $host Ǥޤ");
        $stat->ReportErrors("ޥɼ",'literal');
	print $stat->HTML;
	return;
    }

    if ( defined $A_RECS{"$dbfile,$domain,$host"} ) {
        $stat->error("$host Ƥޤ<A HREF=\"/View/JP/SysAdmin/DNS/Primary_Host/Edit/Standard.view\">Խ</A> ޤϡ<A HREF=\"/View/JP/SysAdmin/DNS/Primary_Host/Delete/Standard.view\"></A> Ʋ");
        $stat->error("<BR>$domain  $host Ǥޤ");
        $stat->ReportErrors("ޥɼ",'literal');
	print $stat->HTML;
	return;
    }

    $ttl = "";
    if ( set_reverse($ipaddr,"$dbfile,$domain,$host") == 0 ) {
        push(@message,"$host Υ꡼Х쥳ɤ򹹿ޤ");
    }
    else {
        push(@message,"$host ΥС쥳ɤ򹹿ǤޤǤ");
    }
    set_arec("$dbfile,$domain,$host",$ttl,$ipaddr);

    if ( defined $MX_RECORDS{"$dbfile,$domain,"} ) {
	@MX = split ( ':',$MX_RECORDS{"$dbfile,$domain,"});
	($mxttl,$mxpref,$mxdefault) = split ( ',',$MX[0]);
	set_mx("$dbfile,$domain,$host",$ttl,"10",$mxdefault);
    }
    if ( $mail =~ /^yes$/i ) {
	set_mx("$dbfile,$domain,$host",$ttl,"5","$host.$domain");
    }

    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
            $stat->error("ģ¥ե $dbfile ˽񤭹ޤǤ");
	    $stat->error(@AdminWEB::DNS::errors);
            $stat->ReportError("ޥɼ");
	    print $stat->HTML;
	    return;
	}
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["ǡϥɤƤޤ"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"ǡϥɤޤ");

    push (@message,"ɥᥤ$domain  ${host} ɲäޤ");
    $stat->Report("ޥｪλ", \@message);
    print $stat->HTML;
    return;
}

