#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:56 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary_Host::Delete::PhaseII;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ģΣӥɥᥤؤΥۥȤɲ");

    ### PROCESS CGI DATA

    # require './initialize.pl';
    # Initialize();

    my $domain = cleanup_name($cgi->param('domain_name'));
    if ( $domain eq "" ) {
        $stat->error("ɥᥤƤޤ");
    }
    else {
        $domain =~ s/\.*$/./;
    }

    my $host = cleanup_name($cgi->param('host_name'));
    push(@hosts,$host) if $host ne "" && $host ne "localhost";

    if ( $#hosts < 0 ) {
        $stat->error("ۥȡꥢ򤵤Ƥޤ");
    }

#    if ( $cgi->param('Action') ne 'Confirmed' ) {
#        $cgi->warnings("˺ޤ");
#    }
    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('ɥᥤƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Resolver/Standard.view">ɥᥤ̾</A>ԤäƲ');
        $stat->ReportErrors("顼ɥᥤƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Not Configured
        $stat->error('ФƤޤ<A HREF="/View/JP/SysAdmin/DNS/Configure_Server/Standard.view">ģΣӥн</A>ԤäƲ');
        $stat->ReportErrors("顼ФƤޤ",'literal');
        print $stat->HTML;
        return;
    }

    if ( read_config($conf_file)  != 0) {
        $stat->error("ģΣե $conf_file ɤ߹ߥ顼Ǥ");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("ƥ२顼");
        print $stat->HTML;
        return;
        }

   if ( ! defined $PRIMARY{$domain} ) {
        $stat->error("ΥۥȤϥɥᥤ $domain Υץ饤ޥꥵФǤϤޤ");
        $stat->error("ۥ $host  ꥢ $alias");
        $stat->ReportErrors("ƥ२顼");
        print $stat->HTML;
        return;
        }

    $dbfile = $PRIMARY{$domain};
    $dbfile = "$dbdir/$dbfile" if $dbdir ne "";

    if ( read_dbfile($dbfile,$domain)  != 0) {
        $stat->error("ɥᥤ $domain Σģ¥ե $dbfile ɤ߹ߥ顼Ǥ");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("ƥ२顼");
        print $stat->HTML;
        return;
        }

    foreach $host (@hosts) {
        if ( defined $A_RECS{"$dbfile,$domain,$host"} ) {
            unset_reverse("$dbfile,$domain,$host");
            unset_arec("$dbfile,$domain,$host");
            push(@message,"$host 쥳ɤޤ");
        }
        if ( defined $MX_RECORDS{"$dbfile,$domain,$host"} ) {
            unset_mx("$dbfile,$domain,$host");
            push(@message,"$host MX쥳ɤޤ");
        }
        if ( defined $HINFO{"$dbfile,$domain,$host"} ) {
            unset_hinfo("$dbfile,$domain,$host");
            push(@message,"$host HINFO쥳ɤޤ");
        }
        if ( defined $TXT{"$dbfile,$domain,$host"} ) {
            unset_txt("$dbfile,$domain,$host");
            push(@message,"$hostԣأԥ쥳ɤޤ");
        }
        if ( defined $WKS{"$dbfile,$domain,$host"} ) {
            unset_wks("$dbfile,$domain,$host");
            push(@message,"$hostףˣӥ쥳ɤޤ");
        }
    }

    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
        $stat->error("ɥᥤ $domain Σģ¥ե $dbfile ν񤭹ߥ顼Ǥ");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("ƥ२顼");
        print $stat->HTML;
        return;
        }
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named ǡϥɤޤ"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"Named ǡ󤬥ɤޤ");

    push (@message,"$domain  ${host} ޤ");
    $stat->Report("ޥｪλ", \@message);
    print $stat->HTML;
}

