#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.4 1997/01/16 22:36:12 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DialupIP::Config_Dynamic;

use AdminWEB::PPP;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
print STDERR $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơʥߥåɣХסγ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    use FileFormat::DNS::Utils;

    my ($numif) = $cgi->param('numif');
    my ($firstip) = canonicalize_ip($cgi->param('firstip'));
    my ($startif) = $cgi->param('startif');

    if (!defined $firstip) {
	$stat->error("̵ʣɣХɥ쥹" . $cgi->param('firstip'));
    }
    if (!defined $startif || $startif !~ /^ppp/) {
	$stat->error("УУХ󥿡ե򤷤Ƥ")
    }
    if (!defined $numif || $numif < 1 || $numif > 254) {
	$stat->error("󥿡եϻѲǽϰϳǤ(1,254ޤ)");
    }

    my $last = $startif;
    $last =~ s/^ppp//;
    $last += ($numif - 1);
    if ($last > (numif('ppp')-1)) {
	$stat->warning("УУХ󥿡եʾˡ");
	$stat->warning("ɣХɥ쥹ƤƤޤ");
	$stat->warning("УУп䤹ɬפ뤫⤷ޤ");
	$stat->warning("륢å״ǹԤȤǤޤ");
	$stat->warning("٤ƤȤȤԤäƲ");
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Ǥϲ¹ԤޤǤ"]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    eval { assign_pool($firstip,$startif,$numif); };
    if ($@) {
	$stat->Report("ޥɤμ¹ԥ顼", [ $@ ]);
    }
    else {
	$stat->Report("ޥｪλ",
	    [ "ɣХɥ쥹 ʥɥ쥹 $numif  ʥߥåɣХסɲäޤ" ]);
    }

    print $stat->HTML;
}
