#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1999/01/13 22:58:13 tks Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DialupIP::Dialin;

use AdminWEB::PPP;
use FileFormat::DNS::Utils;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
print STDERR $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ륤ɣХͥåȥ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    my $SYSFILE = "/etc/ppp.sys";
    my $PASSWD = "/etc/passwd";

    my ($name, $scheme, $ip_addr, @pwds, @proto);
    $name = $cgi->param('account_name');
    $scheme = $cgi->param('ip_scheme');
    $ip_addr = $cgi->param('ip_addr');
    @pwds = $cgi->param('secret');
    @proto = $cgi->param('proto');

    $stat->error("УУСӣ̣ɣФΤɤ餫ޤξ򤵤ʤФʤޤ")
	unless @proto;
    $stat->error("ѥɤפޤ")
	unless $pwds[0] eq $pwds[1];
    $stat->error("̾ޤ")
	if !defined $name || $name eq '';
    $stat->error("̾Ⱦ15ʸʲǤʤƤϤʤޤ")
	if length($name) > 15;
    $stat->error("̾ϥޤळȤǤޤ")
	if $name =~ /:/;
    $stat->error("̾ϥץȤǤʤ饯ޤळȤϤǤޤ")
	unless $name =~ /^[!-~]*$/;
    $stat->error("ӣ̣ɣФϥʥߥåɣХɥå󥰤ȤȤǤޤ")
	if $scheme eq 'dynamic' && $#proto == 0 && $proto[0] eq 'SLIP';

    if ($scheme eq 'dns') {
	$ip_addr = $name if $scheme eq 'dns';
    }
    elsif ($scheme eq 'dotquad') {
	# check ip_address format for validity
	if (!defined $ip_addr || $ip_addr eq '') {
	    $stat->error("ɥåɽȤ硢ɣХɥ쥹Ƥ")
	}
	else {
	    $ip_addr = canonicalize_ip($ip_addr);
	    $stat->error("̵ʣɣХɥ쥹ɽ " . $cgi->param('ip_addr'))
		if !defined $ip_addr;
	}
    }

    # warnings if accounts/ppp.sys entries already exist...

    # check PPP accounts
    if (grep(/PPP/, @proto)) {
	($status, $output) = run_backend('grep', '-q', "^P$name:", $SYSFILE);
	$stat->warning(" P$name ϤǤ¸ߤޤ񤭤ƤǤ")
	    if $status == 0;
	($status, $output) = run_backend('grep', '-q', "^P$name:", $PASSWD);
	$stat->warning("P$name ϤǤ¸ߤޤ񤭤ƤǤ")
	    if $status == 0;
    }

    if (grep(/SLIP/, @proto)) {
	# check SLIP accounts
	($status, $output) = run_backend('grep', '-q', "^S$name:", $SYSFILE);
	$stat->warning(" S$name ϤǤ¸ߤޤ񤭤ƤǤ")
	    if $status == 0;
	($status, $output) = run_backend('grep', '-q', "^S$name:", $PASSWD);
	$stat->warning(" S$name ϤǤ¸ߤޤ")
	    if $status == 0;
    }

    $stat->warning("̾ƬˣФޤϣӤ\n" .
	    "եȥˤɲäޤ\n" .
	    "ʸθơɬפʾ\n" .
	    "ФޤϣӤƲ")
	if $name =~ /^[PS]/;

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Ǥϲ¹ԤޤǤ"]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my ($status, $output, @msgs);

    ### Create PPP and SLIP account(s)
    # set properties to the create account area
    my $acctprop = Create DB::Properties(
	'../../Accounts/Create/' . $_NAME_PROPERTIES);
    my $home_directory = $properties->value('Default_Home');
    my $uid = next_available_uid($acctprop);
    # XXX: should I warn if no netdial group?
    my $gid = (getgrnam('netdial'))[2] || 118;
    my $class = 'dialer';
    my $epwd;
    eval { $epwd = encrypt_passwd($class, $pwds[0]); };
    if ($@) {
	$stat->error($@);
	$stat->ReportErrors("ѥꥨ顼");
	print $stat->HTML;
	exit(0);
    }
    if (grep(/PPP/, @proto)) {
	my @account = (
            $properties->value('Default_PPP_Prefix') . $name,   # login name
	    $epwd,				# encrypted password
	    $uid,				# uid
	    $gid,				# gid
	    $class,				# class
	    0,					# expires
	    0,					# change
	    'PPP Account,,,',			# GECOS
	    $home_directory,			# home directory
	    "/usr/bin/ppp");			# shell

	# create the account
	($status, $output) = put_account(\@account);
	if ($status != 0) {
	    $stat->error(@$output);
	    $stat->ReportErrors("Ⱥ顼");
	    print $stat->HTML;
	    exit(0);
	}

	if ($scheme ne 'dynamic') {
	    eval { set_addrmap("P" . $name, $ip_addr); };
	    if ($@) {
		$stat->error($@);
		$stat->ReportErrors("ɥ쥹ޥåԥ󥰤");
		print $stat->HTML;
		exit(0);
	    }
	}

	eval { set_chap_secret("P" . $name, $pwds[0]); };
	if ($@) {
	    $stat->error($@);
	    $stat->ReportErrors("ãȣ ӣꥨ顼");
	    print $stat->HTML;
	    exit(0);
	}

	eval { set_pppsys("P" . $name, 'tc=Dialin:'); };
	if ($@) {
	    $stat->error($@);
	    $stat->ReportErrors("ppp.sysؤ  P$name ɲå顼");
	    print $stat->HTML;
	    exit(0);
	}

	push(@msgs, "УУХȤɲäޤ P$name.<BR>\n");
    }

    # Do SLIP???
    if (grep(/SLIP/, @proto)) {
	$uid = next_available_uid($acctprop);
	@account = (
            $properties->value('Default_SLIP_Prefix') . $name,  # login name
	    $epwd,				# encrypted password
	    $uid,				# uid
	    $gid,				# gid
	    $class,				# class
	    0,					# expires
	    0,					# change
	    'SLIP Account,,,',			# GECOS
	    $home_directory,			# home directory
	    "/usr/bin/ppp");			# shell

	# create the account
	($status, $output) = put_account(\@account);
	if ($status != 0) {
	    $stat->error(@$output);
	    $stat->ReportErrors("Ⱥ顼");
	    print $stat->HTML;
	    exit(0);
	}

	if (1) {
	    # scheme dynamic doesn't apply to SLIP so we default to DNS
	    # unless an IP address is also given.
	    my $ip = ($cgi->param('ip_addr') || $name);
	    eval { set_addrmap("S" . $name, $ip . " link2"); };
	    if ($@) {
		$stat->error($@);
		$stat->ReportErrors("ɥ쥹ޥåԥ");
		print $stat->HTML;
		exit(0);
	    }
	}

	eval { set_pppsys("S" . $name, 'tc=Dialin:sl:im:id#0:'); };
	if ($@) {
	    $stat->error($@);
	    $stat->ReportErrors("ppp.sys ؤ  S$name ɲå顼");
	    print $stat->HTML;
	    exit(0);
	}

	push(@msgs, "ӣ̣ɣХɲá S$name.<BR>\n");
    }

    $stat->Report("ޥｪλ", [ @msgs ], 'literal');
    print $stat->HTML;
}
