#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.1 1997/01/18 00:07:12 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DialupIP::Dialin;

use AdminWEB::PPP;
use FileFormat::DNS::Utils;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
print STDERR $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ륢ȣɣХͥåȥ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    my $SYSFILE = "/etc/ppp.sys";
    my $SECRETS = "/etc/chap_md5_secrets";
    my ($status, $output);

    my ($server, $account, $phone, $auth, $idle, @pwds);
    $server = $cgi->param('server_name');
    $account = $cgi->param('account_name');
    $phone = $cgi->param('phone_number');
    $auth = $cgi->param('authscheme');
    $idle = $cgi->param('idle');
    @pwds = $cgi->param('secret');

    $stat->error("ѥɤפޤ")
	unless $pwds[0] eq $pwds[1];
    $stat->error("⡼ȥƥ̾ޤ")
	if !defined $server || $server eq '';
    $stat->error("ȣɣĤޤ")
	if !defined $account || $account eq '';
    $stat->error("ֹ椬ޤ")
	if !defined $phone || $phone eq '';

    $stat->error("ƥ̾ϥޤळȤϤǤޤ")
	if $server =~ /:/;
    $stat->error("ƥ̾ϥץȤǤʤ饯ޤळȤϤǤޤ")
	unless $server =~ /^[!-~]*$/;
    $stat->error("̾ϥޤळȤϤǤޤ")
	if $account =~ /:/;
    $stat->error("̾ϥץȤǤʤ饯ޤळȤϤǤޤ")
	unless $account =~ /^[!-~]*$/;

    $stat->error("ɥ֤ϣʾǤʤФʤޤ")
	unless $idle =~ /^\d+$/;

    # warnings if accounts/ppp.sys entries already exist...

    # check accounts
    ($status, $output) = run_backend('grep', '-q', "^$server:", $SYSFILE);
    $stat->warning("륢 $server ϤǤ¸ߤޤ񤭤ƤǤ")
	if $status == 0;

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Ǥϲ¹ԤޤǤ"]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my (@msgs, @pppsys);

    push(@pppsys, "phone-number=$phone", "idle-timeout=$idle");
    push(@pppsys, "immediate");
    
    if ($auth eq 'PAP') {
	push(@pppsys, "pap-peerid=$account", "pap-passwd=$pwds[0]");
    }
    else {
	# CHAP
	push(@pppsys, "chap-name=$account", "chap-secret=$pwds[0]",
	    "chap-allow");

	eval { set_chap_secret($server, $pwds[0]); };
	if ($@) {
	    $stat->error($@);
	    $stat->ReportErrors("ãȣ ӣꥨ顼");
	    print $stat->HTML;
	    exit(0);
	}
    }
    push(@pppsys, "tc=Dialout");

    eval { set_pppsys($server, join(":", @pppsys, '')); };
    if ($@) {
	$stat->error($@);
	$stat->ReportErrors("ppp.sysؤ $server ɲå顼");
	print $stat->HTML;
	exit(0);
    }

    push(@msgs, " $server ФƤΥ륢Ȥꤵޤ<BR>\n");

    $stat->Report("ޥｪλ", [ @msgs ], 'literal');
    print $stat->HTML;
}
