#!/usr/bin/perl5
# Copyright (c) 1997 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.5 1998/07/27 23:59:47 tks Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::GroupGate::Configure::PhaseII;

use AdminWEB::Netstart;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: IPX/SPX Configuration");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    $interface = $cgi->param('interface');
    $standalone = ($cgi->param('standalone') eq 'Standalone');
    $nsaddr = $standalone ? '1H' : '0H';

    eval {
	umask(022);
	$netstart = new AdminWEB::Netstart;

	$netstart->set_misc_data('netcinterfaces', $interface);
	$netstart->set_misc_data('netcserv', $standalone ? '-w 0 -r' : '');
	$netstart->set_misc_data('nsaddr_' . $interface, $nsaddr);

	$netstart->write_netstart();
    };

    if ($@) {
	$stat->Report("Error Executing Command", [ $@ ]);
    }
    else {
	($status, $output) = run_backend('ifconfig', $interface,
		    'ns', $nsaddr, 'up');
	if ($status != 0) {
	    $stat->Report("Error Executing Command", [
		"Couldn't ifconfig $interface for IPX/SPX.\n",
		"/etc/netstart was configured however and may fail.\n",
		@$output,
	    ]);
	}
	else {
	    my @output = ( join('',
		"Configured ",
		$cgi->param('interface'),
		" for ", $cgi->param('standalone'),
		".<BR><BR>\n",
		"You must ",
#		"<A HREF=\"/View/SysAdmin/System/Shutdown/Standard.view\">reboot</A>",
		"<A HREF=\"/View/JP/SysAdmin/System/Shutdown/Standard.view\">reboot</A>",
		" for this change to take affect.",
		
	    ));
	    push(@output, nextphase($cgi)) if initmode($cgi);
	    $stat->Report("Command Successful", \@output, 'literal');
	}
    }

    print $stat->HTML;
}
