#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI $Id$
#

use CGI;

$query = new CGI;

$NSCONFIG="/var/ns-home/admserv/ns-admin.conf";
$STARTADMCMD="/bin/sh -c /var/ns-home/start-admin >/dev/null 2>&1";

if ( ! -f $NSCONFIG ) {
	print $query->header;
	print $query->start_html("FastTrack Configuration Error");
	print <<ETX;
<H1>No FastTrack Administrative Server Configured</H1>
The administration server for FastTrack must be configured 
before you may use this interface.  Once the server has been
initially configured, you may use this interface to administer your 
servers, create new servers, delete servers, etc.
<P>
To set up the initial server, you will need to run 
the <KBD>ns-config</KBD> program as root:
<PRE>
	# /var/ns-home/bin/httpd/ns-config
</PRE>
<P>
Note: accept the default user (root) when prompted ``Run admin 
server as [root]:'.
<P>
Note: when prompted for which browser to use, you should specify 
<KBD>NONE</KBD> and then reload this page to access the server in 
your current browser window.
ETX
	print $query->end_html;
	exit 0;
}

if ( ! open(NSCONFIG, $NSCONFIG) ) {
	print $query->header;
	print $query->start_html("FastTrack Configuration Error");
	print "<H1>FastTrack Administration Server Configuration Error</H1>\n";
	print "Failed to open $NSCONFIG!?!\n";
	print $query->end_html;
	exit 0;
}
while (<NSCONFIG>) {
	/^Port / && do { $port = (split)[1]; };
	/^Security\s*on/ && do { $ssl = 1; };
}
close NSCONFIG;

if ( !defined($port) ) {
	print $query->header;
	print $query->start_html("FastTrack Configuration Error");
	print "<H1>FastTrack Administration Server Configuration Error</H1>\n";
	print "No Port defined in $NSCONFIG!?!\n";
	print $query->end_html;
	exit 0;
}

system($STARTADMCMD);
$host = $query->server_name;
$url = $ssl ? "https://$host:$port" : "http://$host:$port";
print $query->redirect($url);

exit 0;
