# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI initialize.pl,v 1.6 1999/01/13 23:18:53 tks Exp

# View.cgi initialization
sub Initialize {
}

### View specific initializations, called by `Initialize:' in Viewfile
sub InitializeView {
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	Initialize();		# shares with view.cgi Initialize()

	$netstart = new AdminWEB::Netstart;
    }
}

# XXX: should make list_interfaces list configuration data also
sub list_interfaces {
    my $cgi = shift;
    my ($tr, $td);
    my $empty = 1;

    my $table = Create HTML::Markup::HTML2 'TABLE';
    $table->width('100%')->border(0)->cellspacing(0)->cellpadding(0);

    foreach $iface ($netstart->networks) {
	next if $iface =~ /^lo\d+$/;
	next if $iface =~ /^ppp\d+$/;
	next if $iface =~ /^sl\d+$/;
	next if $iface =~ /^pif\d+$/;
	next if $iface =~ /^tun\d+$/;
	$empty = 0;		# found at least one acceptable
	($type) = $iface =~ /^(.*)[1-9]*[0-9]$/;
	$tr = $table->TR;
	$cgi->param('interface', $iface);
	$tr->TH->align("right")->A->href(PhaseURL($cgi, 'PhaseII'))
	    ->Text($iface);
	$td = $tr->TD;
	$td->Text($desc{$type});
	$td->BR;
    }

    $table->TR->TD->Text("You do not appear to have any appropriate network interfaces configured\n") if $empty;

    return join("\n",$table->realize);
}

1;
