#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.18 1997/01/22 16:45:04 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::System::Init;
use AdminWEB::LicenseKeys;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

use FileFormat::DNS::Paths;
use FileFormat::DNS::Utils;
use FileFormat::DNS::Resolver;
use FileFormat::DNS::NamedBoot;

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file:¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơ ƥ");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    my $this_host = $cgi->param('this_host');
    $stat->error("ΥƥΥۥ̾Ʋ")
	unless defined $this_host && $this_host ne '';
    $stat->error("ۥ̾ϣģΣӥɥᥤǤʤΤǤϤޤ")
	unless $this_host =~ m/\../;	# a dot in the middle somewhere

    my $domain;
    # derive domain from $this_host
    $domain = $this_host;
    $domain =~ s/[^\.]+\.//;
    $domain = CanonicalizeDomain($domain);

    my ($admin, $name, $pwd, $pwd2) = (
	$cgi->param('admin_account'),
	$cgi->param('admin_name'),
	$cgi->param('admin_pwd'));

    if (affirmative($admin)) {
	$stat->error("ѥɤפޤ̤ϤƲ")
	    unless $pwd eq $pwd2;
	$stat->error("ɥߥ󥢥̾ʤФʤޤ")
	    unless defined $name && $name ne '';
	$stat->warning("$name ¸ߤޤ񤭤ޤ")
	    if getpwnam($name);
	$stat->error("ɥߥ󥢥ȥѥɤʤФʤޤ")
	    unless defined $pwd && $pwd ne '';
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "DEBUG: $cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Ǥϲ¹ԤޤǤ"]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @msgs;

    ### Set hostname and defroute in /etc/netstart
    eval { $netstart = new AdminWEB::Netstart; };
    if ( $@ ) {
        $stat->error($@);
        $stat->ReportErrors("եɤ߹ߥ顼 /etc/netstart");
        print $stat->HTML;
        exit(0);;
    }
    if (defined $this_host && $this_host ne '') {
	$AdminWEB::Netstart::netstart_misc{'hostname'} = $this_host;
	system("hostname $this_host");
	if (($? >> 8) != 0) {
	    $stat->error("ۥ̾ $this_host: $!");
	    $stat->ReportErrors("ۥ̾ꥨ顼 $this_host");
	    print $stat->HTML;
	    exit(0);;
	}
    }
    my $my_defroute = $cgi->param('defroute');
    $AdminWEB::Netstart::netstart_misc{'defroute'} = $my_defroute
	if defined $my_defroute && $my_defroute ne '';
    eval { $netstart->write_netstart(); };
    if ( $@ ) {
        $stat->error($@);
        $stat->ReportErrors("ե񤭹ߥ顼/etc/netstart");
        print $stat->HTML;
        exit(0);;
    }

    ### Set domain (setup /etc/resolv.conf)
    eval {
        my $r = new FileFormat::DNS::Resolver($_PATH_RESOLVER);
        $r->domain($domain);
        $r->nameserver('0.0.0.0');
        $r->close;
    };
    if ( $@ ) {
        $stat->error($@);
        $stat->ReportErrors("ʥ꥾Хե˽񤭹ߥ顼 $_PATH_RESOLVER");
        print $stat->HTML;
        exit(0);;
    }
    push(@msgs, "꥾ФϽޤɥᥤ̾  $domain<BR>\n");

    ### Set system license key
    my $license_key = $cgi->param('license_key');
    if ($license_key !~ /^\s*none\s*$/i) {
	my ($status, $output) = set_license_key($license_key);
	if ($status != 0) {
	    $stat->Report("饤󥹥ꥨ顼", $output);
	    print $stat->HTML;
	    exit(0);
	}
	push(@msgs, "饤󥹥򥤥󥹥ȡ뤷ޤ<BR>\n");
    }

    ### Create admin account
    if (affirmative($admin)) {
	# set properties to the create account area
	my $properties = Create DB::Properties(
	    '../../Accounts/Create/' . $_NAME_PROPERTIES);
	my $home_directory = "/usr/home/$name";
	my $uid = next_available_uid($properties);
	my $gid = (getgrnam('staff'))[2] || 20;
	my $class = 'staff';
        my $epwd;
        eval { $epwd = encrypt_passwd($class, $pwd); };
	if ($@) {
	    $stat->error($@);
            $stat->ReportErrors("ѥɥ顼");
	    print $stat->HTML;
	    exit(0);
	}
	my @account = (
	    $name,					# login name
	    $epwd,					# encrypted password
	    $uid,					# uid
	    $gid,					# gid
	    $class,					# class
	    0,						# expires
	    0,						# change
	    ',,,',					# GECOS
	    $home_directory,				# home directory
	    "/bin/bash");				# shell

	# create the account
	put_account(\@account);

	my @gids;

	my $maxim_id = (getgrnam('maxim'))[2];
	if (defined $maxim_id) {
	    # add user to the maxim group
	    push(@gids, $maxim_id);
	}
	else {
	    push(@msgs, 'maxim 롼פ¸ߤޤ󡣽ä');
	    push(@msgs, 'ɥߥ桼maximȤޤ');
	    push(@msgs, '롼Ȥǥ󤷤Ƥ');
	    push(@msgs, 'ͣɣͻѤˤϥѥɤɬפǤ<BR>');
	}

	# add user to group wheel also
	my $wheel_id = (getgrnam('wheel'))[2];
	$wheel_id = 0 if !defined $wheel_id;
	push(@gids, $wheel_id);

	setuser_group($name, @gids);

	# install skel
	install_skel($properties->value('Default_Skel_Directory'),
		$home_directory, $uid, $gid, $class,
		$properties->value('Default_Home_Directory_Mode'));

	push(@msgs, "ɥߥ󥢥Ȥɲäޤ $name <BR>\n");
    }

    ### Final Report
    if (initmode($cgi)) {
	$stat->Report("ޥｪλ",
	    [ @msgs, nextphase($cgi) ], 'literal');
    }
    else {
	$stat->Report("ޥｪλ", [ @msgs ], 'literal');
    }

    print $stat->HTML;
}
