#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1996/11/15 17:50:04 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::System::Timezone;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("ơॾ");

    ### PROCESS CGI DATA

    # require './initialize.pl';
    # Initialize();

    my @selects = split('/', $cgi->param('selects'));
    my $selected;
    foreach (@selects) {
	my $foo = $cgi->param("s." . $_);
	if (defined $foo && $foo ne '' && $foo ne '**Unselected**') {
	    if (defined $selected) {
		$stat->error("
Please select only one timezone to be the default for this system.
Individual users can override the default timezone by setting their
TZ environment variable to point to the approriate file in
/usr/share/zoneinfo.");
		last;
	    }

	    $selected = "$_/$foo";
	}
    }
    if (defined $selected) {
	$selected =~ s/^UTC/^Etc/;
	$selected =~ s/^Other\///;
	$selected = '/usr/share/zoneinfo/' . $selected;
    }
    else {
	$stat->error("Please go back and select a timezone, if you aren't
sure what to pick just select ``GMT'' under the ``UTC'' menu.
You can change your selection at any time by copying the approriate
/usr/share/zoneinfo file to /etc/localtime or using the Set Timezone
interface in MaxIM");
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("եǡΥ顼");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("ٹ𡧼¹Ԥγǧ",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("եǡǧޤ");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Ǥϲ¹ԤޤǤ"]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    ### run the command
    my ($status, $output) = run_backend('/bin/cp', $selected, '/etc/localtime');
    if ($status != 0) {
	$stat->Report("ޥɼ¹ԥ顼", $output);
    }
    else {
	$output = [ "Installed $selected in /etc/localtime<BR>\n" ];
	push(@$output, nextphase($cgi)) if initmode($cgi);
	$stat->Report("ޥｪλ", $output, 'literal');
    }

    print $stat->HTML;
}
