# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI initialize.pl,v 1.1 1996/08/29 01:44:52 sanders Exp

# View.cgi initialization
sub Initialize {
}

### View specific initializations, called by `Initialize:' in Viewfile
sub InitializeView {
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	Initialize();		# shares with view.cgi Initialize()

	# XXX
    }
}

# this returns a string for inclusion in the header
# we build a javascript that only lets one form item be selected at a time
sub do_JavaScript {
    q{
	<SCRIPT LANGUAGE="JavaScript">
	<!-- hide script contents --
	var other;		// global other (empty to start)
	function clearOthers(me) {
	    // keeps track of anyone else set and clears them
	    if (other) { other.options[0].selected = 1; }
	    other = me;
	}
	//-- hide script contents -->
	</SCRIPT>

    };
}

sub list_timezones {
    ### get a listing of all the files in /usr/share/zoneinfo
    ### eliminating the "posix" and "right" hierarchies.
    my @tzlist;
    use File::Find;
    # things to ignore at the top level (also sets prune)
    my %ignore = qw(
	right 1 posix 1
	CET 1 CST6CDT 1 EET 1 EST 1 EST5EDT 1
	Factory 1 GB 1 GMT 1 GMT+0 1 GMT-0 1 GMT0 1
	HST 1 MET 1 MST 1 MST7MDT 1 NZ 1 NZ-CHAT 1 PRC 1
	PST8PDT 1 UCT 1 UTC 1 Universal 1 W-SU 1 WET 1
	Zulu 1 posixrules 1);
    &find(
	sub {
	    return if (exists $ignore{$_}
		&& $File::Find::dir eq '/usr/share/zoneinfo'
		&& ($File::Find::prune = 1))
		|| ! -f $_;
	    push(@tzlist, $File::Find::name)
	}, '/usr/share/zoneinfo');

    ### cleanup the list, removing leading pathname changes the
    ### "Etc" directory to UTC and sticks all the stuff at the
    ### very top (not in a subdirectory) into "Other" (for now anyway).
    map { s#^/usr/share/zoneinfo/?##; s#^Etc/#UTC/#; s#^#Other/# unless m#/# }
	@tzlist;

    ### splits up each zone so we can sort by directory and then by file
    my ($parent, $child, %lists);
    foreach (@tzlist) {
	($parent, $child) = split('/', $_);
	$lists{$parent} = [ ] unless exists $lists{$parent};
	push(@{$lists{$parent}}, $child);
    }

    ### build an HTML object structure from the data
    use HTML::Markup::HTML2;
    my $table = Create HTML::Markup::HTML2 'TABLE';
    $table->width('100%')->cellspacing(0)->cellpadding(0);

    ### for each top level directory, make a header and stick
    ### the popup list of files in that directory under it.
    ### $count puts 4 in a row.
    my ($row, $th, $sel);
    my $count = 0;		# counts from 2 to 0, on 0 we get a new row
    foreach (sort keys %lists) {
	# table headers for each parent (geographical location)
	if ($count-- == 0) {
	    $row = $table->TR;
	    $count = 2;
	}
	$th = $row->TH;
	$th->Text($_);
	$th->BR;
	# generate the select for this top level guy
	# TODO: JavaScript these so you can only select one at a time
	my $sel = $th->SELECT->name("s." . $_)->onchange('clearOthers(this)');
	# and the option list for all it's children, plus a free "unselected"
	$sel->OPTION->Text('**Unselected**');
	map { $sel->OPTION->Text($_) } sort @{$lists{$_}};
    }

    ### return a big, honking string
    ### the cgi parameter "selects" is set to the list of select
    ### lists we generated so the cgi program that gets the form
    ### submission knows where to look.
    return join('', qq{<INPUT TYPE="hidden" NAME="selects" value="}
	    . join('/', keys %lists) . qq{">\n}, $table->realize);
}

1;
