#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.8 1996/10/11 20:55:11 sanders Exp
#
# AdminWEB Interface Builder CGI

use lib $ENV{'DOCUMENT_ROOT'};

package AdminWEB::View;

require AdminWEB::View;			# Processes the .view file into HTML
require DB::Properties;			# Properties database Class
require AdminWEB::CGI;
use AdminWEB::Support;
use AdminWEB::Paths;			# site-wide paths

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ ViewMain(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub ViewMain {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('SubView') eq 'Bookmark') {
	print 'Location: ' . subview_bookmark($cgi) . "\r\n\r\n";
	return;
    }

    ### chdir into interface directory
    ($path, $curview) = viewpath($cgi->path_translated);
    chdir($path) || die "chdir($path): $!\n";

    # make sure the CGI parameter `View' is set correctly
    $cgi->param('View', $curview);

    ### setup environment
    # TODO: handle lock timeouts for Properties files
    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: ¤ޤ\n";
    ### Generate the user interface from the *.view file
    my $view = Create AdminWEB::View($cgi, $navigator, $properties);
    $view->load($cgi->path_translated);
    print cgi_header('text/html'), $view->HTML;
}
