sub Initialize {
    $_URL_ACCOUNTS_CHANGE = '/View/SysAdmin/Accounts/Change';
    $_URL_ACCOUNTS_REMOVE = '/View/SysAdmin/Accounts/Remove';
}

sub InitializeView {
    my $cgi = shift;
    if ($cgi->script_name ne $_NAME_HELP) {
	Initialize();
    }
}

sub accountlist {
    my $cgi = shift;
    my %selected; map { $selected{$_} = 1 } $cgi->param('logins');
    # getpwent returns:
    my ($name, $passwd, $uid, $gid, $change, $class,
        $gecos, $dir, $shell, $expire);
    my $output = [ ];
    my $login;
    my $restricted = scalar($cgi->param('logins')) ne '';

    # list all accounts, with those in %selected activated
    setpwent();
    while (($name, $passwd, $uid, $gid, $change, $class,
	    $gecos, $dir, $shell, $expire) = getpwent()) {
	next if $restricted && ! exists $selected{$name};
	$class = 'default' if $class eq '';
	my $full = $gecos; $full =~ s/,.*//;
	push(@$output, fmtaccount(
	    [ '<TH><INPUT TYPE="checkbox" NAME="logins" VALUE="'
	      . encodeurl($name) . '"'
	      . (exists $selected{$name} ? ' CHECKED' : '') . '></TH>' ],
	    $name, $full, $class, $dir));
    }
    endpwent();

    # sort @$output and add the <TABLE> wrapper and headers
    @$output = sort @$output;
    unshift(@$output,
        '<TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR>',
	'<TH></TH>',
        '<TH ALIGN="left">Login</TH>',
        '<TH ALIGN="left">Name</TH>',
        '<TH ALIGN="left">Class</TH>',
        '<TH ALIGN="left">Home Directory<BR></TH></TR>');
    push(@$output, '</TABLE>', "\n");

    join("\n", @$output);
}

1;
