#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.12 1996/10/11 20:55:22 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::Accounts::Search;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    # we don't need the global lock
    # my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: Account Search");

    ### PROCESS CGI DATA

    require './initialize.pl';
    require '../utils.pl';
    Initialize();

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>\n$cgi\n";
	return;
    }

    ### this is a safe operation for Demo mode
    # if ($navigator->value('Demo')) {
    #     $stat->Report("DEMO", ["No action was taken at this time."]);
    #     print $stat->HTML;
    #     exit(0);
    # }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    # getpwent returns:
    my ($name, $passwd, $uid, $gid, $change, $class,
	$gecos, $dir, $shell, $expire);

    # misc state and tmp variables
    my ($pat, $item, $ref, $matched);

    # User specified pattern match options:
    my $patopt = join('', $cgi->param('patopt'));	# pattern match options

    # initialize various data structures used by the pattern matching code
    my %match = (
	'account_name'	=> \$name,
	'realname'	=> \$gecos,
	'uid'		=> \$uid,
	'location'	=> \$gecos,
    );
    foreach $item (keys %match) {
	delete $match{$item} unless $cgi->param($item);
    }

    # %group holds the list of groups we are checking for (by gid)
    my %group;
    foreach $item ($cgi->param('groups')) {
	my $gid = (getgrnam($item))[2];
        $group{$gid} = 1 if $gid;
    }
    # process /etc/groups
    local %groupbyuser;
    {
	my ($group, $gid, $gpasswd, $members) = parsegroup($_PATH_GROUP);
	$gid = $gpasswd = undef;
	my ($user, $grp);
	foreach $grp (keys %$members) {
	    foreach $user (split(/,/, $members->{$grp})) {
		$groupbyuser{$user} .= $group->{$grp} . ',';
	    }
	}
    }

    # %classes holds the list of classes we are checking for (by class name)
    my %classes;
    foreach $item ($cgi->param('class')) {
	$classes{$item} = 1;
    }

    # used by the HTML escaping code
    my %escapes;
    for (0..255) {
	$escapes{chr($_)} = sprintf("%%%02X", $_);
    }

    my @state;
    push(@state, 'Verify=' . $cgi->param('Verify')) if $cgi->param('Verify');
    push(@state, 'Debug=' . $cgi->param('Debug')) if $cgi->param('Debug');

    my $removeall = join ('', '<A HREF="', $_URL_ACCOUNTS_REMOVE, '/',
	$cgi->param('View'), '?', join('&', @state));

    # TODO: doesn't handle /etc/groups list yet, just primary group
    my $output = [ ];
    setpwent();
ACCOUNT:
    while (($name, $passwd, $uid, $gid, $change, $class,
		$gecos, $dir, $shell, $expire) = getpwent()) {

	# pattern match against the items in %match
	foreach $item (keys %match) {
	    $pat = $cgi->param($item);
	    $ref = $match{$item};
	    unless (eval q{ $$ref =~ /$patopt$pat/ }) {
		### check for eval failure
		# TODO: we should move this code up and use $stat->error()
		# to report all pattern failures at once.
		if ($@) {
		    $stat->Report("Invalid Pattern",
			[ "Pattern was: $patopt$pat", $@ ]);
		    print $stat->HTML;
		    return;
		}
		# failed to match -- move on to next account
		next ACCOUNT;
	    }
	}

	# check for primary group in %group

	sub ingroup {
	    my ($name, @gids) = @_;
	    map { return 1 if $groupbyuser{$name} =~ /\b$_\b/ } @gids;
	    return undef;
	}
	next ACCOUNT if $cgi->param('groups') &&
		(! exists $group{$gid} && ! ingroup($name, keys %group));

	# check for class in %classes (empty class is 'default')
	$class = 'default' if $class eq '';
	next ACCOUNT if $cgi->param('class') && ! exists $classes{$class};

	# if we got here then we have a winner
	$matched = 1;			# set a flag

	$removeall .= '&logins=' . encodeurl($name);

	my $full = $gecos; $full =~ s/,.*//;
	push(@$output, fmtaccount(
	    [ '<TH ALIGN="left"><A HREF="'
	    . $_URL_ACCOUNTS_CHANGE . '/' . $cgi->param('View')
	    . '?' . join('&', @state, 'account_name=' . encodeurl($name))
	    . '">' . '[edit]' . '</A></TH>' ],

	    [ '<TH><A HREF="' . $_URL_ACCOUNTS_REMOVE . '/'
	    . $cgi->param('View') . '?'
	    . join('&', @state, 'logins=' . encodeurl($name))
	    . '">' . '[delete]' . '</A></TH>' ],

	    $name, $full, $class, $dir)
	);
    }
    endpwent();

    $removeall .= '">[delete all]</A>';

    # report the results
    if ($matched) {
	# sort @$output and add the <TABLE> wrapper and headers
	@$output = sort @$output;
	unshift(@$output,
	    '<TABLE BORDER=0><TR><TH COLSPAN=2>' . $removeall
	    . '</TH></TR><TR>'
	    . '<TH></TH>'			# edit
	    . '<TH></TH>'			# delete
	    . '<TH ALIGN="left">Login</TH>'
	    . '<TH ALIGN="left">Name</TH>'
	    . '<TH ALIGN="left">Class</TH>'
	    . '<TH ALIGN="left">Home Directory<BR></TH></TR>');
	push(@$output, '</TABLE>');
	$stat->Report("Accounts Found", $output, 'literal');
    }
    else {
	$stat->Report("No matches found", ["Try a less restrictive search"]);
    }
    print $stat->HTML;
}
