#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.9 1999/10/27 20:49:22 polk Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Configure_Server;
use FileFormat::DNS::Paths;
use FileFormat::DNS::Utils;
use FileFormat::DNS::Resolver;
use FileFormat::DNS::NamedBoot;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: DNS Server Initialization");

    ### PROCESS CGI DATA

    # require './initialize.pl';
    # Initialize();

    my $named = new FileFormat::DNS::NamedBoot($_PATH_NAMED_BOOT);

    $dofwd = scalar($cgi->param('dofwd'));
    $dorev = scalar($cgi->param('dorev'));
    $fwddomain = CanonicalizeDomain(scalar($cgi->param('fwd_name')));
    $revdomain = CanonicalizeDomain(scalar($cgi->param('rev_name')));
    $mailhost = CanonicalizeDomain(scalar($cgi->param('mailhost')));
    @aliases = $cgi->param('alias_list');

    my @nameservers;
    push(@nameservers,CanonicalizeDomain(scalar($cgi->param('ns1'))))
	if $cgi->param('ns1');
    push(@nameservers,CanonicalizeDomain(scalar($cgi->param('ns2'))))
	if $cgi->param('ns2');
    push(@nameservers,CanonicalizeDomain(scalar($cgi->param('ns3'))))
	if $cgi->param('ns3');

    $stat->errors("Initialize Forward Domain Selected, but no domain name set")
	if $dofwd eq 'Primary' && (!defined $fwddomain || $fwddomain eq '');

    $stat->errors("Initialize Reverse Domain Selected, but no domain name set")
       if $dorev eq 'Primary' && (!defined $revdomain || $revdomain eq '');

    $r = new FileFormat::DNS::Resolver($_PATH_RESOLVER);
    if (! $r->created) {
	if (! defined $r->domain) {
	    $r->domain($fwddomain);
	}
        elsif ($r->domain ne $fwddomain) {
            if ($cgi->param('Action') ne 'Confirmed') {
                $stat->warning("
The local forward domain you passed ($fwddomain) doesn't agree with
the domain set in $_PATH_RESOLVER (" . $r->domain . ").  If you
continue from this point I will initialize the $_PATH_RESOLVER domain
to $fwddomain");
            }
            else {
		$r->domain($fwddomain);
            }
        }
	# point namesever to ourselves if nothing else is defined
	$r->nameserver('0.0.0.0') unless $r->nameserver;
    }

    my $forwarder = scalar($cgi->param('forwarder')) || '';
    my @forwarders = split(' ', $forwarder);
    foreach $forwarder (@forwarders) {
	$forwarder = canonicalize_ip($forwarder);
	$stat->errors("Illegal IP Address: $forwarder")
	    unless defined $forwarder;
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my $output;
    my @message;

    eval {
	if ($r->created) {
	    $r->domain($fwddomain);
	    $r->nameserver('0.0.0.0');
	    push(@message,"Initialized $_PATH_RESOLVER");
	}
	$r->close;
	$r = undef;

	# now, let's see what we have
	($myfqdn, $fwddomain, $myipaddr) = get_myinfo();

	if (!defined $myfqdn || $myfqdn !~ /\.$/) {
	    $stat->error("Couldn't find this host's name.");
	    $stat->ReportErrors("ERROR: Hostname Not Set");
	    print $stat->HTML;
	    return;
	}

	# Put this host on the nameservers list for the domains...
    	push(@nameservers,CanonicalizeDomain($myfqdn));

	if ($named->created) {
	    # initialize named.boot for this host and
	    $named->init_namedboot($myfqdn, $fwddomain);
	    push(@message,"Initialized $_PATH_NAMED_BOOT");
	}

	if ($dorev eq 'Primary') {
	    # no mailhost on reverse domains
	    my $db = $named->new_primary($revdomain,
		$myfqdn, undef, @nameservers);

	    # $named->set_reverse($myipaddr, $myfqdn);
	    $db->owner(ip_2_inaddrarpa($myipaddr))->PTR('', $myfqdn)
		    if defined $myipaddr;
	    push(@message,"Setup primary service for $revdomain");
	}
	elsif (defined $named->primary($revdomain)) {
	    $named->primary($revdomain, undef);	# turn it off
	    push(@message,"Disabled primary service for $revdomain");
	}

	if ($dofwd eq 'Primary') {
	    my $db = $named->new_primary($fwddomain, $myfqdn,
		$mailhost, @nameservers);
	    $db->owner("localhost.$fwddomain")->A('', '127.0.0.1');

	    push(@message,"Setup primary service for $fwddomain");

	    # if $myfqdn and $fwddomain don't match, we cannot add it
	    # (e.g., hostname=foo.bsdi.com and domain=sub.bsdi.com)
	    if (defined $myipaddr && $myfqdn =~ m/\.\Q$fwddomain\E$/) {
		my $obj = $db->owner($myfqdn);

		# set address
		$obj->A('', $myipaddr);

		# Make it so I can receive mail
		$obj->MX('', 50, $myfqdn);

		### This is done above but is here as a reminder
		# $named->set_reverse($myipaddr, $myfqdn);

		push(@message,"Added $myfqdn to domain $fwddomain");

		# add the aliases that were requested
		foreach $alias (@aliases) {
		    $db->owner($alias . '.' . $fwddomain)->CNAME('', $myfqdn);
		    push(@message,"Added alias, $alias to $myfqdn");
		}
	    }
	    else {
		push(@message,
		    "Cannot add $myfqdn to domain $fwddomain " .
		    (defined $myipaddr ? "(Mismatched domains)" :
			"(No IP Address found)"));
		push(@message,"Could not add the requested aliases either.")
			if @aliases;
	    }
	}
	elsif (defined $named->primary($fwddomain)) {
	    $named->primary($fwddomain, undef);	# turn it off
	    push(@message,"Disabled primary service for $fwddomain");
	}

	if (@forwarders) {
	    # set forwarders
	    $named->forwarders(@forwarders);
	    $named->options('forward-only', 1);
	    push(@message,"This host will forward DNS requests to @forwarders");
	}
	else {
	    # disable forwarders
	    $named->forwarders(undef);
	    $named->options('forward-only', 0);
	    push(@message,"Forwarding disabled");
	}

	$named->close;
	$named = undef;
    };

    if ($@) {
	$stat->error(@message, $@);
        $stat->ReportErrors("Error(s): Partially Completed Command");
        print $stat->HTML;
        return;
    }

    push(@message, "Server Initialized");

    # XXX: setup link to add hosts for the new domain
    # XXX: and rev domain if approriate

    unless ($navigator->value('Demo') || initmode($cgi)) {
	reload_dns();
	push (@message,"Name Daemon Reloaded");
    }

    map { s/$/<BR>/; } @message;
    push(@message, nextphase($cgi)) if initmode($cgi);
    $stat->Report("Command Successful", \@message, 'literal');
    print $stat->HTML;
}
