#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.2 1996/10/11 20:55:27 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Domain_Primary;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: __XXX__");

    ### PROCESS CGI DATA

    __XXX__;
    require './initialize.pl';
    Initialize();

    __XXX__;
    $stat->error("message");
    if (fatal) {
	$stat->ReportErrors("HEADER");
	print $stat->HTML;
	return;
    }

    $stat->warning('Are You Sure?');
    __XXX__;

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    __XXX__;

    ### run the command
    my ($status, $output) = run_backend(@cmd);
    if ($status != 0) {
	$stat->Report("Error Executing Command", $output);
    }
    else {
	$stat->Report("Command Successful", $output);
    }

    print $stat->HTML;
}
