#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1996/10/11 20:55:29 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Domain_Secondary::Edit;
use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

use FileFormat::DNS::Paths;
use FileFormat::DNS::Utils;
use FileFormat::DNS::NamedBoot;

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: DNS Add a Secondary Domain");

    ### PROCESS CGI DATA

    #require './initialize.pl';
    #Initialize();

    # Collect the data from the form
    my $domain = CanonicalizeDomain(scalar($cgi->param('secondary')));
    $stat->error("No Domain Selected") unless defined $domain;
    my $ipaddr = canonicalize_ip(scalar($cgi->param('secondary_ip')));
    $stat->error("Invalid IP Address") unless defined $ipaddr;
    # XXX: convert $ipaddr if hostname with warnings about hanging

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my $named = new FileFormat::DNS::NamedBoot($_PATH_NAMED_BOOT);

    my $sec = $named->secondary($domain);

    if (! defined $sec) {
        $stat->error("This host is not a Secondary server for Domain $domain");
        $stat->ReportErrors("Error");
        print $stat->HTML;
        return;
    }

    # load new value
    $sec->[1] = $ipaddr;
    $named->secondary($domain, $sec);

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named Daemon not Reloaded"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"Named Daemon Reloaded");

    push (@message,"Primary IP changed from $oldip To $ipaddr");
    $stat->Report("Command Succeeded", \@message);
    print $stat->HTML;
    return;
}
