#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:54 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary_Host::Create;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: Add Host To Primary Domain");

    ### PROCESS CGI DATA

    #require './initialize.pl';
    #Initialize();

    my $domain = cleanup_name(scalar($cgi->param('newhost_domain')));
    if ( $domain ne "" ) {
        $domain =~ s/\.*$/./;
    }
    else {
        $stat->error("No Domain Selected");
    }

    my $host = cleanup_name(scalar($cgi->param('newhost_name')));
    $stat->error("No Host Entered") if $host eq "";

    my $ipaddr = cleanup_name(scalar($cgi->param('newhost_ipaddr')));
    if ( $ipaddr eq "" ) {
        $stat->error("No IP Address Entered") if $ipaddr eq "";
    }
    elsif ( $ipaddr !~ /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/ ) {
        $stat->error("Illegal IP Address");
    }

    my $mail = cleanup_name(scalar($cgi->param('newhost_mail')));

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }


    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('Local Domain not defined. Please <A HREF="/View/SysAdmin/DNS/Configure_Resolver/Standard.view">Set the Local Domain Name</A>');
        $stat->ReportErrors("Error: No Domain Defined",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Not Configured
        $stat->error('Server not Initialized. Please <A HREF="/View/SysAdmin/DNS/Configure_Server/Standard.view">Initialize DNS Server</A>');
        $stat->ReportErrors("Error: Server Not Initialized",'literal');
        print $stat->HTML;
        return;
    }

    # Now get the data
    if ( read_config($conf_file) != 0 ) {
        $stat->error("Can't Read Configuration File $conf_file");
	$stat->error(@AdminWEB::DNS::errors);
        $stat->ReportError("Command Failed");
	print $stat->HTML;
	return;
    }

    # Make sure we are a Primary
    if ( ! defined $PRIMARY{$domain} ) {
	$stat->error("This Host is NOT a Primary for $domain");
	$stats->ReportError("Not a Primary");
        print $stat->HTML;
        return;
    }

    # Do the work of adding the host
    $dbfile = $PRIMARY{$domain};
    $dbfile = "$dbdir/$dbfile" if $dbdir ne "";
    if ( read_dbfile($dbfile,$domain) != 0 ) {
        $stat->error("Can't Read DB File $dbfile");
	$stat->error(@AdminWEB::DNS::errors);
        $stat->ReportErrors("Command Failed");
	print $stat->HTML;
	return;
    }

    if ( defined $ALIASES{"$dbfile,$domain,$host"} ) {
        $stat->error('$host already defined as an alias,You should <A HREF="/View/SysAdmin/DNS/Primary_Alias/Delete/Standard.view">Delete </A> the Alias');
        $stat->error("Can't Create $host in $domain");
        $stat->ReportErrors("Command Failed",'literal');
	print $stat->HTML;
	return;
    }

    if ( defined $A_RECS{"$dbfile,$domain,$host"} ) {
        $stat->error("$host already defined, You should <A HREF=\"/View/SysAdmin/DNS/Primary_Host/Edit/Standard.view\">Edit</A> or <A HREF=\"/View/SysAdmin/DNS/Primary_Host/Delete/Standard.view\">Delete</A> it");
        $stat->error("<BR>Can't Create $host in $domain");
        $stat->ReportErrors("Command Failed",'literal');
	print $stat->HTML;
	return;
    }

    $ttl = "";
    if ( set_reverse($ipaddr,"$dbfile,$domain,$host") == 0 ) {
        push(@message,"Updated reverse record for $host");
    }
    else {
        push(@message,"Couldn't update reverse record for $host");
    }
    set_arec("$dbfile,$domain,$host",$ttl,$ipaddr);

    if ( defined $MX_RECORDS{"$dbfile,$domain,"} ) {
	@MX = split ( ':',$MX_RECORDS{"$dbfile,$domain,"});
	($mxttl,$mxpref,$mxdefault) = split ( ',',$MX[0]);
	set_mx("$dbfile,$domain,$host",$ttl,"10",$mxdefault);
    }
    if ( $mail =~ /^yes$/i ) {
	set_mx("$dbfile,$domain,$host",$ttl,"5","$host.$domain");
    }

    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
            $stat->error("Can't Write DB file File $dbfile");
	    $stat->error(@AdminWEB::DNS::errors);
            $stat->ReportError("Command Failed");
	    print $stat->HTML;
	    return;
	}
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named Daemon not Reloaded"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"Named Daemon Reloaded");

    push (@message,"Added ${host} to $domain");
    $stat->Report("Command Succeeeded", \@message);
    print $stat->HTML;
    return;
}

