#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.3 1997/01/23 23:54:57 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DNS::Primary_Host::Edit;
use AdminWEB::DNS;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$_NAME_PROPERTIES: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: DNS Edit a Host");

    ### PROCESS CGI DATA

    #require './initialize.pl';
    #Initialize();

    # Collect the data from the form
    my $domain = cleanup_name(scalar($cgi->param('domain_name')));
    if ( $domain eq "" ) {
        $stat->error("No Domain Selected");
    }
    $domain =~ s/\.*$/\./;

    my $host = cleanup_name(scalar($cgi->param('host_name')));
    if ( $host eq "" ) {
        $stat->error("No Host Selected");
    }

    my $ipaddr = cleanup_name(scalar($cgi->param('host_ip')));
    if ( $ipaddr ne "" && $ipaddr !~ /\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/ ) {
        $stat->error("Illegal Address Entered");
    }

    my $mxhost = cleanup_name(scalar($cgi->param('mxhost')));
    if ( $mxhost ne "" ) {
        if ( ( $mxhost =~ s/\./\./) == 0 ) {
            $mxhost = "$mxhost.$domain";
        }
        else {
            $mxhost =~ s/\.*$/\./;
        }
    }

    my $mxpref = cleanup_name(scalar($cgi->param('mxpref')));
    if ( $mxpref ne "" ) {
        if ( $mxpref !~ /\d*/ ) {
            $stat->error("Preference Value must be a number $mxpref");
        }
        else {
            $stat->error("Preference Value can not be 0") if $mxpref == 0;
        }
    }

    if ( $mxhost ne "" && $mxpref eq "" ) {
        $stat->error("Enter an MX Preference to add an MX Host");
    }
    if ( $mxhost eq "" && $mxpref ne "" ) {
        $stat->error("MX Preference Entered, but no MX Host");
    }

    my $mx_rmlist = cleanup_name(scalar($cgi->param('mx_rmlist')));
    if ( $mx_rmlist ne "" ) {
        push(@mx_rmlist,$mx_rmlist);
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my @message;

    my ($myfqdname,$mydomain,$myipaddr) = get_myinfo();
    if ( $mydomain eq "" ) {
        $stat->error('Local Domain not defined. Please <A HREF="/View/SysAdmin/DNS/Configure_Resolver/Standard.view">Set the Local Domain Name</A>');
        $stat->ReportErrors("Error: No Domain Defined",'literal');
        print $stat->HTML;
        return;
    }

    if ( ! -f $conf_file ) {  # Server Already Configured
        $stat->error('Server not Initialized. Please <A HREF="/View/SysAdmin/DNS/Configure_Server/Standard.view">Initialize DNS Server</A>');
        $stat->ReportErrors("Error: Server Not Initialized",'literal');
        print $stat->HTML;
        return;
    }

    if ( read_config($conf_file)  != 0) {
        $stat->error("Read Error of DNS configuration file $conf_file");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("System Error");
        print $stat->HTML;
        return;
        }

   if ( ! defined $PRIMARY{$domain} ) {
        $stat->error("This Host is not a Primary Server for Domain $domain");
        $stat->error("Host is $host Alias is $alias");
        $stat->ReportErrors("System Error");
        print $stat->HTML;
        return;
        }

    $dbfile = $PRIMARY{$domain};
    $dbfile = "$dbdir/$dbfile" if $dbdir ne "";

    if ( read_dbfile($dbfile,$domain)  != 0) {
        $stat->error("Read Error of DB file $dbfile for domain $domain");
        $stat->error(@AdminWEB::DNS::error);
        $stat->ReportErrors("System Error");
        print $stat->HTML;
        return;
        }

    # Set the A record if it changes, but keep the TTL
    if ( defined $A_RECS{"$dbfile,$domain,$host"} ) {
        my @arec_list = split(':',$A_RECS{"$dbfile,$domain,$host"});
        my ($ottl,$oipaddr) = split(',',$arec_list[0]);
        if ( $oipaddr ne $ipaddr ) {
            unset_arec("$dbfile,$domain,$host");
            set_arec("$dbfile,$domain,$host",$ottl,$ipaddr);
            push(@message,"Changed IP Address from $oipaddr to $ipaddr");
        }
    }

    # Remove any selected MX records
    my($pref,$mex);
    foreach $mx (@mx_rmlist) {
        ($pref,$mex) = split(' ',$mx);
        unset_mx("$dbfile,$domain,$host",$mex);
        push(@message,"Removed MX Record $mx");
    }

    # Add any entered MX records
    if ( $mxpref ne "" && $mxhost ne "" ) {
        set_mx("$dbfile,$domain,$host",$ttl,$mxpref,$mxhost);
        push(@message,"Added MX Record $mxpref $mxhost");
    }

    if ( $#message < 0 ) {
        $stat->error("No changes requested");
        $stat->ReportErrors("Host Information Unchanged");
        print $stat->HTML;
        return;
    }

    foreach $dbfile (keys %DBFILES) {
        if ( write_dbfile($dbfile) != 0 ) {
            $stat->error("Write Error of DB file $dbfile for domain $domain");
            $stat->error(@AdminWEB::DNS::error);
            $stat->ReportErrors("System Error");
            print $stat->HTML;
            return;
        }
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["Named Daemon not Reloaded"]);
	print $stat->HTML;
	exit(0);
    }

    reload_dns();
    push (@message,"Named Daemon Reloaded");

    push(@message,"Edited $host in Domain $domain");
    $stat->Report("Command Succeeded", \@message);
    print $stat->HTML;
    return;
}
