#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.2 1997/01/16 21:38:18 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DialupIP::Config;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

use AdminWEB::PPP;

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
print STDERR $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: Dialup IP Config");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my ($status, $output) = (0, []);

    my $nppp = numif('ppp');
    my $npif = numif('pif');
    my $newppp = $cgi->param('nppp');
    my $newpif = $cgi->param('npif');

    if ($nppp > $newppp) {
	push(@$output, "Lowering the number of PPP interfaces requires a reboot before the change will take effect.\n");
	eval { set_nif('ppp', $newppp, 0); };
	push(@$output, $@) if $@;
	$status = 1 if $@;
    }
    elsif ($nppp < $newppp) {
	push(@$output, "Setting the number of PPP interfaces to $newppp.\n");
	eval { set_nif('ppp', $newppp, 1); };
	push(@$output, $@) if $@;
	$status = 1 if $@;
    }

    if ($npif > $newpif) {
	push(@$output, "Lowering the number of PIF interfaces requires a reboot before the change will take effect.\n");
	eval { set_nif('pif', $newpif, 0); };
	push(@$output, $@) if $@;
	$status = 1 if $@;
    }
    elsif ($npif < $newpif) {
	push(@$output, "Setting the number of PIF interfaces to $newpif.\n");
	eval { set_nif('pif', $newpif, 1); };
	push(@$output, $@) if $@;
	$status = 1 if $@;
    }

    my @auths;
    eval {
	@auths = $cgi->param('authschemes');
	foreach $_ (@auths) { y/A-Z/a-z/; }
	set_pppauth(join(':', @auths));
    };
    if ($@) {
	push(@$output, $@);
	$status = 1;
    }
    else {
	push(@$output, "PPP Auth Allows: @auths\n");
    }

    eval { set_localaddr($cgi->param('local')); };
    if ($@) {
	push(@$output, $@);
	$status = 1;
    }
    else {
	push(@$output, "Local IP Address: " . $cgi->param('local') . "\n");
    }

    if ($status) {
	unshift(@$output, "Partial completion is possible.\n");
	$stat->Report("Error(s) Processing Request", $output, 'literal');
    }
    else {
	$stat->Report("Command Successful", $output);
    }
    print $stat->HTML;
}
