#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.4 1997/01/16 22:36:12 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DialupIP::Config_Dynamic;

use AdminWEB::PPP;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
print STDERR $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: Assign Dynamic IP Pool");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    use FileFormat::DNS::Utils;

    my ($numif) = $cgi->param('numif');
    my ($firstip) = canonicalize_ip($cgi->param('firstip'));
    my ($startif) = $cgi->param('startif');

    if (!defined $firstip) {
	$stat->error("Invalid IP Address: " . $cgi->param('firstip'));
    }
    if (!defined $startif || $startif !~ /^ppp/) {
	$stat->error("You must select exactly one of the PPP Interfaces.")
    }
    if (!defined $numif || $numif < 1 || $numif > 254) {
	$stat->error("Number of interfaces is out of bounds (1,254).");
    }

    my $last = $startif;
    $last =~ s/^ppp//;
    $last += ($numif - 1);
    if ($last > (numif('ppp')-1)) {
	$stat->warning("Your request would assign more IP addresses to");
	$stat->warning("PPP interfaces then you currently have.");
	$stat->warning("You'll need to increase the number of PPP");
	$stat->warning("interfaces in Dialup IP Base Configuration");
	$stat->warning("before you can use all of them.");
    }

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    eval { assign_pool($firstip,$startif,$numif); };
    if ($@) {
	$stat->Report("Error Executing Command", [ $@ ]);
    }
    else {
	$stat->Report("Command Successful",
	    [ "Added $numif IP Addresses to the dynamic IP Pool." ]);
    }

    print $stat->HTML;
}
