#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.1 1997/01/18 00:07:12 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::DialupIP::Dialin;

use AdminWEB::PPP;
use FileFormat::DNS::Utils;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
print STDERR $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: Dialout IP Networking");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    my $SYSFILE = "/etc/ppp.sys";
    my $SECRETS = "/etc/chap_md5_secrets";
    my ($status, $output);

    my ($server, $account, $phone, $auth, $idle, @pwds);
    $server = $cgi->param('server_name');
    $account = $cgi->param('account_name');
    $phone = $cgi->param('phone_number');
    $auth = $cgi->param('authscheme');
    $idle = $cgi->param('idle');
    @pwds = $cgi->param('secret');

    $stat->error("Passwords didn't match.")
	unless $pwds[0] eq $pwds[1];
    $stat->error("Missing the remote system name.")
	if !defined $server || $server eq '';
    $stat->error("Missing the account ID.")
	if !defined $account || $account eq '';
    $stat->error("Missing the phone number.")
	if !defined $phone || $phone eq '';

    $stat->error("System name cannot contain colons.")
	if $server =~ /:/;
    $stat->error("System name cannot contain unprintable characters.")
	unless $server =~ /^[!-~]*$/;
    $stat->error("Account name cannot contain colons.")
	if $account =~ /:/;
    $stat->error("Account name cannot contain unprintable characters.")
	unless $account =~ /^[!-~]*$/;

    $stat->error("Idle time must be 0 or greater")
	unless $idle =~ /^\d+$/;

    # warnings if accounts/ppp.sys entries already exist...

    # check accounts
    ($status, $output) = run_backend('grep', '-q', "^$server:", $SYSFILE);
    $stat->warning("Dialout $server already exists, confirming will overwrite.")
	if $status == 0;

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my (@msgs, @pppsys);

    push(@pppsys, "phone-number=$phone", "idle-timeout=$idle");
    push(@pppsys, "immediate");
    
    if ($auth eq 'PAP') {
	push(@pppsys, "pap-peerid=$account", "pap-passwd=$pwds[0]");
    }
    else {
	# CHAP
	push(@pppsys, "chap-name=$account", "chap-secret=$pwds[0]",
	    "chap-allow");

	eval { set_chap_secret($server, $pwds[0]); };
	if ($@) {
	    $stat->error($@);
	    $stat->ReportErrors("Error Setting CHAP Secret");
	    print $stat->HTML;
	    exit(0);
	}
    }
    push(@pppsys, "tc=Dialout");

    eval { set_pppsys($server, join(":", @pppsys, '')); };
    if ($@) {
	$stat->error($@);
	$stat->ReportErrors("Error Adding $server to ppp.sys");
	print $stat->HTML;
	exit(0);
    }

    push(@msgs, "Dialout To $server Configured.<BR>\n");

    $stat->Report("Command Successful", [ @msgs ], 'literal');
    print $stat->HTML;
}
